
function displayPNxxx ()
{
  var s1 = new Array(new State(0, "a1"),
		     new State(1, "a2"));
  var n1 = new Node("n1", "A", s1, 0,0); 
  n1.cpt = new PTable(new Array(n1),
		      new Array(0.7, 0.3));

  var s2 = new Array(new State(0, "b1"),
		     new State(1, "b2"));
  var n2 = new Node("n2", "B", s2, 160,0);
  n2.cpt = new PTable(new Array(n2,n1),
		      new Array(0.8, 0.2,   // n1=yes
				0.4, 0.6)); // n1=no

  var s3 = new Array(new State(0, "c1"),
		     new State(1, "c2"));
  var n3 = new Node("n3", "C", s3, 320,0);
  n3.cpt = new PTable(new Array(n3,n2),
		      new Array(0.9, 0.1,   // n2=yes
				0.5, 0.5)); // n2=no

  var net = new BayesNet("pn1", "Bayesian Network");
  net.addNode(n1);
  net.addNode(n2);
  net.addNode(n3);
  net.addLink(n1, n2);
  net.addLink(n2, n3);

  //var prop = new FullJointProp(net);
  var prop = new JTreeProp(net, true);
  net.prop = prop;
  prop.propagate(true);

  PN4W.displayFrame(net.id, PN4W.FRAME);
  PN4W.displayNet(net, PN4W.NET);
  //PN4W.displayCPT(net,n1);

  prop.layout(0,0);
  PN4W.displayFrame(prop.id, PN4W.FRAME);
  PN4W.displayNet(prop, PN4W.JTREE);
}


function displayPN ()
{
  dy = 90;
  var sWeather = new Array(new State(0, "gut"),
			   new State(1, "schlecht"));
  var nWeather = new Node("weather", "Wetter", sWeather, 5,dy+15); 
  nWeather.cpt = new PTable(new Array(nWeather),
			    new Array(0.7, 0.3));

  var sTime = new Array(new State(0, "Nacht"),
			new State(1, "Morgen"),
			new State(2, "Tag"),
			new State(3, "Abend"));
  var nTime = new Node("time", "Tageszeit", sTime, 320,dy+0);
  nTime.cpt = new PTable(new Array(nTime),
			 new Array(0.25, 0.25, 0.25, 0.25));

  var sView = new Array(new State(0, "gut"),
			new State(1, "schlecht"));
  var nView = new Node("view", "Sicht", sView, 160,dy+15);
  nView.cpt = new PTable(new Array(nView, nWeather, nTime),
			 new Array(0.60, 0.40,   // wetter=gut       time=nacht 
				   0.30, 0.70,   // wetter=schlecht
				   0.70, 0.30,   // wetter=gut       time=morgen 
				   0.80, 0.20,   // wetter=schlecht
				   0.95, 0.05,   // wetter=gut       time=tag 
				   0.85, 0.15,   // wetter=schlecht
				   0.70, 0.30,   // wetter=gut       time=abend
				   0.80, 0.20)); // wetter=schlecht

  var sFocus = new Array(new State(0, "wach"),
			 new State(1, "mde"));
  var nFocus = new Node("focus", "Konzentration", sFocus, 320,dy+180);
  nFocus.cpt = new PTable(new Array(nFocus, nWeather, nTime),
			  new Array(0.65, 0.35,   // wetter=gut       time=nacht 
				    0.25, 0.75,   // wetter=schlecht
				    0.70, 0.30,   // wetter=gut       time=morgen 
				    0.85, 0.15,   // wetter=schlecht
				    0.95, 0.05,   // wetter=gut       time=tag 
				    0.80, 0.20,   // wetter=schlecht
				    0.75, 0.25,   // wetter=gut       time=abend
				    0.85, 0.15)); // wetter=schlecht

  var sStreet = new Array(new State(0, "griffig"),
			  new State(1, "rutschig"));
  var nStreet = new Node("street", "Strae", sStreet, 5,dy+180);
  nStreet.cpt = new PTable(new Array(nStreet, nWeather),
			   new Array(0.95, 0.05,   // wetter=gut 
				     0.30, 0.70)); // wetter=schlecht

  var sAccident = new Array(new State(0, "wenige"),
			    new State(1, "viele"));
  var nAccident = new Node("accident", "Unflle", sAccident, 160,dy+180);
  nAccident.cpt = new PTable(new Array(nAccident, nStreet, nView, nFocus),
			     new Array(0.95, 0.05,   // street=griffig   view=gut      focus=wach
				       0.25, 0.75,   // street=rutschig
				       0.30, 0.70,   // street=griffig   view=schlecht
				       0.50, 0.50,   // street=rutschig
				       0.45, 0.55,   // street=griffig   view=gut      focus=mde
				       0.65, 0.35,   // street=rutschig
				       0.85, 0.15,   // street=griffig   view=schlecht
				       0.10, 0.90)); // street=rutschig
  
  var net = new BayesNet("pn1", "Bayesian Network");
  net.addNode(nWeather);
  net.addNode(nTime);
  net.addNode(nView);
  net.addNode(nFocus);
  net.addNode(nStreet);
  net.addNode(nAccident);

  net.addLink(nWeather, nStreet);
  net.addLink(nWeather, nView);
  net.addLink(nWeather, nFocus);
  net.addLink(nTime,    nView);
  net.addLink(nTime,    nFocus);
  net.addLink(nView,    nAccident);
  net.addLink(nFocus,   nAccident);
  net.addLink(nStreet,  nAccident);

  //var prop = new FullJointProp(net);
  var prop = new JTreeProp(net, false);
  net.prop = prop;
  var pe = prop.propagate(true);

  PN4W.displayFrame(net.id, PN4W.FRAME);
  PN4W.displayNet(net, PN4W.NET);
  PN4W.displayPePopup(net, 'P(e|M)', pe, 0,0, PN4W.PE);
  //PN4W.displayCPT(net,n1);

  prop.layout(0,0);
  PN4W.displayFrame(prop.id, PN4W.FRAME);
  PN4W.displayNet(prop, PN4W.JTREE);
}
