/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayExamples.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Example networks. To be called in documents e.g. by:
 * <body onload="initPN4Web(1, false, 300,250, 4,4); 
 *               displayABCNet('pn1'); 
 *               displayXXXNet('pnX');"> ... </body>
 */

// LEARNING-ALGORITHMS ==============================================

/**
 * Learning-Example
 */
function displayTrainingNet (netId, learnType)
{
  //try {
    dy = 0;
    var sA = new Array(new State(0, "a1"),
                       new State(1, "a2"));
    var nA = new Node("a", "A", sA, 0,dy+0); 
    nA.cpt = new Float32Table(new Array(nA),
                              new Float32Array([0.7, 0.3]));

    var sB = new Array(new State(0, "b1"),
                       new State(1, "b2"));
    var nB = new Node("b", "B", sB, 0,dy+120);
    nB.cpt = new Float32Table(new Array(nB),
                              new Float32Array([0.9, 0.1]));

    var sC = new Array(new State(0, "c1"),
                       new State(1, "c2"));
    var nC = new Node("c", "C", sC, 160,dy+60);
    nC.cpt = new Float32Table(new Array(nC, nA, nB),
                              new Float32Array([0.60, 0.40,    // a1  b1 
                                                0.10, 0.90,    // a2  b1
                                                0.70, 0.30,    // a1  b2
                                                0.80, 0.20])); // a2  b2

    var sD = new Array(new State(0, "d1"),
                       new State(1, "d2"));
    var nD = new Node("d", "D", sD, 320,dy+60);
    nD.cpt = new Float32Table(new Array(nD, nC),
                              new Float32Array([0.85, 0.15,    // c1
                                                0.25, 0.75])); // c2

    var sE = new Array(new State(0, "e1"),
                       new State(1, "e2"));
    var nE = new Node("e", "E", sE, 480,dy+0);
    nE.cpt = new Float32Table(new Array(nE, nD),
                              new Float32Array([0.95, 0.05,    // d1
                                                0.30, 0.70])); // d2

    var sF = new Array(new State(0, "f1"),
                       new State(1, "f2"));
    var nF = new Node("f", "F", sF, 480,dy+120);
    nF.cpt = new Float32Table(new Array(nF, nD),
                              new Float32Array([0.85, 0.15,    // d1
                                                0.25, 0.75])); // d2

    var sG = new Array(new State(0, "g1"),
                       new State(1, "g2"));
    var nG = new Node("g", "G", sG, 620,dy+60); 
    nG.cpt = new Float32Table(new Array(nG),
                              new Float32Array([0.8, 0.2]));


    var net = new BayesNet(netId, "Bayesian Network");
    net.addNode(nA);
    net.addNode(nB);
    net.addNode(nC);
    net.addNode(nD);
    net.addNode(nE);
    net.addNode(nF);
    net.addNode(nG);

    net.addLink(nA, nC);
    net.addLink(nB, nC);
    net.addLink(nC, nD);
    net.addLink(nD, nE);
    net.addLink(nD, nF);

    var prop = new JTree(net, {}, false);
    prop.layout(190, 400, true);
    decorate(prop.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(prop, PN4W.JTREE);
    net.prop = prop;
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    //PN4W.displayCPT(net,n1);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), 1, PN4W.PE, 1000,0);
    PN4W.propagate(net);

    switch (learnType) {
    case 'EM':
      decorate(net.id + '.samples', false, false, false, false, true, DECO.REDFRAME);
      decorate(net.id + '.param',   false, false, false, false, true, DECO.BLUEFRAME);
      decorate(net.id + '.log',     false, false, false, false, true, DECO.BLACKFRAME);
      var logElem  = document.getElementById(net.id + '.log'); 
      appendNewElement(logElem, 'div', net.id + '.log.content', 'pn4web_log');
      resample(net.id, 100, 0.50);
      break;
    case 'Struct':
      decorate(net.id + '.samples', false, false, false, false, true, DECO.REDFRAME);
      decorate(net.id + '.param',   false, false, false, false, true, DECO.BLUEFRAME);
      decorate(net.id + '.struct',  false, false, false, false, true, DECO.BLUEFRAME);
      decorate(net.id + '.log',     false, false, false, false, true, DECO.BLACKFRAME);
      var logElem  = document.getElementById(net.id + '.log'); 
      appendNewElement(logElem, 'div', net.id + '.log.content', 'pn4web_log');
      resample(net.id, 100);
      restruct(net.id, 'AlphaBeta', 0.5);
      break;
    }

    //} catch (exception) {
    //alert("Training Network: " + exception);
    //}
}

function resample (netId, sampleSize, missRate) 
{ 
  var net = PN4W.nets[netId];

  // sample data
  var sampler = new LWSampler(net, sampleSize, true); // network, numOfSamples, keepSamples
  sampler.id = net.id + '.samples';
  var samples = sampler.sample();
  if (missRate) samples.forget(missRate);
  document.getElementById(sampler.id).innerHTML = ""; // clear
  PN4W.displaySamples(sampler.samples, sampler.id + '.table', document.getElementById(sampler.id), PN4W.SAMPLES);
  vscroll(sampler.id + '.frame', sampler.id + '.area', sampler.id, SCROLL.BLUE); 
  if (!PN4W.samples) PN4W.samples = {};
  PN4W.samples[netId] = samples;

  // undisplay old net
  var net2Id = netId + '.param';
  PN4W.undisplay(PN4W.nets[net2Id]);

  // create new net
  var net2 = net.clone();
  net2.id = net2Id;
  net2.prop = new JTree(net2, {}, false);
  PN4W.displayPePopup(net2, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), 1, PN4W.PE, 1000,0);
  net2.prop.propagate(true, true);

  // learning
  if (missRate) {
    var parametrizer = new EM(20, 0.01, true, false, 0); // maxIter, maxDelta, randomizeCPTs, recreateProp, delay
    var logElem  = document.getElementById(net.id + '.log.content'); 
    var listener = 
    { 
     start   : function ()      { logElem.innerHTML = ""; },
     improve : function (maxDelta, avgDelta) { 
       logElem.innerHTML += ('Step ' + (parametrizer.iter+1) + 
           ' | max. delta = ' + maxDelta.toFixed(4) + 
           ' | avg. delta = ' + avgDelta.toFixed(4) + '<br>');
       vscroll(net.id + '.log.frame', net.id + '.log.area', net.id + '.log', SCROLL.BLUE); 
     },
     stop    : function ()      {
       net2.prop.reload();
       PN4W.propagate(net2, true);	
     }
    };
    parametrizer.addListener(listener);
    parametrizer.learn(net2, net2.getNodes(), samples);
  } else { 
    var parametrizer = new Parametrizer();
    parametrizer.learn(net2, net2.getNodes(), samples);
    net2.prop.reload();
    PN4W.propagate(net2, true);
  }
}

function restruct (netId, criterion, beta) 
{ 
  var net     = PN4W.nets[netId];
  var samples = PN4W.samples[netId];

  var net2 = PN4W.nets[netId + '.param'];

  // undisplay old net
  var net3Id = netId + '.struct';
  var old = PN4W.nets[net3Id];
  PN4W.undisplay(old);

  // create and display network to be learned
  var net3 = net.clone();
  net3.id = net3Id;
  net3.rmLinks();
  for (var nId in net.nodes) { 
    var node = net3.nodes[nId];
    node.adaptCPT(net3.getParents(node, true)); 
    if (old && old.nodes[nId]) { 
      node.x = old.nodes[nId].x; 
      node.y = old.nodes[nId].y; 
    }
  }
  PN4W.displayNet(net3, PN4W.NET); 
  PN4W.displayPePopup(net3, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), 1, PN4W.PE, 1000,0);

  // learning
  var crit;
  switch (criterion) {
  case 'USS':       crit = new USS(net, beta);               break;
  case 'Alpha1':    crit = new Alpha1();                     break;
  case 'AlphaBeta': crit = new AlphaBeta(beta, 0.001, true); break;
  case 'BQ':        crit = new BQ();                         break;
  case 'MDL':       crit = new MDL();                        break;
  default: throw ("Unkown criteria");
  }
  var parametrizer  = new Parametrizer();
  var structurizer2 = new Structurizer(crit, parametrizer, 
                                       0, false, 0.1, 0);   // maxIter, fullReset, randomFactor, delay
  var structurizer3 = new Structurizer(crit, parametrizer, 
                                       20, false, 0.1, 0); // maxIter, fullReset, randomFactor, delay
  var logElem  = document.getElementById(net.id + '.log.content'); 
  var listener = 
  { 
   start    : function ()      { 
    logElem.innerHTML = "Initial Ratings: ";
    var sum = 0, sep = '';
    for (var nId in net3.nodes) {
      var node = net3.nodes[nId];
      var rate = structurizer3.rates[node.id]; sum += rate;
      logElem.innerHTML += (sep + node.name.toHTML() + ': ' + rate.toFixed(2)); 
      sep = ', ';
    }
    logElem.innerHTML += '<br>Total: ' + sum.toFixed(2) + '<br>';
    vscroll(net.id + '.log.frame', net.id + '.log.area', net.id + '.log', SCROLL.BLUE); 
   },
   trial    : function (trial) {},
   favor    : function (trial) {},
   skip     : function (trial) {},
   finalize : function (trial) { 
     var id   = trial.parent.id + '__' + trial.node.id;
     var anim = new Animation(id, 200, 0, new Ease());
     PN4W.displayLink(net3, trial.parent, trial.node, 
                      PN4W.NET.NODE.LINK, null, anim); 
     logElem.innerHTML += ('Add link "' + 
         trial.parent.name.toHTML() + '" -> "' + 
         trial.node.name.toHTML() + '" | Rating(' + 
         trial.node.name.toHTML() + ') = ' + 
         structurizer3.rates[trial.node.id].toFixed(2) + ' | Delta = ' +
         trial.delta.toFixed(2) + ' (incl. random offset)<br>'); 
     vscroll(net.id + '.log.frame', net.id + '.log.area', net.id + '.log', SCROLL.BLUE); 
   },
   stop     : function ()      {
     net3.prop = new JTree(net3, {}, false);
     PN4W.propagate(net3);
     logElem.innerHTML += "Final Ratings: ";
     var sum = 0, sep = '';
     for (var nId in net3.nodes) {
       var node = net3.nodes[nId];
       var rate = structurizer3.rates[node.id]; sum += rate;
       logElem.innerHTML += (sep + node.name.toHTML() + ': ' + rate.toFixed(2)); 
       sep = ', ';
     }
     logElem.innerHTML += '<br>Total: ' + sum.toFixed(2) + '<br>';
     logElem.innerHTML += "Reference Net Ratings: ";
     var sum = 0, sep = '';
     for (var nId in net2.nodes) {
       var node = net2.nodes[nId];
       var rate = structurizer2.rates[node.id]; sum += rate;
       logElem.innerHTML += (sep + node.name.toHTML() + ': ' + rate.toFixed(2)); 
       sep = ', ';
     }
     logElem.innerHTML += '<br>Total: ' + sum.toFixed(2) + '<br>';
     vscroll(net.id + '.log.frame', net.id + '.log.area', net.id + '.log', SCROLL.BLUE); 
   }
  };
  structurizer3.addListener(listener);
  structurizer2.learn(net2, net2.getNodes(), samples);
  structurizer3.learn(net3, net3.getNodes(), samples);
}

