/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayExamples.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Example networks. To be called in documents e.g. by:
 * <body onload="initPN4Web(1, false, 300,250, 4,4); 
 *               displayABCNet('pn1'); 
 *               displayXXXNet('pnX');"> ... </body>
 */

// HYBRID ===========================================================

/**
 * Hybrid-Example (disrete + continuous nodes)
 */
function displayHybridNet (netId, propType)
{
  //try {
    dy = 0;
    var sWeather = new Array(new State(0, "gut"),
                             new State(1, "schlecht"));
    var nWeather = new Node("we", "Wetter", sWeather, 0,dy+15); 
    nWeather.cpt = new Float32Table(new Array(nWeather),
                                    new Float32Array([0.7, 0.3]));
    
    var sTime = new Array(new State(0, "Nacht"),
                          new State(1, "Morgen"),
                          new State(2, "Tag"),
                          new State(3, "Abend"));
    var nTime = new Node("tz", "Tageszeit", sTime, 400,dy+0);
    nTime.cpt = new Float32Table(new Array(nTime),
                                 new Float32Array([0.25, 0.25, 0.25, 0.25]));
    
    var sView = new Array(new State(0, "gut"),
			  new State(1, "schlecht"));
    var nView = new Node("si", "Sicht", sView, 200,dy+15);
    nView.cpt = new Float32Table(new Array(nView, nWeather, nTime),
                                 new Float32Array([0.60, 0.40,    // wetter=gut       time=nacht 
                                                   0.30, 0.70,    // wetter=schlecht
                                                   0.70, 0.30,    // wetter=gut       time=morgen 
                                                   0.80, 0.20,    // wetter=schlecht
                                                   0.95, 0.05,    // wetter=gut       time=tag 
                                                   0.85, 0.15,    // wetter=schlecht
                                                   0.70, 0.30,    // wetter=gut       time=abend
                                                   0.80, 0.20])); // wetter=schlecht
    
    var nFocus = new CGNode("ko", "Konzentration", 0, 100, 400,dy+140);
    var pFocus = new Dim(nFocus.id + ".params", "Konzentration", new Array(new State(-2, "Mean"),
								    new State(-1, "Var")));
    nFocus.cgt = new Float32Table(new Array(pFocus, nWeather, nTime),
                                  new Float32Array([10, 20,    // wetter=gut       time=nacht 
                                                    20, 30,    // wetter=schlecht
                                                    30, 10,    // wetter=gut       time=morgen 
                                                    40, 20,    // wetter=schlecht
                                                    50, 30,    // wetter=gut       time=tag 
                                                    60, 20,    // wetter=schlecht
                                                    70, 10,    // wetter=gut       time=abend
                                                    60, 20])); // wetter=schlecht

    var nStreet = new CGNode("st", "Straße", 0, 100, 0,dy+140);
    var pStreet = new Dim(nStreet.id + ".params", "Straße", new Array(new State(-2, "Mean"),
							       new State(-1, "Var")));
    nStreet.cgt = new Float32Table(new Array(pStreet, nWeather),
                                   new Float32Array([80, 10,    // wetter=gut 
                                                     20, 20])); // wetter=schlecht
    
    var nAccident = new CGNode("un", "Unfälle", 0, 100, 200,dy+180);
    var pAccident = new Dim(nAccident.id + ".params", "Unfälle", new Array(new State(-2, "Mean"),
                                                                           new State(-1, "Var"),
                                                                           nStreet,              // (dim as state)
                                                                           nFocus));             // (dim as state)
    nAccident.cgt = new Float32Table(new Array(pAccident, nView),
                                     new Float32Array([10,  5, 0.5, 1.0,      // view=gut 
                                                       20, 10, 1.0, 2.0]));   // view=schlecht
    
    var net = new BayesNet(netId, "Bayesian Network");
    net.addNode(nWeather);
    net.addNode(nTime);
    net.addNode(nView);
    net.addNode(nFocus);
    net.addNode(nStreet);
    net.addNode(nAccident);
    
    net.addLink(nWeather, nStreet);
    net.addLink(nWeather, nView);
    net.addLink(nWeather, nFocus);
    net.addLink(nTime,    nView);
    net.addLink(nTime,    nFocus);
    net.addLink(nView,    nAccident);
    net.addLink(nFocus,   nAccident);
    net.addLink(nStreet,  nAccident);

    var prop = null;
    switch (propType) {
    case 'junctionTree':
      prop = new HybridJTree(net, {}, false); // network, restr, fillIn2Net, max-propagation
      prop.layout(190, 400, true);
      decorate(prop.id, false, false, false, false, true, DECO.BLUEFRAME);
      PN4W.displayNet(prop, PN4W.JTREE);
      break;
    case 'lwSampler':
      prop = new HybridLWSampler(net, 100, true); // network, numOfSamples, keepSamples
      decorate(prop.id, false, false, false, false, true, DECO.REDFRAME);
      PN4W.displaySamples(prop.samples, prop.id + '.table', document.getElementById(prop.id), PN4W.SAMPLES);
      vscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE); 
      hscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE); 
      break;
    }
    net.prop = prop;
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|M)' : 'P(e|M)'), 1, PN4W.PE, 0,500);
    PN4W.propagate(net);

    //} catch (exception) {
    //alert("Hybrid Network: " + exception);
    //}
}

/**
 * Initialization (without collecting postbags / observations)
 */
function initHybridJTree (netId)
{
  var net = PN4W.nets[netId];
  var prop = net.prop;
  prop.init();
  PN4W.refresh(net);
}

/**
 * Initialization (without observations)
 */
function collectPostbagsHybridJTree (netId)
{
  var net = PN4W.nets[netId];
  var prop = net.prop;
  prop.init();
  prop.collectPostbags();
  PN4W.refresh(net);
}

/**
 * Initialization (without observations)
 */
function observeHybridJTree (netId)
{
  var net = PN4W.nets[netId];
  var prop = net.prop;
  prop.init();
  prop.collectPostbags();
  prop.observe();
  PN4W.refresh(net);
}

/**
 * Full propagation
 */
function fullHybridJTree (netId)
{
  var net = PN4W.nets[netId];  
  PN4W.propagate(net);
}
