/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayExamples.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Example networks. To be called in documents e.g. by:
 * <body onload="initPN4Web(1, false, 300,250, 4,4); 
 *               displayABCNet('pn1'); 
 *               displayXXXNet('pnX');"> ... </body>
 */

// DISPLAY ARBITRARY GENIE-NETWORKS =================================

/**
 * Display arbitrary Genie networks (*.xdsl)
 */
function displayGenieNet (netId, fileName, xScale, yScale, xoffset, yoffset, propType, maxProp)
{
  try {
    
    // defaults
    if (!propType) propType = 'junctionTree'; 
    
    // create network
    var net = new BayesNet(netId, '');
    
    // callback to create a propagator after the 
    // network has been loaded from a xdsl file
    var callback = function ()
    {
      net.id = netId; // we need the network to have that Id to be displayed correctly
      
      // create a propagator
      var prop;
      switch (propType) {
      case 'fullJoint': 
        prop = new FullJoint(net, maxProp);
        decorate(prop.id, false, false, false, false, true, DECO.REDFRAME);
        if (document.getElementById(prop.id + '.frame')) {
          PN4W.displayPTable(prop.fjpt, prop.id + '.table', document.getElementById(prop.id), PN4W.FJPTABLE);
          vscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE); 
          hscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE);
        }
        break;
      case 'junctionTree':
        prop = new JTree(net, {}, false, maxProp); // network, restr, fillIn2Net, max-propagation
        prop.layout(190, 400, true);
        if (document.getElementById(prop.id + '.frame')) {
          decorate(prop.id, false, false, false, false, true, DECO.BLUEFRAME);
          PN4W.displayNet(prop, PN4W.JTREE);
        }
        break;
      case 'loopyBelief':
        prop = new LoopyBelief(net, 10, maxProp);
        if (document.getElementById(prop.id + '.frame')) {
          decorate(prop.id, false, false, false, false, true, DECO.BLUEFRAME);
          PN4W.displayNet(prop, PN4W.LOOPYBELIEF);
        }
        break;
      case 'lwSampler':
        prop = new LWSampler(net, 100, true); // network, numOfSamples, keepSamples
        if (document.getElementById(prop.id + '.frame')) {
          decorate(prop.id, false, false, false, false, true, DECO.REDFRAME);
          PN4W.displaySamples(prop.samples, prop.id + '.table', document.getElementById(prop.id), PN4W.SAMPLES);
          vscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE); 
          hscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE);
        }
        break;
      case 'gibbsSampler':
        prop = new GibbsSampler(net, 
                                100, 25, 10,   // numOfSamples, reSampleIn, burnIn, 
                                0, 50, true);  // minWeight, maxTrials, keepSamples
        if (document.getElementById(prop.id + '.frame')) {
          decorate(prop.id, false, false, false, false, true, DECO.REDFRAME);
          decorate(prop.id + '.mbnet', false, false, false, false, true, DECO.BLUEFRAME);
          PN4W.displayNet(prop.mbNet, PN4W.MARKOVBLANKETNET);
          PN4W.displaySamples(prop.samples, prop.id + '.table', document.getElementById(prop.id), PN4W.SAMPLES);
          vscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE); 
          hscroll(prop.id + '.frame', prop.id + '.area', prop.id, SCROLL.BLUE);
        }
        break;
      default:
        throw ("Unkown propagator type");
      }
      net.prop = prop;
            
      // initial propagation
      var pe = prop.propagate(true, true);

      // show network
      decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
      PN4W.displayNet(net, PN4W.NET);
      PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 0,0);
    };
    
    // errorhandler to be called in case of errors
    var errorhandler = function (msg)
    {
      alert(msg);
    };
    
    // read/parse network from a xdsl-file
    var url = document.URL.substr(0, document.URL.search(/[^\/]+\.html/)) + fileName;
    net.readXDSL(url, callback, errorhandler, xScale, yScale, xoffset, yoffset);

  } catch (exception) {
    alert("Genie network error: " + exception);
  }
}
