/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayExamples.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Example networks. To be called in documents e.g. by:
 * <body onload="initPN4Web(1, false, 300,250, 4,4); 
 *               displayABCNet('pn1'); 
 *               displayXXXNet('pnX');"> ... </body>
 */

// HMM (DYNAMIC BAYESIAN NETWORK) ===================================

/**
 * H(t-1) -> H(t) -> O(t)
 */
function displayHMMNet (netId)
{
  try {
    var s1 = new Array(new State(0, "s1"),
                       new State(1, "s2"),
                       new State(2, "s3"),
                       new State(4, "s4"));
    var n1 = new Node("n1", "Hidden(t-1)", s1, 0,0); 
    n1.cpt = new Float32Table(new Array(n1),
                              new Float32Array([0.25, 0.25, 0.25, 0.25])); // all states the same prop!

    var s2 = new Array(new State(0, "s1"),
                       new State(1, "s2"),
                       new State(2, "s3"),
                       new State(4, "s4")); // same as s1!
    var n2 = new Node("n2", "Hidden(t)", s2, 250,0);
    n2.cpt = new Float32Table(new Array(n2,n1),
                              new Float32Array([0.99, 0.01, 0.00, 0.00,
                                                0.00, 0.99, 0.01, 0.00,
                                                0.00, 0.00, 0.99, 0.01,
                                                0.01, 0.00, 0.00, 0.99]));

    var s3 = new Array(new State(0, "s1"),
                       new State(1, "s2"),
                       new State(2, "s3"),
                       new State(4, "s4"));
    var n3 = new Node("n3", "Observed(t)", s3, 250,140);
    n3.cpt = new Float32Table(new Array(n3,n2),
                              new Float32Array([0.60, 0.15, 0.10, 0.15, 
                                                0.15, 0.60, 0.15, 0.10,
                                                0.10, 0.15, 0.60, 0.15,
                                                0.15, 0.10, 0.15, 0.60]));

    var net = new DynBayesNet(netId, "Hidden Markov Model");
    net.addDynNode(n1, n2);
    net.addNode(n3);
    net.addLink(n1, n2);
    net.addLink(n2, n3);
    
    //var prop = new DynJTree(net, {}, 100, false); 
    var prop = new DynFullJoint(net, 100);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 0,600);
    PN4W.displayPePopup(net, 'Time', prop.t, PN4W.TIME, 100,600);
    PN4W.displayPTPopup(net, n3, PN4W.CPT, n3.x+120, n3.y);
    PN4W.displayPTPopup(net, n2, PN4W.CPT, n2.x+120, n2.y);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    PN4W.displayCtrl(net, PN4W.CTRL);
    //vscroll(net.id + '.frame', net.id + '.area', net.id, SCROLL.BLUE); 
    //hscroll(net.id + '.frame', net.id + '.area', net.id, SCROLL.BLUE); 
        
  } catch (exception) {
    alert("HMM Network: " + exception);
  }
}
