/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayExamples.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Example networks. To be called in documents e.g. by:
 * <body onload="initPN4Web(1, false, 300,250, 4,4); 
 *               displayABCNet('pn1'); 
 *               displayXXXNet('pnX');"> ... </body>
 */


// ABC ==============================================================

/*
 * A->B->C
 */
function displayABCNet (netId)
{
  try {
    var s1 = new Array(new State(0, "a1"),
                       new State(1, "a2"));
    var n1 = new Node("n1", "A", s1, 0,0); 
    n1.cpt = new Float32Table(new Array(n1),
                              new Float32Array([0.7, 0.3]));

    var s2 = new Array(new State(0, "b1"),
                       new State(1, "b2"));
    var n2 = new Node("n2", "B", s2, 160,0);
    n2.cpt = new Float32Table(new Array(n2,n1),
                              new Float32Array([0.8, 0.2,   // n1=yes
                                                0.4, 0.6])); // n1=no

    var s3 = new Array(new State(0, "c1"),
                       new State(1, "c2"));
    var n3 = new Node("n3", "C", s3, 320,0);
    n3.cpt = new Float32Table(new Array(n3,n2),
                              new Float32Array([0.9, 0.1,   // n2=yes
                                                0.5, 0.5])); // n2=no
    
    var net = new BayesNet(netId, "ABC-Network");
    net.addNode(n1);
    net.addNode(n2);
    net.addNode(n3);
    net.addLink(n1, n2);
    net.addLink(n2, n3);
    
    //var prop = new FullJoint(net);
    var prop = new JTree(net, {}, true);
    //var prop = new LoopyBelief(net, 10);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 600,600);
    PN4W.displayPTPopup(net, n3, PN4W.CPT);
    PN4W.displayPTPopup(net, n2, PN4W.CPT, n2.x-50);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    
    prop.layout(0,320, true);
    decorate(prop.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(prop, PN4W.JTREE);
    PN4W.displayPTPopup(prop, prop.nodes['c0'], PN4W.JPT);
    PN4W.displayPTPopup(prop, prop.nodes['c1'], PN4W.JPT);
    PN4W.displayPTPopup(prop, prop.children['c1']['c0'], PN4W.JPT);
    
  } catch (exception) {
    alert("ABC Network: " + exception);
  }
}


// DESEASE TEST =====================================================

/**
 * Desease X -> Test
 */
function displayDeseaseTestNet (netId)
{
  try {
    var s1 = new Array(new State(0, "krank"),
                       new State(1, "gesund"));
    var n1 = new Node("n1", "Krankheit X", s1, 0,0); 
    n1.cpt = new Float32Table(new Array(n1),
                              new Float32Array([0.0001, 0.9999]));

    var s2 = new Array(new State(0, "positiv"),
                       new State(1, "negativ"));
    var n2 = new Node("n2", "Test auf X", s2, 160,0);
    n2.cpt = new Float32Table(new Array(n2,n1),
                              new Float32Array([0.999, 0.001,    // n1=krank
                                                0.005, 0.995])); // n1=gesund

    var net = new BayesNet(netId, "Test auf Krankheit X");
    net.addNode(n1);
    net.addNode(n2);
    net.addLink(n1, n2);
    
    var prop = new FullJoint(net);
    //var prop = new JTree(net, {}, true);
    //var prop = new LoopyBelief(net, 10);
    //var prop = new LWSampler(net, 10, true);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 500,0);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    PN4W.displayPTPopup(net, n2, PN4W.CPT);
    //vscroll(net.id + '.frame', net.id + '.area', net.id, SCROLL.BLUE); 
    //hscroll(net.id + '.frame', net.id + '.area', net.id, SCROLL.BLUE); 

  } catch (exception) {
    alert("Desease Test Network: " + exception);
  }
}

function setIll (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n1'].f.values[1] < 1) { 
    unsetDeseaseAndTest(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 0);
    net.nodes['n2'].f.values = new Array(1, 1);
    PN4W.propagate(net);
  }
}

function setFit (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n1'].f.values[0] < 1) { 
    unsetDeseaseAndTest(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(0, 1);
    net.nodes['n2'].f.values = new Array(1, 1);
    PN4W.propagate(net);
  }
}

function setPositive (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.values[1] < 1) { 
    unsetDeseaseAndTest(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(1, 0);
    PN4W.propagate(net);
  }
}

function setNegative (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.values[0] < 1) { 
    unsetDeseaseAndTest(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(0, 1);
    PN4W.propagate(net);
  }
}

function unsetDeseaseAndTest (netId) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['n1'].f.values = new Array(1, 1);
  net.nodes['n2'].f.values = new Array(1, 1);
  PN4W.propagate(net);
}


// EXPLAINING AWAY ==================================================

/*
 * Explaining away (Regen->Strasse<-Wasserrohrbruch)
 */
function displayExplainingAwayNet (netId)
{
  try {
    var s1 = new Array(new State(0, "ja"),
                       new State(1, "nein"));
    var n1 = new Node("n1", "Regen", s1, 0,0); 
    n1.cpt = new Float32Table(new Array(n1),
                              new Float32Array([0.2, 0.8]));

    var s2 = new Array(new State(0, "ja"),
                       new State(1, "nein"));
    var n2 = new Node("n2", "Wasserrohrbruch", s2, 300,0);
    n2.cpt = new Float32Table(new Array(n2),
                              new Float32Array([0.05, 0.95]));

    var s3 = new Array(new State(0, "nass"),
                       new State(1, "trocken"));
    var n3 = new Node("n3", "Straße", s3, 150,80);
    n3.cpt = new Float32Table(new Array(n3,n1,n2),
                              new Float32Array([0.95, 0.05,   // n1=yes n2=yes
                                                0.90, 0.10,   // n1=no
                                                0.90, 0.10,   // n1=yes n2=no
                                                0.01, 0.99])); // n1=no

    var net = new BayesNet(netId, "Explaining-Away-Network");
    net.addNode(n1);
    net.addNode(n2);
    net.addNode(n3);
    net.addLink(n1, n3);
    net.addLink(n2, n3);
    
    var prop = new FullJoint(net);
    //var prop = new JTree(net, {}, true);
    //var prop = new LWSampler(net, 100, true);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 0,500);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    PN4W.displayPTPopup(net, n2, PN4W.CPT);
    PN4W.displayPTPopup(net, n3, PN4W.CPT);
    
  } catch (exception) {
    alert("Explaining Away Network: " + exception);
  }
}

function setWet (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n3'].f.values[1] <  1 && 
      net.nodes['n2'].f.values[1] == 1) { 
    unsetWetAndBroken(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(1, 1);
    net.nodes['n3'].f.values = new Array(1, 0);
    PN4W.propagate(net);
  }
}

function setWetAndBroken (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.values[1] < 1) { 
    setWet(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(1, 0);
    net.nodes['n3'].f.values = new Array(1, 0);
    PN4W.propagate(net);
  }
}

function unsetWetAndBroken (netId) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['n1'].f.values = new Array(1, 1);
  net.nodes['n2'].f.values = new Array(1, 1);
  net.nodes['n3'].f.values = new Array(1, 1);
  PN4W.propagate(net);
}

// UNDIRECTED =======================================================

/**
 * Demonstrates an undirected connection (A->Connection_Node<-C)
 */
function displayUndirectedNet (netId)
{
  try {
    var s1 = new Array(new State(0, "a1"),
		       new State(1, "a2"));
    var n1 = new Node("n1", "A", s1, 0,0); 
    n1.cpt = new Float32Table(new Array(n1),
			new Float32Array([0.5, 0.5]));
    
    var s2 = new Array(new State(0, "b1"),
		       new State(1, "b2"));
    var n2 = new Node("n2", "B", s2, 300,0);
    n2.cpt = new Float32Table(new Array(n2),
			new Float32Array([0.5, 0.5]));
    
    var s3 = new Array(new State(0, "plausibel"),
		       new State(1, "unplausibel"));
    var n3 = new Node("n3", "(Verbindung)", s3, 150,80);
    n3.cpt = new Float32Table(new Array(n3,n1,n2),
			new Float32Array([0.93, 0.07,    // n1=a1 n2=b1
			                  0.05, 0.95,    // n1=a2
			                  0.01, 0.99,    // n1=a1 n2=b2
			                  0.90, 0.10])); // n1=a2
    n3.f.values = new Array(1, 0); // set evidence
    
    var net = new BayesNet(netId, "Undirected Connection Network");
    net.addNode(n1);
    net.addNode(n2);
    net.addNode(n3);
    net.addLink(n1, n3);
    net.addLink(n2, n3);
    
    var prop = new FullJoint(net);
    //var prop = new JTree(net, {}, true);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 0,500);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    PN4W.displayPTPopup(net, n2, PN4W.CPT);
    PN4W.displayPTPopup(net, n3, PN4W.CPT);
    
  } catch (exception) {
    alert("Undirected Connection Network: " + exception);
  }
}


// SOFT-EVIDENCE ====================================================

/**
 * Soft-evidence via a (virtual) node
 */
function displaySoftEvidenceNet (netId)
{
  try {
    var s1 = new Array(new State(0, "a1"),
		       new State(1, "a2"));
    var n1 = new Node("n1", "A", s1, 0,100); 
    n1.cpt = new Float32Table(new Array(n1),
			new Float32Array([0.7, 0.3]));
    
    var s2 = new Array(new State(0, "b1"),
		       new State(1, "b2"),
		       new State(2, "b3"));
    var n2 = new Node("n2", "B", s2, 160,100);
    n2.cpt = new Float32Table(new Array(n2,n1),
			new Float32Array([0.7, 0.2, 0.1,    // n1=a1
			                  0.1, 0.6, 0.3])); // n1=a2
    
    var s3 = new Array(new State(0, "c1"),
		       new State(1, "c2"));
    var n3 = new Node("n3", "C", s3, 320,100);
    n3.cpt = new Float32Table(new Array(n3,n2),
			new Float32Array([0.9, 0.1,    // n2=b1
			                  0.6, 0.4,    // n2=b2
			                  0.2, 0.8])); // n2=b3

    var s4 = new Array(new State(0, "set"),
		       new State(1, "(unused)"));
    var n4 = new Node("n4", "Soft-Evid.", s4, 160,230);
    n4.cpt = new Float32Table(new Array(n4,n2),
			new Float32Array([0.8, 0.2,   // n2=b1
			                  0.4, 0.6,   // n2=b2
			                  0.2, 0.8])); // n2=b3
    
    var net = new BayesNet(netId, "ABC-Network");
    net.addNode(n1);
    net.addNode(n2);
    net.addNode(n3);
    net.addNode(n4);
    net.addLink(n1, n2);
    net.addLink(n2, n3);
    net.addLink(n2, n4);
    
    var prop = new FullJoint(net);
    //var prop = new JTree(net, {}, true);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 0,500);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    PN4W.displayPTPopup(net, n2, PN4W.CPT, n2.x, 0);
    PN4W.displayPTPopup(net, n3, PN4W.CPT);
    PN4W.displayPTPopup(net, n4, PN4W.CPT);
    
  } catch (exception) {
    alert("Soft Evidence Network: " + exception);
  }
}

function setMultiSoft (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.values[2] < 1) { 
    unsetSoft(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(1, 1, 0);
    net.nodes['n3'].f.values = new Array(1, 1);
    net.nodes['n4'].f.values = new Array(1, 1);
    PN4W.propagate(net);
  }
}

function setBeliefSoft (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.max() < 1) { 
    unsetSoft(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(8/14, 4/14, 2/14);
    net.nodes['n3'].f.values = new Array(1, 1);
    net.nodes['n4'].f.values = new Array(1, 1);
    PN4W.propagate(net);
  }
}

function setBeliefByDummySoft (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n4'].f.values[1] < 1) { 
    unsetSoft(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(1, 1, 1);
    net.nodes['n3'].f.values = new Array(1, 1);
    net.nodes['n4'].f.values = new Array(1, 0);
    PN4W.propagate(net);
  }
}

function unsetSoft (netId) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['n1'].f.values = new Array(1, 1);
  net.nodes['n2'].f.values = new Array(1, 1, 1);
  net.nodes['n3'].f.values = new Array(1, 1);
  net.nodes['n4'].f.values = new Array(1, 1);
  PN4W.propagate(net);
}

// ZONK =============================================================

/**
 * Zonk-Network
 */
function displayZonkNet (netId)
{
  try {
    var s1 = new Array(new State(0, "Tor 1"),
		       new State(1, "Tor 2"),
		       new State(2, "Tor 3"));
    var n1 = new Node("n1", "Wahl", s1, 0,320); 
    n1.cpt = new Float32Table(new Array(n1),
			new Float32Array([1/3, 1/3, 1/3]));
    
    var s2 = new Array(new State(0, "Tor 1"),
		       new State(1, "Tor 2"),
		       new State(2, "Tor 3"));
    var n2 = new Node("n2", "Preis", s2, 150,180);
    n2.cpt = new Float32Table(new Array(n2),
			new Float32Array([1/3, 1/3, 1/3]));
    
    var s3 = new Array(new State(0, "Tor 1"),
		       new State(1, "Tor 2"),
		       new State(2, "Tor 3"));
    var n3 = new Node("n3", "Quizmaster", s3, 0,180);
    n3.cpt = new Float32Table(new Array(n3,n1,n2),
			new Float32Array([0.0, 0.5, 0.5,    // n1=Tor1 n2=Tor1
			                  0.0, 0.0, 1.0,    // n1=Tor2
			                  0.0, 1.0, 0.0,    // n1=Tor3
			                  0.0, 0.0, 1.0,    // n1=Tor1 n2=Tor2
			                  0.5, 0.0, 0.5,    // n1=Tor2
			                  1.0, 0.0, 0.0,    // n1=Tor3
			                  0.0, 1.0, 0.0,    // n1=Tor1 n2=Tor3
			                  1.0, 0.0, 0.0,    // n1=Tor2
			                  0.5, 0.5, 0.0])); // n1=Tor3
    
    var net = new BayesNet(netId, "Zonk-Network");
    net.addNode(n1);
    net.addNode(n2);
    net.addNode(n3);
    net.addLink(n1, n3);
    net.addLink(n2, n3);
    
    var prop = new FullJoint(net);
    //var prop = new JTree(net, {}, true);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 500,0);
    PN4W.displayPTPopup(net, n1, PN4W.CPT, n1.x+120, n1.y+30);
    PN4W.displayPTPopup(net, n2, PN4W.CPT);
    PN4W.displayPTPopup(net, n3, PN4W.CPT, 0, 0);
    
  } catch (exception) {
    alert("Zonk Network: " + exception);
  }
}

function setChooseDoor1 (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n1'].f.values[1] <  1 && 
      net.nodes['n3'].f.values[0] == 1) { 
    unsetZonk(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 0, 0);
    net.nodes['n2'].f.values = new Array(1, 1, 1);
    net.nodes['n3'].f.values = new Array(1, 1, 1);
    PN4W.propagate(net);
  }
}

function setOpenDoor2 (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n1'].f.values[1] < 1 && 
      net.nodes['n3'].f.values[0] < 1) { 
    setChooseDoor1(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 0, 0);
    net.nodes['n2'].f.values = new Array(1, 1, 1);
    net.nodes['n3'].f.values = new Array(0, 1, 0);
    PN4W.propagate(net);
  }
}

function unsetZonk (netId) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['n1'].f.values = new Array(1, 1, 1);
  net.nodes['n2'].f.values = new Array(1, 1, 1);
  net.nodes['n3'].f.values = new Array(1, 1, 1);
  PN4W.propagate(net);
}


// SIMPSON-PARADOX ==================================================

/**
 * Simpson-Paradox-Network
 */
function displaySimpsonParadoxNet (netId)
{
  try {
    var s1 = new Array(new State(0, "leicht"),
		       new State(1, "schwer"));
    var n1 = new Node("n1", "Krankheit", s1, 0,0); 
    n1.cpt = new Float32Table(new Array(n1),
			new Float32Array([0.5, 0.5]));
    
    var s2 = new Array(new State(0, "A"),
		       new State(1, "B"));
    var n2 = new Node("n2", "Krankenhaus", s2, 300,0);
    n2.cpt = new Float32Table(new Array(n2,n1),
			new Float32Array([0.4, 0.6,
			                  0.8, 0.2]));
    
    var s3 = new Array(new State(0, "geheilt"),
		       new State(1, "krank"));
    var n3 = new Node("n3", "Heilung", s3, 150,80);
    n3.cpt = new Float32Table(new Array(n3,n2,n1),
			new Float32Array([0.95, 0.05,    // n1=leicht n2=A
			                  0.90, 0.10,    // n1=schwer
			                  0.75, 0.25,    // n1=leicht n2=B
			                  0.70, 0.30])); // n1=schwer
    
    var net = new BayesNet(netId, "Explaining-Away-Network");
    net.addNode(n1);
    net.addNode(n2);
    net.addNode(n3);
    net.addLink(n1, n2);
    net.addLink(n1, n3);
    net.addLink(n2, n3);
    
    var prop = new FullJoint(net);
    //var prop = new JTree(net, {}, true);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 0,500);
    PN4W.displayPTPopup(net, n1, PN4W.CPT);
    PN4W.displayPTPopup(net, n3, PN4W.CPT);
    PN4W.displayPTPopup(net, n2, PN4W.CPT); // (on top of CPT of n3)
    
  } catch (exception) {
    alert("Simpson Paradox Network: " + exception);
  }
}

function setHospitalA (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.values[1] <  1) { 
    unsetSimpson(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(1, 0);
    net.nodes['n3'].f.values = new Array(1, 1);
    PN4W.propagate(net);
  }
}

function setHospitalB (netId) 
{ 
  var net = PN4W.nets[netId];
  if (net.nodes['n2'].f.values[0] <  1) { 
    setHospitalA(netId); 
  } else {
    net.nodes['n1'].f.values = new Array(1, 1);
    net.nodes['n2'].f.values = new Array(0, 1);
    net.nodes['n3'].f.values = new Array(1, 1);
    PN4W.propagate(net);
  }
}

function unsetSimpson (netId) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['n1'].f.values = new Array(1, 1, 1);
  net.nodes['n2'].f.values = new Array(1, 1, 1);
  net.nodes['n3'].f.values = new Array(1, 1, 1);
  PN4W.propagate(net);
}


// BICYCLE-HELMET (SIMPSON-PAADOX II) ===============================

/**
 * Bicycle-Helmet-Network (Simpson-Paradox II) */
function displayBicycleHelmetNet (netId)
{
  try {
    var sGrp = new Array(new State(0, "A"),
						 new State(1, "B"));
    var nGrp = new Node("group", "Gruppe", sGrp, 0,0); 
    nGrp.cpt = new Float32Table(new Array(nGrp),
								new Float32Array([0.5, 0.5]));
    
    var sHel = new Array(new State(0, "ja"),
						 new State(1, "nein"));
    var nHel = new Node("helmet", "Helmträger", sHel, 0,150);
    nHel.cpt = new Float32Table(new Array(nHel,nGrp),
								new Float32Array([0.9, 0.1,
												  0.1, 0.9]));

    var sInj = new Array(new State(0, "leicht"),
						 new State(1, "schwer"));
    var nInj = new Node("injuries", "Verletzungen", sInj, 300,0);
    nInj.cpt = new Float32Table(new Array(nInj),
								new Float32Array([0.7, 0.3]));
												  
    var sTre = new Array(new State(0, "behandelt"),
					     new State(1, "unbehandelt"));
    var nTre = new Node("treatmnt", "Behandlung", sTre, 150,75);
    nTre.cpt = new Float32Table(new Array(nTre,nGrp,nInj),
								new Float32Array([0.80, 0.20,    // nInj=leicht nGrp=A
												  0.20, 0.80,    // nInj=leicht nGrp=B
												  0.99, 0.01,    // nInj=schwer nGrp=A
												  0.95, 0.05])); // nInj=schwer nGrp=B
    
    var net = new BayesNet(netId, "Bicycle-Helmet-Network");
    net.addNode(nGrp);
    net.addNode(nHel);
    net.addNode(nInj);
	net.addNode(nTre);
    net.addLink(nGrp, nHel);
    net.addLink(nGrp, nTre);
    net.addLink(nInj, nTre);
    
    //var prop = new FullJoint(net);
    var prop = new JTree(net, {}, false);
    net.prop = prop;
    var pe = prop.propagate(true, true);
    
    decorate(net.id, false, false, false, false, true, DECO.BLUEFRAME);
    PN4W.displayNet(net, PN4W.NET);
    PN4W.displayPePopup(net, (net.prop && net.prop.max ? 'P(C|e)' : 'P(e|M)'), pe, PN4W.PE, 300,500);
    PN4W.displayPTPopup(net, nHel, PN4W.CPT);
    PN4W.displayPTPopup(net, nTre, PN4W.CPT);
    //PN4W.displayPTPopup(net, n2, PN4W.CPT); // (on top of CPT of n3)
    
  } catch (exception) {
    alert("Bicylce-Helmet Network: " + exception);
  }
}

function setTreatment (netId) 
{ 
  var net = PN4W.nets[netId];
  var node = net.nodes['treatmnt'];
  if (node.f.values[1] <  1) { 
    node.f.values = new Array(1, 1);
  } else {
    node.f.values = new Array(1, 0);
  }
  PN4W.propagate(net);
}

function unsetTreatment (netId) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['treatmnt'].f.values = new Array(1, 1);
  PN4W.propagate(net);
}

function setInjuries (netId, state) 
{ 
  var net = PN4W.nets[netId];
  var node = net.nodes['injuries'];
  if (node.f.values[(state+1)%2] <  1) { 
    node.f.values = new Array(1, 1);
  } else {
    node.f.values = new Array(state == 0, state == 1);
  }
  PN4W.propagate(net);
}

function setHelmet (netId, state) 
{ 
  var net = PN4W.nets[netId];
  net.nodes['treatmnt'].f.values = new Array(1, 0); // set treatment
  net.nodes['injuries'].f.values = new Array(1, 1); // unset injuries
  var node = net.nodes['helmet'];
  if (node.f.values[(state+1)%2] <  1) { 
    node.f.values = new Array(1, 1);
  } else {
    node.f.values = new Array(state == 0, state == 1);
  }
  PN4W.propagate(net);
}

function setGroup (netId, state) 
{ 
  var net = PN4W.nets[netId];
  var node = net.nodes['group'];
  if (node.f.values[(state+1)%2] <  1) { 
    node.f.values = new Array(1, 1);
  } else {
    node.f.values = new Array(state == 0, state == 1);
  }
  PN4W.propagate(net);
}


