/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplaySamples.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Helper to display sampled data.
 */


// DISPLAY SAMPLED DATA =============================================

/**
 * Display sampled data
 * @param samples     'samples.dims':           array of dimensions (nodes)<br>
 *                    'samples.data[m].weight': weight of the m-th sample<br>
 *                    'samples.data[m][i]':     state-index of the i-th
 *                                              node in the m-th sample
 * @param id          id for the table
 * @param parentElem  HTML parent element to add a new table
 * @param type        probability table type (e.g. this.SAMPLES)
 */
PN4Web.prototype.displaySamples = function (samples, id, parentElem, type) 
{
  // cannot display anything if there is no such element
  if (!parentElem) return (null);

  // create table
  var tabElem  = appendNewElement(parentElem, 'table', id, type.CLAZZ);
  tabElem.cellSpacing = 0;     // (IE ignores CSS border-spacing)
  var bodyElem = appendNewElement(tabElem, 'tbody');
  var rowElem, cellElem;
  
  // very first row: dummies to fix column widths
  rowElem = appendNewElement(bodyElem, 'tr');
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_dummy');
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_vsep');
  for (var d = 0; d < samples.dims.length; d++) {         // for all dimensions (nodes)
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_dummy');
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_vsep');
  }
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_dummy');

  // first (visible) row: node/dimension names
  rowElem = appendNewElement(bodyElem, 'tr');
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_header');
  cellElem.innerHTML = "N";
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_vsep');
  for (var d = 0; d < samples.dims.length; d++) {         // for all dimensions (nodes)
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_header');
    cellElem.innerHTML = samples.dims[d].name.toHTML();
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_vsep');
  }
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_header');
  cellElem.innerHTML = "Weight";
  
  // third row: horizontal line
  rowElem = appendNewElement(bodyElem, 'tr');
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_hsep'); 
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_sep');
  for (var d = 0; d < samples.dims.length; d++) {        // for all dimensions (nodes)
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_hsep'); 
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_sep');
  }
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_hsep');
  
  // normal rows: states and weight for each sampled configuration
  for (var m = 0; m < samples.data.length; m++) {
    rowElem = appendNewElement(bodyElem, 'tr');
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_value');
    cellElem.innerHTML = "[" + m + "]";
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_vsep');
    for (var d = 0; d < samples.dims.length; d++) {      // for all dimensions (nodes)
      cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_value');
      var s = samples.data[m][d];
      if (samples.dims[d].states) {
        cellElem.innerHTML = (s >= 0 ? samples.dims[d].states[s].name.toHTML() : "---".toHTML());
      } else {
        cellElem.innerHTML = s.toFixed(4);
      }
      cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_vsep');
    }
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_value');
    cellElem.innerHTML = samples.data[m].weight.toFixed(type.PRECISION);
  }

  // last row: horizontal line
  rowElem = appendNewElement(bodyElem, 'tr');
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_hsep'); 
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_sep');
  for (var d = 0; d < samples.dims.length; d++) {        // for all dimensions (nodes)
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_hsep'); 
    cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_sep');
  }
  cellElem = appendNewElement(rowElem, 'td', undefined, type.CLAZZ + '_hsep');

  return (tabElem);
};
