/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayPePopup.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Displays a popup-window to show the probability of evidence, given the
 * model (P(e|M), where e is the current evidence and the model M is the 
 * bayesian network)
 */


// DISPLAY PROBABILITY TABLE (POPUP) ================================

/**
 * Display a popup window showing one value, e.g. the probability of 
 * evidence given the model (P(e|M)). There could be only one popup
 * for each type (for each 'type.CLAZZ').
 * @param net   bayesian network / junction tree
 * @param pe    P(e|M)
 * @param type  popup type (e.g. this.PE)
 * @param x     x-coordinate
 * @param y     y-coordinate
 */
PN4Web.prototype.displayPePopup = function (net, title, value, type, x,y)
{
  // id of html element (popup window)
  var id = net.id + '.' + type.CLAZZ; 
  var netElem   = document.getElementById(net.id);
  var popupElem = document.getElementById(id);

  // cannot display anything if there is no such element
  if (!netElem) return;

  var w = toInt(type.MAX_PBAR_WIDTH * Math.max(0, Math.min(1, value))); // width of probability bar (middle tile)
  if (!popupElem) {

    // create popup window
    popupElem     = this.displayPopup1(id, title, netElem, type.POPUP);
    var areaElem  = document.getElementById(id + '.area');
    var valueElem = appendNewElement(areaElem, 'div', id + '.content', type.CLAZZ);

    // probability bar
    if (type.PBAR) {
      var pbarElem  = appendNewElement(valueElem, 'div', id + '.content.pbar',  type.PBAR.CLAZZ);
      setBorderImage(pbarElem, this.BASE_PATH + type.PBAR.BG, 
                     type.PBAR.SPLIT.N,  type.PBAR.SPLIT.E,  type.PBAR.SPLIT.S,  type.PBAR.SPLIT.W, 
                     type.PBAR.BORDER.N, type.PBAR.BORDER.E, type.PBAR.BORDER.S, type.PBAR.BORDER.W, 
                     type.PBAR.STRETCH);
    }
    
    // value
    var valElem = appendNewElement(valueElem, 'div', id + '.content.value', 'container');
    valElem.innerHTML = value.toFixed(type.PRECISION);

    // set size/position and display popup window
    this.displayPopup2(id, valueElem, x,y, type.POPUP);

  } else {

    // update value
    var pbarElem  = document.getElementById(id + '.content.pbar');
    var valueElem = document.getElementById(id + '.content.value');
    if (!isNaN(w) && pbarElem) pbarElem.style.width = w;
    valueElem.innerHTML = value.toFixed(type.PRECISION);

  }
};

/**
 * Undisplay the given popup
 * @param net   bayesian network / junction tree
 * @param node  node/clique/separator
 */
PN4Web.prototype.undisplayPePopup = function (net, node)
{
  removeElement(net.id + '.' + node.id + '.pt'); 
};

