/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayPTPopup.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Displays a popup-window to show a probability table of a node 
 * (conditional probability table - CPT), a clique (joint probability 
 * table - JPT) or a separator (JPT).
 */


// DISPLAY PROBABILITY TABLE (POPUP) ================================

/**
 * Get the popup window showing the conditional or joint
 * probability table for one node/clique/separator.
 * @param net   bayesian network / junction tree
 * @param node  node/clique/separator in that net
 * @return      html element of undefined if popup is not open
 */
PN4Web.prototype.getPTPopup = function (net, node)
{
  var id = net.id + '.' + node.id + '.pt';
  var ptElem = document.getElementById(id);
  return (ptElem);
};

/**
 * Display a popup window showing the conditional or joint
 * probability table for one node/clique/separator. Updates
 * the popup window if it already exists.
 * @param net   bayesian network / junction tree
 * @param node  node/clique/separator in that net
 * @param type  e.g. this.CPT or this.JPT
 * @param x     x-coordinate                         [optional]
 * @param y     y-coordinate (default is below node) [optional]
 */
PN4Web.prototype.displayPTPopup = function (net, node, type, x,y)
{
  // id of html cpt element (popup window)
  var id = net.id + '.' + node.id + '.pt'; 
  var pt         = node[type.PT_ATTR]; 
  var context    = {}; context.net = net; context.node = node;
  var netElem    = document.getElementById(net.id);
  var nodeElem   = document.getElementById(net.id + '.' + node.id);
  var nodeBgElem = document.getElementById(net.id + '.' + node.id + '.bg');
  var ptElem     = document.getElementById(id);

  // cannot display anything if there is no such element
  if (!netElem) return (null);

  if (!ptElem) {

    // create popup window
    ptElem = this.displayPopup1(id, node.name, netElem, type.POPUP);

    // display probability table in a HTML table
    var tabElem, areaElem = document.getElementById(id + '.area');
    if (pt instanceof Array) {
      var contElem = appendNewElement(areaElem, 'div', id + '.tables', type.CLAZZ + '_tables');
      tabElem  = new Array();
      for (var i = 0; i < pt.length; i++) {
        tabElem.push(this.displayPTable(pt[i], id + '.table_' + i, contElem, type.PTABLE, context, type.CALLBACKS, net.nodes));
      }
    } else {
      tabElem = this.displayPTable(pt, id + '.table', areaElem, type.PTABLE, context, type.CALLBACKS, net.nodes);
    }

    // set size/position and display popup window
    if (x === undefined) x = nodeElem.offsetLeft;
    if (y === undefined) y = nodeElem.offsetTop + nodeBgElem.offsetHeight;
    this.displayPopup2(id, tabElem, x,y, type.POPUP);

  } else {

    // set title (might have changed)
    var titleElem = document.getElementById(id + '.title');
    titleElem.innerHTML = node.name.toHTML();

    // update (remove old table and create a new one)
    removeElement(id + '.table');
    removeElement(id + '.tables');
    var tabElem, areaElem = document.getElementById(id + '.area');
    if (pt instanceof Array) {
      var contElem = appendNewElement(areaElem, 'div', id + '.tables', type.CLAZZ + '_tables');
      tabElem  = new Array();
      for (var i = 0; i < pt.length; i++) {
        tabElem.push(this.displayPTable(pt[i], id + '.table_' + i, contElem, type.PTABLE, context, type.CALLBACKS, net.nodes));
      }
    } else {
      tabElem = this.displayPTable(pt, id + '.table', areaElem, type.PTABLE, context, type.CALLBACKS, net.nodes); 
    }

    // resize popup window
    if (x === undefined) x = ptElem.offsetLeft;
    if (y === undefined) y = ptElem.offsetTop;
    this.displayPopup2(id, tabElem, x,y, type.POPUP);
  }
};

/**
 * Undisplay the given probability table popup.
 * @param net   bayesian network / junction tree
 * @param node  node/clique/separator
 */
PN4Web.prototype.undisplayPTPopup = function (net, node)
{
  removeElement(net.id + '.' + node.id + '.pt'); 
};
