/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayFrame.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Displays a "frame" to show a bayesian network inside. There has to be 
 * an html element in the document by the name of "netId.frame", where netId
 * is the id of the bayesian network to be shown. Inside this frame-element
 * there is a html-element created with the name of the network-id. If you
 * don't want a frame displayed, then you have to create this element 
 * directly.
 */


// DISPLAY NETWORK FRAME (BACKGROUND) ===============================

/**
 * Display frame for bayesian networks (to be shown by 
 * calling 'displayNet()'). There has to be an element 
 * with id "[net.id].frame", which is filled by this
 * method.
 * @param id    id of the newly created content element; div element with 
 *              id=id.frame must exist
 * @param keep  keep content
 * @param type  e.g. this.FRAME
 */
PN4Web.prototype.displayFrame = function (id, type, keep)
{
  // get frame html element and its content
  var frameElem = document.getElementById(id + '.frame'); 
  var content   = (keep ? frameElem.innerHTML : '');
  var frameW    = Math.max(frameElem.offsetWidth, frameElem.scrollWidth);    // safe current width and...
  var frameH    = Math.max(frameElem.offsetHeight, frameElem.scrollHeight);  // ...height (before changing)

  // create inner HTML for the frame div
  frameElem.innerHTML  
  
    // shadow
    = '<div class="' + type.CLAZZ + '_shadow" id="' + id + '.shadow" ' 
    +       (type.SHOW_SHADOW ? '' : 'style="visibility:hidden;"') + '>'
    +   '<div class="' + type.CLAZZ + '_shadow_nw" id="' + id + '.shadow.nw">'
    +     '<img id="' + id + '.shadow.nw.img" src="' + this.BASE_PATH + type.SHADOW_NW + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_n" id="' + id + '.shadow.n">'
    +     '<img id="' + id + '.shadow.n.img" src="' + this.BASE_PATH + type.SHADOW_N + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_ne" id="' + id + '.shadow.ne">'
    +     '<img id="' + id + '.shadow.ne.img" src="' + this.BASE_PATH + type.SHADOW_NE + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_w" id="' + id + '.shadow.w">'
    +     '<img id="' + id + '.shadow.w.img" src="' + this.BASE_PATH + type.SHADOW_W + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_m" id="' + id + '.shadow.m" '
    +        'style="background-image:url(' + this.BASE_PATH + type.SHADOW_M + ');">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_e" id="' + id + '.shadow.e">'
    +     '<img id="' + id + '.shadow.e.img" src="' + this.BASE_PATH + type.SHADOW_E + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_sw" id="' + id + '.shadow.sw">'
    +     '<img id="' + id + '.shadow.sw.img" src="' + this.BASE_PATH + type.SHADOW_SW + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_s" id="' + id + '.shadow.s">'
    +     '<img id="' + id + '.shadow.s.img" src="' + this.BASE_PATH + type.SHADOW_S + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_shadow_se" id="' + id + '.shadow.se">'
    +     '<img id="' + id + '.shadow.se.img" src="' + this.BASE_PATH + type.SHADOW_SE + '">'
    +   '</div>'
    + '</div>'

    // background
    + '<div class="' + type.CLAZZ + '_bg" id="' + id + '.bg">'
    +   '<div class="' + type.CLAZZ + '_bg_nw" id="' + id + '.bg.nw">'
    +     '<img id="' + id + '.bg.nw.img" src="' + this.BASE_PATH + type.BG_NW + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_n" id="' + id + '.bg.n">'
    +     '<img id="' + id + '.bg.n.img" src="' + this.BASE_PATH + type.BG_N + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_ne" id="' + id + '.bg.ne">'
    +     '<img id="' + id + '.bg.ne.img" src="' + this.BASE_PATH + type.BG_NE + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_w" id="' + id + '.bg.w">'
    +     '<img id="' + id + '.bg.w.img" src="' + this.BASE_PATH + type.BG_W + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_m" id="' + id + '.bg.m" '
    +        'style="overflow:' + (!keep ? 'auto' : 'hidden') + '; ' 
    +               'background-image:url(' + this.BASE_PATH + type.BG_M + ');">' 
    +     '<div class="' + type.CLAZZ + '_content" id="' + id + '">'
    +        content // put content in here
    +     '</div>' 
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_e" id="' + id + '.bg.e">'
    +     '<img id="' + id + '.bg.e.img" src="' + this.BASE_PATH + type.BG_E + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_sw" id="' + id + '.bg.sw">'
    +     '<img id="' + id + '.bg.se.img" src="' + this.BASE_PATH + type.BG_SW + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_s" id="' + id + '.bg.s">'
    +     '<img id="' + id + '.bg.s.img" src="' + this.BASE_PATH + type.BG_S + '">'
    +   '</div>'
    +   '<div class="' + type.CLAZZ + '_bg_se" id="' + id + '.bg.se">'
    +     '<img id="' + id + '.bg.se.img" src="' + this.BASE_PATH + type.BG_SE + '">'
    +   '</div>'
    + '</div>';

  // relevant elements
  /*var contElem=*/document.getElementById(id);
  var bgElem     = document.getElementById(id + '.bg');
  var bgNElem    = document.getElementById(id + '.bg.n');
  var bgWElem    = document.getElementById(id + '.bg.w');
  var bgMElem    = document.getElementById(id + '.bg.m');
  var bgEElem    = document.getElementById(id + '.bg.e');
  var bgSElem    = document.getElementById(id + '.bg.s');
  var bgNImgElem = document.getElementById(id + '.bg.n.img');
  var bgWImgElem = document.getElementById(id + '.bg.w.img');
  var bgEImgElem = document.getElementById(id + '.bg.e.img');
  var bgSImgElem = document.getElementById(id + '.bg.s.img');
  var shElem     = document.getElementById(id + '.shadow');
  var shNElem    = document.getElementById(id + '.shadow.n');
  var shWElem    = document.getElementById(id + '.shadow.w');
  var shMElem    = document.getElementById(id + '.shadow.m');
  var shEElem    = document.getElementById(id + '.shadow.e');
  var shSElem    = document.getElementById(id + '.shadow.s');
  var shNImgElem = document.getElementById(id + '.shadow.n.img');
  var shWImgElem = document.getElementById(id + '.shadow.w.img');
  var shEImgElem = document.getElementById(id + '.shadow.e.img');
  var shSImgElem = document.getElementById(id + '.shadow.s.img');

  // frame border widths
  var w = bgWElem.offsetWidth;
  var e = bgEElem.offsetWidth;
  var n = bgNElem.offsetHeight;
  var s = bgSElem.offsetHeight;

  // new frame and content witdh/heights
  if (keep) {
    frameW += w + e;  // adapt frame width and height...
    frameH += n + s;  // ...the content should be kept
  }
  var contW = Math.max(1, frameW - w - e);
  var contH = Math.max(1, frameH - n - s);
  if (keep) {
    frameElem.style.width  = frameW;
    frameElem.style.height = frameH;
  }
  bgElem.style.width  = shElem.style.width  = frameW;
  bgElem.style.height = shElem.style.height = frameH;
  bgNElem.style.width  = bgMElem.style.width  = bgSElem.style.width  = contW;
  shNElem.style.width  = shMElem.style.width  = shSElem.style.width  = contW;
  bgWElem.style.height = bgMElem.style.height = bgEElem.style.height = contH;
  shWElem.style.height = shMElem.style.height = shEElem.style.height = contH;
  bgNImgElem.style.width  = bgSImgElem.style.width  = contW;
  shNImgElem.style.width  = shSImgElem.style.width  = contW;
  bgWImgElem.style.height = bgEImgElem.style.height = contH;
  shWImgElem.style.height = shEImgElem.style.height = contH;

  // remove background color
  frameElem.style.backgroundColor = '';
};

