/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayCtrl.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Displaying controls for dynamic bayesian networks (like "play", 
 * "step", "pause", "stop", ...)
 */


// DISPLAY CONTROLS FOR DYNAMIC BAYESIAN NETWORKS ===================

/**
 * Display controls
 * @param net   bayesian network
 * @param type  e.g. this.CTRL
 */
PN4Web.prototype.displayCtrl = function (net, type)
{
  var ctrlElem = document.getElementById(net.id + '.ctrl');
  ctrlElem.innerHTML 
  = '<div class="ctrl" id="' + net.id + '.ctrl">'
  + '<div class="ctrl_button" id="' + net.id + '.ctrl.playback">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.PLAYBACK + '" alt="Reverse" title="Reverse"></a>'
  + '</div>'
  + '<div class="ctrl_button" id="' + net.id + '.ctrl.prev">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.PREV     + '" alt="Step back" title="Step back"></a>'
  + '</div>'
  + '<div class="ctrl_button" id="' + net.id + '.ctrl.pause">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.PAUSE    + '" alt="Pause" title="Pause"></a>'
  + '</div>'
  + '<div class="ctrl_button" id="' + net.id + '.ctrl.next">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.NEXT     + '" alt="Step" title="Step"></a>'
  + '</div>'
  + '<div class="ctrl_button" id="' + net.id + '.ctrl.play">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.PLAY     + '" alt="Play" title="Play"></a>'
  + '</div>'
  + '<div class="ctrl_button" id="' + net.id + '.ctrl.stop">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.STOP     + '" alt="Stop" title="Stop/Reinit"></a>'
  + '</div>'
  + '<div class="ctrl_smallbutton" id="' + net.id + '.ctrl.slower">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.SLOWER   + '" alt="Slower" title="Slower"></a>'
  + '</div>'
  + '<div class="ctrl_smallbutton" id="' + net.id + '.ctrl.faster">'
  +   '<a href="javascript:dummy();"><img src="' + this.BASE_PATH + type.FASTER   + '" alt="Faster" title="Faster"></a>'
  + '</div>'
  + '<div style="clear:both; visibility:hidden;">.</div>'
  + '</div>';

  // make all buttons sensitive
  var playbackElem = document.getElementById(net.id + '.ctrl.playback');
  var prevElem     = document.getElementById(net.id + '.ctrl.prev');
  var pauseElem    = document.getElementById(net.id + '.ctrl.pause');
  var nextElem     = document.getElementById(net.id + '.ctrl.next');
  var playElem     = document.getElementById(net.id + '.ctrl.play');
  var stopElem     = document.getElementById(net.id + '.ctrl.stop');
  var slowerElem   = document.getElementById(net.id + '.ctrl.slower');
  var fasterElem   = document.getElementById(net.id + '.ctrl.faster');
  var me = this;
  var playback = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.playback(net);
  };
  var prev = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.prev(net);
  };
  var pause = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.pause(net);
  };
  var next = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.next(net);
  };
  var play = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.play(net);
  };
  var stop = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.stop(net);
  };
  var slower = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.slower(net);
  };
  var faster = function(evnt) { 
    if (!evnt) evnt = window.event;
    preventDefault(evnt);
    me.faster(net);
  };
  addEventListener(playbackElem, 'mousedown', playback);
  addEventListener(prevElem,     'mousedown', prev);
  addEventListener(pauseElem,    'mousedown', pause);
  addEventListener(nextElem,     'mousedown', next);
  addEventListener(playElem,     'mousedown', play);
  addEventListener(stopElem,     'mousedown', stop);
  addEventListener(slowerElem,   'mousedown', slower);
  addEventListener(fasterElem,   'mousedown', faster);
};



