/*
 * -------------------------------------------------------------------------
 *
 *  pn4webDisplayContent.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Displays names of nodes contained in a clique of a junction-tree.
 * (like pn4webDisplayState.js displays states of nodes of a bayesian 
 * network)
 */


// DISPLAY CONTAINED NODES OF A CLIQUE ==============================

/**
 * Display or redisplay the content of the given node
 * @param net     junction tree
 * @param clique  clique in that junction tree ('net')
 * @param type    e.g. this.CONTENT
 */
PN4Web.prototype.displayContent = function (net, clique, type)
{
  // id for the node html element
  var id = net.id + '.' + clique.id;

  // container elements
  var contentsElem  = document.getElementById(id + '.contents');

  var i = 0;
  for (var nId in clique.nodes) {
    var node = clique.nodes[nId];
    var home = net.home && net.home[node.id] == clique; // clique is home of node
    var add  = clique.addins && clique.addins[nId];
    var elim = clique.id == node.id;                    // node is elimination node of clique

    // get / create contained node name
    var contentId = id + '.content_' + i;
    var contentElem = document.getElementById(contentId);
    if (!contentElem) {
      contentElem = appendNewElement(contentsElem, 'div', contentId, type.CLAZZ + '_' + i); 
    }
    contentElem.innerHTML 
      = node.name.toHTML()
      + '<div class="' + type.CLAZZ + '_marker">'
      +   (home ? '&loz;'   : (add ? '+' : '&nbsp;')) 
      + '</div>'
      + '<div class="' + type.CLAZZ + '_marker">'
      +   (elim ? '&times;' : '&nbsp;')
      + '</div>';

    i++;
  }

  // remove additional contents not included anymore
  for ( ; ; i++) {
    var contentElem = document.getElementById(id + '.content_' + i);
    if (contentElem) {
      contentElem.parentNode.removeChild(contentElem);
    } else {
      break;
    }
  }
};
