/*
 * -------------------------------------------------------------------------
 *
 *  navbar.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * Shows a "navigation slider" on the left side of the window, 
 * which is expanded to a "navigation area" if the mouse is 
 * located on that slider (on the left side of the window).
 * The navigation area shows several folders and sub-folders 
 * of available sites.
 *
 * To make this work a site has to start like this:
 * <html>
 * <head>
 *   [...meta tags, etc...]
 *   <script type="text/javascript" src="../js/dhtml.js"></script>
 *   <script type="text/javascript" src="../js/navbar.js"></script>
 *   <style type="text/css">
 *     @import url("../js/navbar.css");
 *   </style>
 * </head>
 * <body onload="initNavBar('subdir/index.html', 1)" vlink="#003300" alink="#ff0000" link="#003300">
 * <div id="NavButton">Notice: Enable JavaScript to use the Navigation-Bar.</div>
 * <div id="Nav">Notice: Enable JavaScript to use the Navigation-Bar.</div>
 * [...]
 *
 * where at least the call to initNavBar(site, subLevls) has to be adapted
 * for each site (subLevels is the number of directories you have to go 
 * down from this site to get to the base directory).
 * Also adapt the following constants (capital letters) and function 
 * 'getNavBarEntries()' to your sites.
 */


/* Dimensions */
var NAV_HEIGHT       = 600; // navigation area/slider height
var NAV_AREA_WIDTH   = 250; // navigation area width
var NAV_SLIDER_WIDTH = 10;  // navigation slider width

/* IDs */
var NAV_AREA_ID   = "Nav";       // ID of the div element for the navigation bar area
var NAV_LINKS_ID  = "NavLinks";  // ID of the div element for the navigation bar link area (sub-area)
var NAV_SLIDER_ID = "NavButton"; // ID of the div element for the navigation bar slider (hidden area)

/* Images (relative to the root directory) */
var NAV_AREA_IMG   = "js/navbarbg.png";  // background image for the navigation area
var NAV_SLIDER_IMG = "js/navbarbut.png"; // image for the navigation slider

var NAV_OPENED_IMG = "js/opened.gif"; // marks an expanded folder
var NAV_CLOSED_IMG = "js/closed.gif"; // marks an collapsed folder
var NAV_LEAF_IMG   = "js/leaf.gif";   // marks an item without sub-items

var NAV_EXTERNAL_IMG = "js/external.gif", NAV_EXTERNAL_TOOLTIP = "(Externe Seite)";                     // marks an external link
var NAV_LINK_IMG     = "js/link.gif",     NAV_LINK_TOOLTIP     = "(Eigene Seite)";                      // marks an internal link
var NAV_ANCHOR_IMG   = "js/anchor.gif",   NAV_ANCHOR_TOOLTIP   = "(Unterkapitel auf aktueller Seite)";  // marks an link to an anchor on the same site
var NAV_CURRENT_IMG  = "js/here.gif",     NAV_CURRENT_TOOLTIP  = "(Standort - Aktuelle Seite)";         // marks the currently opened site

/* Indentation */
var NAV_INDENT = "&nbsp;&nbsp&nbsp;&nbsp"; // standard indentation (one level)

/* URL pattern */
var NAV_ABSOLUTE_URLS = new Array("http://", 
				  "https://");                     // absolute (non-relative) URLs starting with one of these patterns
var NAV_INTERNAL_URLS = new Array("http://patricks-seite.de", 
				  "http://www.patricks-seite.de"); // internal URLs starting with one of these patterns


/* 
 * Upper coordinate of the navigation area/slider 
 * (Really, you don't want to get that from HTML-elements!) 
 */
var upper = 0; 


/* 
 * Create navigation content 
 * Return: a list of entries, where each entry 
 *         is itself a list of 4 elements:
 *         1. site (either an URL which is relative to the base-path 
 *            or an absolute URL which usally starts with "http://")
 *         2. name (to be shown)
 *         3. sub-entries (another list of entries)
 *         4. always expanded? (should be true for all anchor-links
 *            because otherwise sub-entries will be never shown)
 */
function getNavBarEntries ()
{
  // ---------------------------------------------------------------------------------
  // PROBNET
  
  var probNetLearnSub = new Array(new Array("probnet/DiplomArbeit.ps.gz",  "Diplom-Arbeit (PS)",  null, false),
				  new Array("probnet/DiplomArbeit.pdf.gz", "Diplom-Arbeit (PDF)", null, false));
  
  var probNetDecompSub = new Array(new Array("probnet/bn_decomposition.html#ACO", "Ant-Colony-Optimization",  null, true),
				   new Array("probnet/bn_decomposition.html#EA",  "Evolutionre Algorithmen", null, true),
				   new Array("probnet/bn_plugin.html",            "Triangulierungs-Plug-In",  null, false));

  var probNetHybridSub = new Array(new Array("probnet/bn_hybrid.html#Diskretisierung",   "Diskretisierung",         null, true),
				   new Array("probnet/bn_hybrid.html#CG",                "Conditional Gaussians",   null, true),
				   new Array("probnet/bn_hybrid.html#HybridSampling",    "Sampling (hybrid)",       null, true),
				   new Array("probnet/bn_hybrid.html#ElimTree4Hybrid",   "Strong-Elimination-Tree", null, true),
				   new Array("probnet/bn_hybrid.html#HybridBsp",         "Beispiel",                null, true));

  var probNetBspSub = new Array(new Array("probnet/bn_bsp.html#BayesRule",      "Bayes'sche Regel",        null, false),
				new Array("probnet/bn_bsp.html#ExplainingAway", "Explaining Away",         null, false),
				new Array("probnet/bn_bsp.html#UndirLink",      "Ungerichtete Verbindung", null, false),
				new Array("probnet/bn_bsp.html#SoftEvid",       "Soft-Evidence",           null, false),
				new Array("probnet/bn_bsp.html#Zonk",           "Zonk",                    null, false),
				new Array("probnet/bn_bsp.html#Simpson",        "Simpson-Paradox",         null, false));

  var probNetPN4WebExamples1Sub = new Array(new Array("probnet/bn_pn4webExamples.html#BayesRule",      "Bayes'sche Regel",        null, false),
					    new Array("probnet/bn_pn4webExamples.html#ExplainingAway", "Explaining Away",         null, false),
					    new Array("probnet/bn_pn4webExamples.html#UndirLink",      "Ungerichtete Verbindung", null, false),
					    new Array("probnet/bn_pn4webExamples.html#SoftEvid",       "Soft-Evidence",           null, false),
					    new Array("probnet/bn_pn4webExamples.html#Zonk",           "Zonk",                    null, false),
					    new Array("probnet/bn_pn4webExamples.html#Simpson",        "Simpson-Paradox",         null, false));

  var probNetPN4WebExamples2Sub = new Array(new Array("probnet/bn_pn4webExamples2.html#FullJoint",   "Naiver Ansatz", null, false),
					    new Array("probnet/bn_pn4webExamples2.html#JTree",       "Junction-Tree", null, false),
					    new Array("probnet/bn_pn4webExamples2.html#LoopyBelief", "Loopy Belief",  null, false),
					    new Array("probnet/bn_pn4webExamples2.html#SWSampler",   "LW-Sampling",   null, false));

  var probNetPN4WebExamples3Sub = new Array(new Array("probnet/bn_pn4webExamples3.html#HMM",   "Hidden-Markov-Model", null, false));

  var probNetPN4WebSub = new Array(new Array("probnet/bn_pn4webExamples.html",  "Anwendungs-Beispiele", probNetPN4WebExamples1Sub, false),
				   new Array("probnet/bn_pn4webExamples2.html", "Inferenz-Algorithmen", probNetPN4WebExamples2Sub, false),
				   new Array("probnet/bn_pn4webExamples3.html", "Dynamische Netze",     probNetPN4WebExamples3Sub, false));

  var probNetSub = new Array(new Array("probnet/index.html#Einfuehrung", "Einfhrung",            null,             true),
			     new Array("probnet/index.html#dseparation", "D-Separation",          null,             true),
			     new Array("probnet/index.html#inferenz",    "Inferenz",              null,             true),
			     new Array("probnet/index.html#Rules",       "Rechenregeln",          null,             true),
			     new Array("probnet/index.html#Bsp",         "Beispiel",              null,             true),
			     new Array("probnet/bn_bsp.html",            "Anwendungs-Beispiele",  probNetBspSub,    false),
			     new Array(null,                             "Interaktive Beispiele (Beta)", probNetPN4WebSub, true),
			     new Array("probnet/bn_dyn.html",            "Dynamische Netze",      null,             false),
			     new Array("probnet/bn_learn.html",          "Daten (lernen)",        probNetLearnSub,  false),
			     new Array("probnet/bn_modular.html",        "Modulare Netze",        null,             false),
			     new Array("probnet/bn_decomposition.html",  "Tree-Decomposition",    probNetDecompSub, false),
			     new Array("probnet/bn_hybrid.html",         "Hybride Netze",         probNetHybridSub, false),
			     new Array("probnet/index.html#Frosch",      "Der Frosch",            null,             true),
			     new Array("probnet/index.html#Glossar",     "Glossar",               null,             true));
  
  // ---------------------------------------------------------------------------------
  // FRAKTAL

  //var fractalCodeSub1 = new Array(new Array("fractal/fract3dcode.html#Komplex_Quaternion", "Complex / Quaternions",        null, true),
  //		                new Array("fractal/fract3dcode.html#Julia_Mandelbrot",   "Mandelbrot- / Julia-Fraktale", null, true));

  //var fractalCodeSub2 = new Array(new Array("fractal/fract3dcode2.html#Object",   "Basis-Klasse", null, true),
  //	   	                new Array("fractal/fract3dcode2.html#Vector",   "3D-Vector",    null, true),
  //		                new Array("fractal/fract3dcode2.html#Line",     "3D-Geraden",   null, true),
  //		                new Array("fractal/fract3dcode2.html#Plane",    "3D-Ebenen",    null, true),
  //		                new Array("fractal/fract3dcode2.html#Rotation", "Rotation",     null, true));

  var fractalCreatorSub = new Array(new Array("http://user.cs.tu-berlin.de/~rammelt/cgi-bin/julia3dcreate.html", "Online-Creator (Direktlink)", null, false));

  var fractalSub = new Array(//new Array("fractal/fract3dcode2.html",  "Code: Geometrie",   fractalCodeSub2, false),
			     //new Array("fractal/fract3dcode.html",   "Code: Fraktale",    fractalCodeSub1, false),
			     new Array("fractal/index.html#Intro",              "Was sind Fraktale?", null, true),
			     new Array("fractal/index.html#MandelbrotAndJulia", "Mandelbrot und Julia", null, true),
			     new Array("fractal/specialFractals.html",          "Spezielle Fraktale", null, false),
			     new Array("fractal/index.html#Mandelbulb",         "Mandelbulb und Mandelbox", null, false),
			     new Array("fractal/index.html#Visualization",      "Darstellung 2D/3D",  null, true),
			     new Array("fractal/index.html#Colorization",       "Farbgebung",         null, true),
			     new Array("fractal/index.html#FractalMovies",      "Fraktale im Film",   null, true),
			     new Array("fractal/index.html#FractalDimension",   "Fraktale Dimension", null, true),
			     new Array("fractal/index.html#Code",               "Code (Mini-Beispiel)", null, true),
			     new Array("fractal/index.html#Online3DCreator",    "Online-Creator (Anleitung)", fractalCreatorSub, true),
			     new Array("fractal/index.html#galerie",            "Galerie (Neue Bilder)", null, true),
			     new Array("fractal/index.html#old_galerie",        "Galerie (Alte Bilder)", null, true),
			     new Array("fractal/index.html#FraktalFilme",       "Fraktal-Filme",         null, true));
  
  // ---------------------------------------------------------------------------------
  // BEZIER

  var bezierSubSub1 = new Array(new Array("bezier/index.html#Basics",                           "Basics",               null, true),
				new Array("bezier/index.html#Forward_Differencing",             "Forward-Differencing", null, true),
				new Array("bezier/index.html#Zusammenfuegen_von_Bezier_Kurven", "Zusammenfgen",        null, true));

  var bezierSubSub2 = new Array(new Array("bezier/index.html#Basics",                           "Basics2",            null, true),
				new Array("bezier/index.html#Zusammenfuegbare_Bezier_Flaechen", "Zusammenfgen",      null, true),
				new Array("bezier/index.html#Gesichtsmodell",                   "Gesichtsmodell",     null, true),
				new Array("bezier/index.html#Greatest_Misses",                  "Greatest Misses",    null, true),
				new Array("bezier/index.html#Ergebnis",                         "Ergebnis",           null, true));

  var bezierSubSub3 = new Array(new Array("bezier/bezier3dcode.html#Forward_Diff_Curve",        "Forward-Diff (Curve)",    null, true),
				new Array("bezier/bezier3dcode.html#Curve_Intermediates",       "Intermediates (Curve)",   null, true),
				new Array("bezier/bezier3dcode.html#Forward_Diff_Surface",      "Forward-Diff (Surface)",  null, true),
				new Array("bezier/bezier3dcode.html#Surface_Intermediates",     "Intermediates (Surface)", null, true));

  var bezierSub = new Array(new Array("bezier/index.html#Bezier_Kurven",       "Bezier-Kurven",      bezierSubSub1, true),
			    new Array("bezier/index.html#Bezier_Oberflaechen", "Bezier-Oberflchen", bezierSubSub2, true),
			    new Array("bezier/bezier3dcode.html",              "Code",               bezierSubSub3, false));
  
  // ---------------------------------------------------------------------------------
  // RADWEG

  var oldRenderingSub = new Array(new Array("rendering/zBufferRendering.html#Intro",            "Einleitung",                   null, true),
				  new Array("rendering/zBufferRendering.html#Features",         "Generelle Merkmale",           null, true),
				  new Array("rendering/zBufferRendering.html#SceneDescription", "Szenen- / Objektbeschreibung", null, true),
				  new Array("rendering/zBufferRendering.html#Parameters",       "Globale Parameter",            null, true),
				  new Array("rendering/zBufferRendering.html#Pre",              "Vorverarbeitung",              null, true),
				  new Array("rendering/zBufferRendering.html#Algorithm",        "Der Algorithmus im Detail",    null, true));

  var renderingSub = new Array(new Array("rendering/index.html#Intro",            "Einleitung",                   null, true),
			       new Array("rendering/index.html#Features",         "Generelle Merkmale",           null, true),
			       new Array("rendering/index.html#SceneDescription", "Szenen- / Objektbeschreibung", null, true),
			       new Array("rendering/index.html#Parameters",       "Globale Parameter",            null, true),
			       new Array("rendering/index.html#Algorithm",        "Der Algorithmus im Detail",    null, true),
                               new Array("rendering/zBufferRendering.html",       "Der Vorgnger-Algorithmus", oldRenderingSub, false));
  
  // ---------------------------------------------------------------------------------
  // OPTICAL

  var optSubSubSub1 = new Array(new Array("optical/optF2.html", "Lsung 2", null, false));

  var optSubSub1 = new Array(new Array("optical/optF.html", "Lsung", optSubSubSub1, false));

  var optSubSub3 = new Array(new Array("optical/optface.html", "Lsung", null, false));

  var optSub = new Array(new Array("optical/index.html#countf",     "F\'s zhlen",      optSubSub1, true),
			 new Array("optical/index.html#mixed",      "Buchstabensalat",  null,       true),
			 new Array("optical/index.html#colors",     "Farben",           null,       true),
			 new Array("optical/index.html#upsidedown", "Kopfber",         optSubSub3, true));
  
  // ---------------------------------------------------------------------------------
  // WAVELETS

  var dwtSub = new Array(new Array("wavelets/index.html#1D",        "1D-DWT",             null, true),
			 new Array("wavelets/index.html#1DML",      "1D-Multi-Level-DWT", null, true),
			 new Array("wavelets/index.html#2DML",      "2D-Multi-Level-DWT", null, true),
			 new Array("wavelets/index.html#reduction", "Teilinformation",    null, true),
			 new Array("wavelets/index.html#denoise",   "Bildglttung",       null, true),
			 new Array("wavelets/index.html#results",   "Resultate",          null, true),
			 new Array("wavelets/index.html#coeff",     "Anhang (Filter)",    null, true));

  // ---------------------------------------------------------------------------------
  // CODE

  var codeSubE3D =  new Array(new Array("code/index.html#e3dFractal",    "3D Fractal Generator",  null, true),
			      new Array("code/index.html#e3dDWT",        "DWT-Image-Smoother",    null, true),
			      new Array("code/index.html#e3dBezier",     "Bezier Renderer",       null, true),
			      new Array("code/index.html#e3dTypewriter", "Special Font-Renderer", null, true));

  var codeSubJava = new Array(new Array("code/index.html#E3D", "E3D", codeSubE3D, true));

  var codeSubJS = new Array(new Array("code/index.html#navbar", "(Diese) Navigations-Leiste", null, true),
			    new Array("code/index.html#galery", "Bild-Galerie", null, true));

  var codeSubCPP =  new Array(new Array("code/index.html#contentManager", "Content-Manager", null, true),
			      new Array("code/index.html#d3",             "3-D",             null, true),
			      new Array("code/index.html#photoimage",     "Tiff/Jpeg",       null, true),
			      new Array("code/index.html#fraktale",       "Fraktale",        null, true));

  var codeSubTCL = new Array(new Array("code/index.html#psprint", "PS-Print", null, true));

  var codeSubPerl = new Array(new Array("code/index.html#speedbar",       "Navigations-Leiste (CGI)", null, true));

  var codeSubMatlab = new Array(new Array("code/index.html#matlabFractal", "Fraktal (Mini-Beispiel)", null, true));

  var codeSub = new Array(new Array("code/index.html#java",  "Java",       codeSubJava,   true),
			  new Array("code/index.html#js",    "JavaScript", codeSubJS,     true),
			  new Array("code/index.html#cpp",   "C++",        codeSubCPP,    true),
			  new Array("code/index.html#tcl",   "Tcl/Tk",     codeSubTCL,    true),
			  new Array("code/index.html#perl",  "Perl",       codeSubPerl,   true),
			  new Array("code/index.html#matlab","Matlab",     codeSubMatlab, true));
  
  // ---------------------------------------------------------------------------------
  // RADWEG

  var radwegSub = new Array(new Array("radweg/index.html#Heckerdamm",            "Heckerdamm",              null, true),
			    new Array("radweg/index.html#KaiserFriedrichStrasse","Kaiser-Friedrich-Strae", null, true),
			    new Array("radweg/index.html#KurtSchumacherDamm",    "Kurt-Schumacher-Damm",    null, true),
			    new Array("radweg/index.html#KurtSchumacherPlatz",   "Kurt-Schumacher-Platz",   null, true),
			    new Array("radweg/index.html#NeuendorferStrasse",    "Neuendorfer Strae",      null, true),
			    new Array("radweg/index.html#OllenhauerStrasse",     "Ollenhauer Strae",       null, true),
			    new Array("radweg/index.html#LuisenPlatz",           "Luisenplatz",             null, true),
			    new Array("radweg/index.html#BernauerStrasse",       "Bernauer Strae",         null, true),
			    new Array("radweg/index.html#FuerstenbrunnerWeg",    "Frstenbrunner Weg",      null, true),
			    new Array("radweg/index.html#Muellerstrasse",        "Mllerstrae",            null, true),
			    new Array("radweg/index.html#NeheimerStrasse",       "Neheimer Strae",         null, true),
			    new Array("radweg/index.html#Reichstag",             "Reichstag",               null, true),
			    new Array("radweg/index.html#PotsdamerPlatz",        "Potsdamer Platz",         null, true),
			    new Array("radweg/index.html#LuetzowPlatz",          "Ltzowplatz",             null, true),
			    new Array("radweg/index.html#OranienburgerChaussee", "Oranienburger Chaussee",  null, true),
			    new Array("radweg/index.html#Heerstr",               "Heerstrae",              null, true),
			    new Array("radweg/index.html#Bismarckstr",           "Bismarckstrae",          null, true),
			    new Array("radweg/index.html#RuhlebenerStr",         "Ruhlebener Strae",       null, true),
			    new Array("radweg/index.html#Seestr",                "Seestrae",               null, true));
  
  // ---------------------------------------------------------------------------------
  // BICYLE

  var bicycleFSub = new Array(new Array("bicycle/Frankreich.html#Korsika",   "Korsika",                      null, true),
			      new Array("bicycle/Frankreich.html#Pyrenaeen", "Pyrenen I",                   null, true),
			      new Array("bicycle/Frankreich.html#Atlantik",  "Pyrenen II, Atlantik, Paris", null, true),
			      new Array("bicycle/Frankreich.html#CoteDAzur", "Cote d\'Azur, Provence",       null, true));

  var bicycleISub = new Array(new Array("bicycle/Italien.html#Verona",  "Dolomiten - Ligurien - Toskana", null, true),
			      new Array("bicycle/Italien.html#Trieste", "Trieste",                        null, true));

  var bicycleHRSub = new Array(new Array("bicycle/Kroatien.html#Istrien",        "Istrien",      null, true),
			       new Array("bicycle/Kroatien.html#Kuestenstrasse", "Kstenstrae", null, true));


  var bicycleSub = new Array(new Array("bicycle/index.html#Karte", "Karte",       null,         true),
			     new Array("bicycle/Frankreich.html",  "Frankreich",  bicycleFSub,  false),
			     new Array("bicycle/Spanien.html",     "Spanien",     null,         false),
			     new Array("bicycle/Italien.html",     "Italien",     bicycleISub,  false),
			     new Array("bicycle/Oesterreich.html", "sterreich",  null,         false),
			     new Array("bicycle/Slowenien.html",   "Slowenien",   null,         false),
			     new Array("bicycle/Kroatien.html",    "Kroatien",    bicycleHRSub, false),
			     new Array("bicycle/Daenemark.html",   "Dnemark",    null,         false),
			     new Array("bicycle/Deutschland.html", "Deutschland", null,         false),
			     new Array("bicycle/Technik.html",     "Technik",     null,         false));
  
  // ---------------------------------------------------------------------------------
  // HOME
  
  var homeSub = new Array(new Array("probnet/index.html",     "Bayes\'sche Netze",            probNetSub,   false),
			  new Array("fractal/index.html",     "Fraktale",                     fractalSub,   false),
			  new Array("bezier/index.html",      "Bezier-Surfaces",              bezierSub,    false),
			  new Array("rendering/index.html",   "Rendering",                    renderingSub, false),
			  new Array("bicycle/index.html",     "Fahrrad",                      bicycleSub,   false),
			  new Array("radweg/index.html",      "Radweg",                       radwegSub,    false),
			  new Array("lut/index.html",         "OCR",                          null,         false),
			  new Array("optical/index.html",     "Optische Tuschungen",         optSub,       false),
			  new Array("arts/index.html",        "Die Gezeichneten",             null,         false),
			  new Array("profiler/index.html",    "C/C++ Profiler (gprof)",       null,         false),
			  new Array("wavelets/index.html",    "Bildglttung (Wavelets)",      dwtSub,       false),
			  new Array("code/index.html",        "Code",                         codeSub,      false),
			  new Array("Patrick_Rammelt.html",   "Me, myself and I",             null,         false),
			  new Array("funny/index.html",       "Sprche, Zitate,...",          null,         false),
			  new Array("http://patricks-seite.de/tinc?key=99rh3MC0", "Feedback", null,         false));

  var home = new Array(new Array("index.html", "Home", homeSub, false));
  
  return (home);
}


/* 
 * Mark entries which should not be shown for the current site 
 * site:     current site (e.g. "probnet/index.html")
 * entries:  navigation bar entries for the current (sub) menu
 */
function markEntries (site, entries)
{
  var isIn = false;
  for (var i = 0; i < entries.length; i++) {
    var entry = entries[i];
    var subEntries = entry[2];
    if (subEntries != null) {
      if (markEntries(site, subEntries)) {
	entry[3] = true;
	isIn = true;
      }
    } 
    if (entry[0] == site) {
      entry[3] = true;
      isIn = true;
    } 
  }
  return (isIn)
}


/* Is the given URL relative? */
function isURLRelative (url) 
{
  for (var i = 0; i < NAV_ABSOLUTE_URLS.length; i++) {
    if (url.indexOf(NAV_ABSOLUTE_URLS[i]) == 0) return (false);
  }
  return (true);
}


/* Points the given URL to an external site? */
function isURLExternal (url)
{
  if (isURLRelative(url)) return (false);
  for (var i = 0; i < NAV_INTERNAL_URLS.length; i++) {
    if (url.indexOf(NAV_INTERNAL_URLS[i]) == 0) return (false);
  }
  return (true);
}


/* Points the given URL to an anchor inside of a page? */
function isURLAnchor (url)
{
  return (url.indexOf("#") >= 0);
}


/** If the given url is relative add the base-path to it */
function completeURL (url, basePath) 
{
  return (isURLRelative(url) ? basePath + url : url);
}


/* 
 * Get navigation bar entries as the html content of a div element
 * basePath: path to the base directory
 * site:     current site (e.g. "probnet/index.html")
 * entries:  navigation bar entries for the current (sub) menu
 * indent:   indentation text (e.g. "&nbsp;&nbsp&nbsp;&nbsp")
 */
function getNavBarContent (basePath, site, entries, indent)
{
  var content = "";
  for (var i = 0; i < entries.length; i++) {
    var entry = entries[i];
    var subEntries = entry[2];
    var ref        = (entry[0] == null ? entry[1].toHTML()                                                     // no link (grouping item)
		      : "<a href=\"" + completeURL(entry[0], basePath) + "\">" + entry[1].toHTML() + "</a>");  // link
    var type       = (entry[0] == null ? "" 
		      :"&nbsp;<img src=\"" + basePath +                       
		      (entry[0] == site         ? NAV_CURRENT_IMG  + "\" title=\"" + NAV_CURRENT_TOOLTIP  + "\"" :
		       (isURLExternal(entry[0]) ? NAV_EXTERNAL_IMG + "\" title=\"" + NAV_EXTERNAL_TOOLTIP + "\"" : 
			(isURLAnchor(entry[0])  ? NAV_ANCHOR_IMG   + "\" title=\"" + NAV_ANCHOR_TOOLTIP   + "\"" 
			 :                        NAV_LINK_IMG     + "\" title=\"" + NAV_LINK_TOOLTIP     + "\""))) + 
		      " alt=\"\" style=\"border: 0px solid;\">");  // link type image
    if (subEntries == null) {
      content += (indent + 
		  "<img src=\"" + basePath + NAV_LEAF_IMG + "\" alt=\"\[*\]\" style=\"border: 0px solid;\">&nbsp;\n" +
		  ref + type + "<br>\n");
    } else if (entry[3]) {
      var subContent = getNavBarContent(basePath, site, subEntries, indent + NAV_INDENT);
      content += (indent + 
		  "<img src=\"" + basePath + NAV_OPENED_IMG + "\" alt=\"\[-\]\" style=\"border: 0px solid;\">&nbsp;\n" + 
		  ref + type + "<br>\n" +
		  subContent);
    } else {
      content += (indent + 
		  "<img src=\"" + basePath + NAV_CLOSED_IMG + "\" alt=\"\[+\]\" style=\"border: 0px solid;\">&nbsp;\n" +
		  ref + type + "<br>\n");
    }
  }
  return (content);
}


/* Show naviagtion bar */
function showNavBar () 
{  
  var areaElem   = document.getElementById(NAV_AREA_ID);
  var sliderElem = document.getElementById(NAV_SLIDER_ID);
  areaElem.style.top = getTop(sliderElem);
  areaElem.style.visibility   = "visible";
  sliderElem.style.visibility = "hidden";
}


/* Hide navigation bar */
function hideNavBar () 
{
  var areaElem   = document.getElementById(NAV_AREA_ID);
  var sliderElem = document.getElementById(NAV_SLIDER_ID);
  areaElem.style.visibility   = "hidden";
  sliderElem.style.visibility = "visible";
}


/* Relocate navigation bar (according to vertical scroll) */
function relocateNavBar ()
{
  // set position of the navigation bar
  var lower       = upper + NAV_HEIGHT;         // lower y-coordinate of the navigation area (var upper is global!)
  var height      = document.body.clientHeight; // window height (without scrollbars)
  var top         = getVScrollOffset();         // top-most visible y-coordinate
  var bottom      = top + height;               // bottom-most visible y-coordinate
  var upperMargin = upper  - top;
  var lowerMargin = bottom - lower;
  if (height >= NAV_HEIGHT || upperMargin > 0) {
    upper = top;
  } else if (lowerMargin > 0) {
    upper = bottom - NAV_HEIGHT;
  }
  //document.getElementById(NAV_AREA_ID  ).style.top = upper; // move when getting visible to avoid nasty scrolling effects
  document.getElementById(NAV_SLIDER_ID).style.top = upper;   
}


/* Handle mouse moves (show / hide navigation bar and set its position) */
function handleEvent (evnt) 
{
  if (!evnt) evnt = window.event;

  relocateNavBar();

  // show / hide navigation bar
  var x = (evnt.pageX ? evnt.pageX : evnt.clientX);
  if (x <= NAV_SLIDER_WIDTH) { 
    showNavBar();
  } else if (x > NAV_AREA_WIDTH) { 
    hideNavBar();
  }
}


/* 
 * Init navigation bar 
 * site      current site (e.g. "probnet/index.html")
 * subLevel  sub directory level (0 in main directory, 1 for the upper example...)
 */
function initNavBar (site, subLevel) 
{
  basePath = "";
  for (i = 0; i < subLevel; i++) basePath += "../";

  var entries = getNavBarEntries();
  markEntries(site, entries);

  var sliderElem = document.getElementById(NAV_SLIDER_ID);
  sliderElem.style.zIndex = 1000000;
  sliderElem.innerHTML 
    = "<img src=\"" + basePath + NAV_SLIDER_IMG + "\" alt=\"\" width=\"" + NAV_SLIDER_WIDTH + "\" height=\"" + NAV_HEIGHT + "\">";

  var areaElem = document.getElementById(NAV_AREA_ID);
  areaElem.style.zIndex = 1000000;
  areaElem.innerHTML 
    = "<img src=\"" + basePath + NAV_AREA_IMG + "\" width=\"" + NAV_AREA_WIDTH + "\" height=\"" + NAV_HEIGHT + "\" border=\"0\" alt=\"\">\n" 
    + "<div id=\"" + NAV_LINKS_ID + "\">\n" 
    + getNavBarContent(basePath, site, entries, "") 
    + "</div>\n";

  addEventListener(document, "mousemove", handleEvent);

  // initial positioning / opening
  upper = 0;
  relocateNavBar();
}
