/*
 * -------------------------------------------------------------------------
 *
 *  progress.js Copyright (C) 2011, 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Author: Patrick Rammelt 
 *   E-Mail: patrick.rammelt@go4more.de
 *   Site:   http://www.patricks-seite.de
 * -------------------------------------------------------------------------
 *
 * This module could be used to show a progress bar.
 *
 * To make this work a site has to start like this:
 * <html>
 * <head>
 *   [...meta tags, etc...]
 *   <script type="text/javascript" src="../js/dhtml.js"></script>
 *   <script type="text/javascript" src="../js/progress.js"></script>
 *   <style type="text/css">
 *     body      { background-color:rgb(0, 0, 102); color:rgb(0, 51, 0); 
 *                 background-image:url(bg.jpg); margin:0; padding:25px 10px; }
 *     #Progress { position:absolute; top:0px; left:0; visibility:hidden; }
 *   </style>
 * </head>
 * <body vlink="#003300" alink="#ff0000" link="#003300">
 * <div id="Progress"><img src="../js/waiting.gif" alt="Wait..."></div>
 * [...]
 */


/* IDs */
var BAR_ID = "Progress";  // ID of the div element for the progress bar


/* Show progress bar */
function showProgressBar () 
{  
  var bar    = document.getElementById(BAR_ID);
  var left   = getHScrollOffset();         // left-most visible x-coordinate
  var top    = getVScrollOffset();         // top-most visible y-coordinate
  var width  = document.body.clientWidth;  // window height (without scrollbars)
  var height = document.body.clientHeight; // window height (without scrollbars)
  bar.style.left = left + (width  - bar.offsetWidth) / 2;  
  bar.style.top  = top  + (height - bar.offsetHeight) / 2;        
  bar.style.visibility = "visible";
}


/* Hide progress bar */
function hideProgressBar () 
{
  var bar = document.getElementById(BAR_ID);
  bar.style.visibility = "hidden";
}
