/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public final class FontData {
    public LOGFONT data;
    public float height;
    String lang;
    String country;
    String variant;

    public FontData() {
        this.data = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        this.data.lfCharSet = 1;
        this.height = 12.0f;
    }

    FontData(LOGFONT lOGFONT, float f) {
        this.data = lOGFONT;
        this.height = f;
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = 0;
        int n2 = string.indexOf(124);
        if (n2 == -1) {
            SWT.error(5);
        }
        String string2 = string.substring(n, n2);
        try {
            if (Integer.parseInt(string2) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((n2 = string.indexOf(124, n = n2 + 1)) == -1) {
            SWT.error(5);
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            SWT.error(5);
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        if (n2 == -1) {
            SWT.error(5);
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        this.data = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        this.data.lfCharSet = 1;
        this.setName(string3);
        this.setHeight(f);
        this.setStyle(n3);
        if (n2 == -1) {
            return;
        }
        String string4 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            return;
        }
        String string5 = string.substring(n, n2);
        if (string4.equals("WINDOWS") && string5.equals("1")) {
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            try {
                n = n2 + 1;
                n2 = string.indexOf(124, n);
                if (n2 == -1) {
                    return;
                }
                lOGFONT.lfHeight = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfWidth = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfEscapement = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfOrientation = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfWeight = Integer.parseInt(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfItalic = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfUnderline = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfStrikeOut = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfCharSet = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfOutPrecision = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfClipPrecision = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfQuality = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
                if ((n2 = string.indexOf(124, n)) == -1) {
                    return;
                }
                lOGFONT.lfPitchAndFamily = Byte.parseByte(string.substring(n, n2));
                n = n2 + 1;
            }
            catch (NumberFormatException numberFormatException) {
                this.setName(string3);
                this.setHeight(f);
                this.setStyle(n3);
                return;
            }
            TCHAR tCHAR = new TCHAR(0, string.substring(n), false);
            int n4 = Math.min(31, tCHAR.length());
            if (OS.IsUnicode) {
                char[] cArray = lOGFONT.lfFaceName;
                System.arraycopy(tCHAR.chars, 0, cArray, 0, n4);
            } else {
                byte[] byArray = ((LOGFONTA)lOGFONT).lfFaceName;
                System.arraycopy(tCHAR.bytes, 0, byArray, 0, n4);
            }
            this.data = lOGFONT;
        }
    }

    public FontData(String string, int n, int n2) {
        if (string == null) {
            SWT.error(4);
        }
        this.data = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        this.setName(string);
        this.setHeight(n);
        this.setStyle(n2);
        this.data.lfCharSet = 1;
    }

    FontData(String string, float f, int n) {
        if (string == null) {
            SWT.error(4);
        }
        this.data = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        this.setName(string);
        this.setHeight(f);
        this.setStyle(n);
        this.data.lfCharSet = 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontData)) {
            return false;
        }
        FontData fontData = (FontData)object;
        LOGFONT lOGFONT = fontData.data;
        return this.data.lfCharSet == lOGFONT.lfCharSet && this.height == fontData.height && this.data.lfWidth == lOGFONT.lfWidth && this.data.lfEscapement == lOGFONT.lfEscapement && this.data.lfOrientation == lOGFONT.lfOrientation && this.data.lfWeight == lOGFONT.lfWeight && this.data.lfItalic == lOGFONT.lfItalic && this.data.lfUnderline == lOGFONT.lfUnderline && this.data.lfStrikeOut == lOGFONT.lfStrikeOut && this.data.lfCharSet == lOGFONT.lfCharSet && this.data.lfOutPrecision == lOGFONT.lfOutPrecision && this.data.lfClipPrecision == lOGFONT.lfClipPrecision && this.data.lfQuality == lOGFONT.lfQuality && this.data.lfPitchAndFamily == lOGFONT.lfPitchAndFamily && this.getName().equals(fontData.getName());
    }

    int EnumLocalesProc(int n) {
        int n2 = 8;
        TCHAR tCHAR = new TCHAR(0, n2);
        int n3 = n2 * TCHAR.sizeof;
        OS.MoveMemory(tCHAR, n, n3);
        int n4 = Integer.parseInt(tCHAR.toString(0, tCHAR.strlen()), 16);
        int n5 = OS.GetLocaleInfo(n4, 89, tCHAR, n2);
        if (n5 <= 0 || !this.lang.equals(tCHAR.toString(0, n5 - 1))) {
            return 1;
        }
        if (!(this.country == null || (n5 = OS.GetLocaleInfo(n4, 90, tCHAR, n2)) > 0 && this.country.equals(tCHAR.toString(0, n5 - 1)))) {
            return 1;
        }
        n5 = OS.GetLocaleInfo(n4, 4100, tCHAR, n2);
        if (n5 <= 0) {
            return 1;
        }
        int n6 = Integer.parseInt(tCHAR.toString(0, n5 - 1));
        int[] nArray = new int[8];
        OS.TranslateCharsetInfo(n6, nArray, 2);
        this.data.lfCharSet = (byte)nArray[0];
        return 0;
    }

    public int getHeight() {
        return (int)(0.5f + this.height);
    }

    float getHeightF() {
        return this.height;
    }

    public String getLocale() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '_';
        if (this.lang != null) {
            stringBuffer.append(this.lang);
            stringBuffer.append(c);
        }
        if (this.country != null) {
            stringBuffer.append(this.country);
            stringBuffer.append(c);
        }
        if (this.variant != null) {
            stringBuffer.append(this.variant);
        }
        if ((n = (string = stringBuffer.toString()).length()) > 0 && string.charAt(n - 1) == c) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public String getName() {
        char[] cArray;
        if (OS.IsUnicode) {
            cArray = ((LOGFONTW)this.data).lfFaceName;
        } else {
            cArray = new char[32];
            byte[] byArray = ((LOGFONTA)this.data).lfFaceName;
            OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\u0000') break;
            ++n;
        }
        return new String(cArray, 0, n);
    }

    public int getStyle() {
        int n = 0;
        if (this.data.lfWeight == 700) {
            n |= 1;
        }
        if (this.data.lfItalic != 0) {
            n |= 2;
        }
        return n;
    }

    public int hashCode() {
        return this.data.lfCharSet ^ this.getHeight() ^ this.data.lfWidth ^ this.data.lfEscapement ^ this.data.lfOrientation ^ this.data.lfWeight ^ this.data.lfItalic ^ this.data.lfUnderline ^ this.data.lfStrikeOut ^ this.data.lfCharSet ^ this.data.lfOutPrecision ^ this.data.lfClipPrecision ^ this.data.lfQuality ^ this.data.lfPitchAndFamily ^ this.getName().hashCode();
    }

    public void setHeight(int n) {
        if (n < 0) {
            SWT.error(5);
        }
        this.height = n;
    }

    void setHeight(float f) {
        if (f < 0.0f) {
            SWT.error(5);
        }
        this.height = f;
    }

    public void setLocale(String string) {
        int n;
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (string != null) {
            int n2;
            int n3 = 95;
            n = string.length();
            int n4 = string.indexOf(n3);
            if (n4 == -1) {
                n4 = n2 = n;
            } else {
                n2 = string.indexOf(n3, n4 + 1);
                if (n2 == -1) {
                    n2 = n;
                }
            }
            if (n4 > 0) {
                this.lang = string.substring(0, n4);
            }
            if (n2 > n4 + 1) {
                this.country = string.substring(n4 + 1, n2);
            }
            if (n > n2 + 1) {
                this.variant = string.substring(n2 + 1);
            }
        }
        if (this.lang == null) {
            this.data.lfCharSet = 1;
        } else {
            Callback callback = new Callback(this, "EnumLocalesProc", 1);
            n = callback.getAddress();
            if (n == 0) {
                SWT.error(3);
            }
            OS.EnumSystemLocales(n, 2);
            callback.dispose();
        }
    }

    public void setName(String string) {
        if (string == null) {
            SWT.error(4);
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        int n = Math.min(31, tCHAR.length());
        if (OS.IsUnicode) {
            char[] cArray = ((LOGFONTW)this.data).lfFaceName;
            int n2 = 0;
            while (n2 < cArray.length) {
                cArray[n2] = '\u0000';
                ++n2;
            }
            System.arraycopy(tCHAR.chars, 0, cArray, 0, n);
        } else {
            byte[] byArray = ((LOGFONTA)this.data).lfFaceName;
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = 0;
                ++n3;
            }
            System.arraycopy(tCHAR.bytes, 0, byArray, 0, n);
        }
    }

    public void setStyle(int n) {
        this.data.lfWeight = (n & 1) == 1 ? 700 : 0;
        this.data.lfItalic = (n & 2) == 2 ? (byte)1 : 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("1|");
        stringBuffer.append(this.getName());
        stringBuffer.append("|");
        stringBuffer.append(this.getHeightF());
        stringBuffer.append("|");
        stringBuffer.append(this.getStyle());
        stringBuffer.append("|");
        stringBuffer.append("WINDOWS|1|");
        stringBuffer.append(this.data.lfHeight);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfWidth);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfEscapement);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfOrientation);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfWeight);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfItalic);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfUnderline);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfStrikeOut);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfCharSet);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfOutPrecision);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfClipPrecision);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfQuality);
        stringBuffer.append("|");
        stringBuffer.append(this.data.lfPitchAndFamily);
        stringBuffer.append("|");
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public static FontData win32_new(LOGFONT lOGFONT, float f) {
        return new FontData(lOGFONT, f);
    }
}

