/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import e3d.wavelet.DWTFilter;

public class DWTSynthesizer
extends DWTFilter {
    public static final int MODE_DONT_COPY_OUTPUT_TO_INPUT_FIRST = 0;
    public static final int MODE_COPY_OUTPUT_TO_INPUT_FIRST = 1;

    public DWTSynthesizer() {
    }

    public DWTSynthesizer(DWTSynthesizer flt) {
        this.set(flt);
    }

    public DWTSynthesizer(double[] low, double[] high) {
        this.set(low, high);
    }

    @Override
    public void set(double[] low, double[] high) {
        super.set(high, low);
        this.reverse(this.coefficients[0]);
        this.reverse(this.coefficients[1]);
    }

    void set(DWTSynthesizer dwtFilter) {
        super.set(dwtFilter.coefficients[0], dwtFilter.coefficients[1]);
    }

    @Override
    public double[] apply(double[][] signals, int length, int step, int filter, int[] offsets) {
        int filterOffset = this.filterOffset();
        int inputOffset = offsets[1] + this.signalOffset(length, filter) * step;
        this.synthesize(signals[1], signals[0], length, step, filter, inputOffset, offsets[0], filterOffset);
        return signals[0];
    }

    protected void synthesize(double[] input, double[] output, int outputLength, int step, int filter, int inputOffset, int outputOffset, int filterOffset) {
        int yi = 0;
        while (yi < outputLength / 2) {
            int ci = 0;
            while (ci < this.coefficients[filter].length) {
                int i = this.index(2 * yi - ci + filterOffset, outputLength) * step + outputOffset;
                int j = yi * step + inputOffset;
                int n = i;
                output[n] = output[n] + input[j] * this.coefficients[filter][ci];
                ++ci;
            }
            ++yi;
        }
    }

    @Override
    public double[] single(double[][] signals, int length, int step, int[] offsets, int mode) {
        int highOffset = this.signalOffset(length, 1) * step;
        if ((mode & 1) != 0) {
            this.copy(signals[0], signals[1], offsets[0] + highOffset, offsets[1] + highOffset, length / 2, step);
        }
        this.init(signals[0], 0.0, offsets[0], length, step);
        this.apply(signals, length, step, 0, offsets);
        this.apply(signals, length, step, 1, offsets);
        return signals[0];
    }

    @Override
    public double[] multi(double[][] signals, int diameter, int dimensions, int depth) {
        int maxDepth = this.getDepth(diameter, depth);
        int levels = maxDepth * dimensions;
        double[] input = signals[0];
        int[] len = this.lengths(dimensions, diameter >> maxDepth);
        int[] step = this.steps(dimensions, diameter);
        int[] offsets = new int[signals.length];
        int level = 0;
        while (level < levels) {
            int dimension = dimensions - 1;
            while (dimension >= 0) {
                int n = dimension;
                len[n] = len[n] * 2;
                this.toggle(signals, 0, 1);
                this.tile(signals, signals[1] != input ? 1 : 0, dimensions - 1, dimension, offsets, len, step);
                --dimension;
                ++level;
            }
            --maxDepth;
        }
        return signals[0];
    }
}

