/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import e3d.wavelet.DWTSynthesizer;

public class DWTNoiseSynthesizer
extends DWTSynthesizer {
    public static final int MODE_INITIALIZE_OUTPUT = 2;
    public static final int MODE_WEIGHTED_SYNTHESIZE = 4;
    public static final int MODE_SYNTHESIZE = 8;
    protected double level100;
    protected int shifts;
    protected int skip;

    public DWTNoiseSynthesizer() {
    }

    public DWTNoiseSynthesizer(DWTNoiseSynthesizer dwtFilter) {
        this.set(dwtFilter);
    }

    public DWTNoiseSynthesizer(double[] low, double[] high, double level100, int shiftLevels, int skipLevels) {
        this.set(low, high);
        this.setLevel100(level100);
        this.setShiftLevels(shiftLevels);
        this.setSkipLevels(skipLevels);
    }

    public void setLevel100(double level100) {
        this.level100 = level100;
    }

    public void setShiftLevels(int shiftLevels) {
        this.shifts = shiftLevels;
    }

    public void setSkipLevels(int skipLevels) {
        this.skip = skipLevels;
    }

    public double[] apply(double[][] signals, int length, int step, int filter, int offset) {
        int filterOffset = this.filterOffset();
        int inputOffset = offset + this.signalOffset(length, filter) * step;
        this.weighted(signals[1], signals[0], signals[3], length, step, filter, inputOffset, offset, offset, filterOffset);
        return signals[0];
    }

    protected void cumulate(double[] input, double[] output, int outputLength, int step, int filter, int inputOffset, int outputOffset, int filterOffset) {
        int yi = 0;
        while (yi < outputLength / 2) {
            int yj = yi * step + inputOffset;
            int ci = 0;
            while (ci < this.coefficients[filter].length) {
                int xj = this.index(2 * yi - ci + filterOffset, outputLength) * step + outputOffset;
                output[xj] = Math.max(Math.abs(output[xj]), Math.abs(input[yj]));
                ++ci;
            }
            ++yi;
        }
    }

    protected void weighted(double[] input, double[] output, double[] weights, int outputLength, int step, int filter, int inputOffset, int outputOffset, int weightOffset, int filterOffset) {
        int yi = 0;
        while (yi < outputLength / 2) {
            int yj = yi * step + inputOffset;
            int ci = 0;
            while (ci < this.coefficients[filter].length) {
                int offset = this.index(2 * yi - ci + filterOffset, outputLength) * step;
                int xj = offset + outputOffset;
                int wj = offset + weightOffset;
                int n = xj;
                output[n] = output[n] + input[yj] * this.coefficients[filter][ci] * weights[wj];
                ++ci;
            }
            ++yi;
        }
    }

    @Override
    public double[] single(double[][] signals, int length, int step, int[] offsets, int mode) {
        int inputOffset = offsets[1] + length / 2 * step;
        int filterOffset = this.filterOffset();
        if ((mode & 2) != 0) {
            this.init(signals[0], 0.0, offsets[0], length, step);
        }
        if ((mode & 8) != 0) {
            this.synthesize(signals[1], signals[0], length, step, mode & 1, inputOffset, offsets[0], filterOffset);
        } else if ((mode & 4) != 0) {
            this.weighted(signals[1], signals[0], signals[2], length, step, mode & 1, inputOffset, offsets[0], offsets[2], filterOffset);
        } else {
            this.cumulate(signals[1], signals[0], length, step, mode & 1, inputOffset, offsets[0], filterOffset);
        }
        return signals[0];
    }

    @Override
    public double[] multi(double[][] signals, int diameter, int dimensions, int depth) {
        int maxDepth = this.getDepth(diameter, depth);
        int[] lengths = this.lengths(dimensions, diameter);
        int[] steps = this.steps(dimensions, diameter);
        int numberOfWeights = steps[dimensions - 1] * diameter * 2;
        int levels = maxDepth * dimensions;
        double[] input = signals[0];
        double[] noise = signals[1];
        double[] weights = signals[2];
        if (this.level100 == 0.0) {
            this.init(weights, 0.0, 0, numberOfWeights, 1);
            this.init(noise, 0.0, 0, steps[dimensions - 1] * diameter, 1);
        } else {
            double[][] signals1 = new double[][]{weights, input};
            int[] shifts1 = new int[1];
            int shift = 0;
            while (shift < this.shifts) {
                int mode1 = (shift == 0 ? 1 : 0) | 2 | 1;
                int start = Math.max(0, this.shifts - shift - 1);
                this.shift(signals1, shifts1, levels - shift, start, lengths, steps, mode1);
                int i = 0;
                while (i < dimensions) {
                    lengths[i] = diameter;
                    ++i;
                }
                ++shift;
                signals1[1] = weights;
            }
            this.weight(weights, numberOfWeights, 1);
            double[][] signals2 = new double[][]{noise, input, weights};
            double[][] signals3 = new double[][]{input, input, weights};
            int[] nArray = new int[2];
            nArray[1] = 2;
            int[] shifts3 = nArray;
            int[] nArray2 = new int[3];
            nArray2[2] = numberOfWeights / 2;
            int[] offsets2 = nArray2;
            this.init(noise, 0.0, 0, steps[dimensions - 1] * diameter, 1);
            int shift2 = 0;
            while (shift2 < levels - this.shifts) {
                int mode2 = (shift2 == 0 ? 1 : 0) | (shift2 < this.skip ? 8 : 4);
                int mode3 = mode2 | 2;
                this.tile(signals2, mode2, dimensions - 1, 0, offsets2, lengths, steps);
                this.shift(signals3, shifts3, levels - shift2, 1, lengths, steps, mode3);
                int i = 0;
                while (i < dimensions) {
                    lengths[i] = diameter;
                    ++i;
                }
                ++shift2;
            }
        }
        this.toggle(signals, 0, 1);
        return noise;
    }

    protected double weighted(double value) {
        double weighted = 1.0 - Math.min(Math.max(Math.abs(value) / this.level100, 0.0), 1.0);
        return weighted;
    }

    protected void weight(double[] values, int length, int step) {
        --length;
        while (length >= 0) {
            values[length * step] = this.weighted(values[length * step]);
            --length;
        }
    }
}

