/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import e3d.utils.ProgressListener;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.util.E3DColor;
import e3d.wavelet.DWTImageSmoother;
import java.io.File;
import java.io.IOException;

public class DWTImageSmootherCmdLine {
    private static ProgressListener listener = new ProgressListener(){
        private int step = -100;
        private int steps = 100;

        @Override
        public void done(int step, String task) {
            if (step >= this.step + 5) {
                System.out.println(String.valueOf(step) + "% - " + task);
                this.step = step;
            }
        }

        @Override
        public int done() {
            return this.step;
        }

        @Override
        public int steps() {
            return this.steps;
        }

        @Override
        public void init(int steps, String task) {
            this.steps = 0;
            this.step = -100;
        }

        @Override
        public void finish() {
        }
    };

    public static void main(String[] args) throws Exception {
        String in = null;
        String out = null;
        E3DColor.Channel[] channels = DWTImageSmoother.CHANNELS_RGB;
        int tileSize = 512;
        int tileOverlap = 64;
        int depth = 0;
        int shifts = 3;
        int skip = 0;
        int radius = 5;
        int blur = 1;
        double level100 = 128.0;
        double delta = 64.0;
        boolean showAnalyzed = false;
        boolean showNoise = false;
        boolean showWeights = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].compareTo("-in") == 0 && i + 1 < args.length) {
                in = args[++i];
            } else if (args[i].compareTo("-out") == 0 && i + 1 < args.length) {
                out = args[++i];
            } else if (args[i].compareTo("-depth") == 0 && i + 1 < args.length) {
                depth = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-shifts") == 0 && i + 1 < args.length) {
                shifts = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-skip") == 0 && i + 1 < args.length) {
                skip = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-level100") == 0 && i + 1 < args.length) {
                level100 = Double.parseDouble(args[++i]);
            } else if (args[i].compareTo("-blur") == 0 && i + 1 < args.length) {
                blur = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-delta") == 0 && i + 1 < args.length) {
                delta = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-radius") == 0 && i + 1 < args.length) {
                radius = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-mode") == 0 && i + 1 < args.length) {
                if (args[++i].equals("rgb")) {
                    channels = DWTImageSmoother.CHANNELS_RGB;
                } else if (args[i].equals("rgba")) {
                    channels = DWTImageSmoother.CHANNELS_RGBA;
                } else if (args[i].equals("gray")) {
                    channels = DWTImageSmoother.CHANNELS_GRAY;
                } else if (args[i].equals("grayalpha")) {
                    channels = DWTImageSmoother.CHANNELS_GRAYALPHA;
                }
            } else if (args[i].compareTo("-tileSize") == 0 && i + 1 < args.length) {
                tileSize = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-overlap") == 0 && i + 1 < args.length) {
                tileOverlap = Integer.parseInt(args[++i]);
            } else if (args[i].compareTo("-filter") == 0) {
                showAnalyzed = true;
            } else if (args[i].compareTo("-noise") == 0) {
                showNoise = true;
            } else if (args[i].compareTo("-weights") == 0) {
                showWeights = true;
            } else if (args[i].compareTo("-debug") == 0) {
                showWeights = true;
                showNoise = true;
                showAnalyzed = true;
            } else {
                if (args[i].compareTo("-help") == 0) {
                    System.out.println(DWTImageSmootherCmdLine.class.getSimpleName());
                    System.out.println("  OPTION                   | DEF | EXPLANATION");
                    System.out.println("  -in infile               |     | in any common format");
                    System.out.println("  -out outfile             |     | a PNG outfile");
                    System.out.println("  [-depth depth]           | 0   | max. depth of filtering (0 means use max. possible depth)");
                    System.out.println("  [-shifts shifts]         | 3   | shift levels (this should be 3)");
                    System.out.println("  [-skip skip]             | 0   | skip N levels (normally 0)");
                    System.out.println("  [-level100 100%-level]   | 128 | values >= this will be weighted by the max. weight 1");
                    System.out.println("  [-delta blur-100%-level] | 64  | max. delta for the selective blur filter");
                    System.out.println("  [-blur blur-depth]       | 1   | max. depth of levels to apply the blur filter to");
                    System.out.println("  [-radius blur-radius]    | 5   | radius for the selective blur filter");
                    System.out.println("  [{-rgb|-grey}]           | RGB | full color or greyscale mode");
                    System.out.println("  [-size tile-size]        | 512 | size of tiles (must be a power of 2!)");
                    System.out.println("  [-overlap tile-overlap]  | 64  | overlap of tiles in both: x- and y-direction");
                    System.out.println("  [-filter]                | no  | create debug images showing the analyze filtered signal for each tile");
                    System.out.println("  [-noise]                 | no  | create debug images showing the noise signal for each tile");
                    System.out.println("  [-weights]               | no  | create debug images showing the weights for each tile");
                    System.out.println("  [-debug]                 | no  | the same as -filter -noise -weights");
                    return;
                }
                System.out.print("Unknown option: \"" + args[i] + "\" - try option '-help'\n");
                return;
            }
            ++i;
        }
        if (in == null) {
            throw new IOException("No input file\n");
        }
        if (out == null) {
            throw new IOException("No output file\n");
        }
        System.out.println("input             = " + in);
        System.out.println("output            = " + out);
        System.out.println("tile size/overlap = " + tileSize + "/" + tileOverlap);
        System.out.println("level 100%        = " + level100);
        System.out.println("delta             = " + delta);
        System.out.println("blur-depth        = " + blur);
        System.out.println("radius            = " + radius);
        System.out.println("shifts            = " + shifts);
        System.out.println("skip              = " + skip);
        System.out.println("depth             = " + depth);
        System.out.println("Read image \"" + in + "\"");
        System.out.flush();
        E3DImageAWT inImg = new E3DImageAWT(new File(in));
        DWTImageSmoother smoother = new DWTImageSmoother();
        smoother.setChannels(channels);
        smoother.setTileSizeAndOverlap(tileSize, tileOverlap);
        smoother.setDepth(depth);
        smoother.setShifts(shifts);
        smoother.setSkip(skip);
        smoother.setBlurRadius(radius);
        smoother.setBlurLevels(blur);
        smoother.setLevel100(level100);
        smoother.setBlurDelta(delta);
        smoother.setDebugOptions(showAnalyzed, showNoise, showWeights, new File(out).getParentFile());
        smoother.addProgressListener(listener);
        E3DImage outImg = smoother.smooth(inImg);
        System.out.print("Write image\n");
        System.out.flush();
        outImg.save(new File(out), E3DImage.Format.PNG);
    }
}

