/*
 * Decompiled with CFR 0.152.
 */
package e3d.wavelet;

import java.util.Arrays;

public abstract class DWTFilter {
    public static final int FILTER_LOW = 0;
    public static final int FILTER_HIGH = 1;
    public static final double[] DWT_DEBAUCHY97_LOW = new double[]{0.02674875741080976, -0.01686411844287495, -0.07822326652898785, 0.2668641184428723, 0.6029490182363579, 0.2668641184428723, -0.07822326652898785, -0.01686411844287495, 0.02674875741080976};
    public static final double[] DWT_DEBAUCHY97_HIGH = new double[]{0.09127176311424948, -0.05754352622849957, -0.591271763114247, 1.115087052456994, -0.591271763114247, -0.05754352622849957, 0.09127176311424948};
    public static final double[] DWT_FILTER53_LOW = new double[]{-0.125, 0.25, 0.75, 0.25, -0.125};
    public static final double[] DWT_FILTER53_HIGH = new double[]{-0.5, 1.0, -0.5};
    final double[][] coefficients = new double[2][];

    public DWTFilter() {
        this.coefficients[0] = null;
        this.coefficients[1] = null;
    }

    public void set(double[] low, double[] high) {
        this.coefficients[0] = Arrays.copyOf(low, low.length);
        this.coefficients[1] = Arrays.copyOf(high, high.length);
    }

    public void set(DWTFilter dwtFilter) {
        this.set(dwtFilter.coefficients[0], dwtFilter.coefficients[1]);
    }

    public void clear() {
        this.coefficients[0] = null;
        this.coefficients[1] = null;
    }

    abstract double[] apply(double[][] var1, int var2, int var3, int var4, int[] var5);

    public abstract double[] single(double[][] var1, int var2, int var3, int[] var4, int var5);

    public abstract double[] multi(double[][] var1, int var2, int var3, int var4);

    protected int maxDepth(int length) {
        int i = 0;
        while (length != 0) {
            if ((length & 1) != 0) {
                return i;
            }
            length /= 2;
            ++i;
        }
        return 0;
    }

    public int getDepth(int length, int depth) {
        int maximum = this.maxDepth(length);
        if (depth <= 0) {
            return maximum + depth;
        }
        if (depth > maximum) {
            return maximum;
        }
        return depth;
    }

    protected void reverse(double[] coefficients) {
        int i = 1;
        int n = (coefficients.length - 1) / 2;
        while (i <= n) {
            double signum = (i & 1) != 0 ? -1 : 1;
            int n2 = n + i;
            coefficients[n2] = coefficients[n2] * signum;
            int n3 = n - i;
            coefficients[n3] = coefficients[n3] * signum;
            this.toggle(coefficients, n + i, n - i);
            ++i;
        }
    }

    protected int[] lengths(int dimensions, int virtualLength) {
        int[] len = new int[dimensions];
        len[0] = virtualLength;
        int d = 1;
        while (d < dimensions) {
            len[d] = virtualLength;
            ++d;
        }
        return len;
    }

    protected int[] steps(int dimensions, int physicalLength) {
        int[] step = new int[dimensions];
        step[0] = 1;
        int d = 1;
        while (d < dimensions) {
            step[d] = physicalLength * step[d - 1];
            ++d;
        }
        return step;
    }

    protected void tile(double[][] signals, int mode, int dimension, int tileDimension, int[] offsets, int[] lengths, int[] steps) {
        if (dimension < 0) {
            this.single(signals, lengths[tileDimension], steps[tileDimension], offsets, mode);
        } else if (dimension == tileDimension) {
            this.tile(signals, mode, dimension - 1, tileDimension, offsets, lengths, steps);
        } else {
            int[] localOffsets = Arrays.copyOf(offsets, offsets.length);
            int i = 0;
            while (i < lengths[dimension]) {
                this.tile(signals, mode, dimension - 1, tileDimension, localOffsets, lengths, steps);
                int s = 0;
                while (s < offsets.length) {
                    int n = s++;
                    localOffsets[n] = localOffsets[n] + steps[dimension];
                }
                ++i;
            }
        }
    }

    protected int shift(double[][] signals, int[] shifts, int levels, int start, int[] lengths, int[] steps, int mode) {
        double[][] shifted = new double[shifts.length][];
        int i = 0;
        while (i < shifts.length) {
            shifted[i] = signals[shifts[i]];
            ++i;
        }
        int dimension = -1;
        int level = 0;
        while (level < levels) {
            dimension = level % lengths.length;
            if (level >= start) {
                int[] offsets = new int[signals.length];
                int offset = this.shiftOffset(dimension, lengths, steps);
                int shift = 0;
                while (shift < shifts.length) {
                    signals[shifts[shift]] = shifted[shift];
                    offsets[shifts[shift]] = offset;
                    ++shift;
                }
                this.tile(signals, mode, lengths.length - 1, dimension, offsets, lengths, steps);
            }
            int n = dimension;
            lengths[n] = lengths[n] / 2;
            ++level;
        }
        int i2 = 0;
        while (i2 < shifts.length) {
            signals[shifts[i2]] = shifted[i2];
            ++i2;
        }
        return dimension;
    }

    protected int shiftOffset(int dimension, int[] lengths, int[] steps) {
        int prev = this.index(dimension - 1, lengths.length);
        return lengths[prev] * steps[prev];
    }

    protected void init(double[] signal, double value, int dimension, int offset, int[] lengths, int[] steps) {
        if (dimension < 1) {
            this.init(signal, value, offset, lengths[0], steps[0]);
        } else {
            int i = 0;
            while (i < lengths[dimension]) {
                this.init(signal, value, dimension - 1, offset, lengths, steps);
                offset += steps[dimension];
                ++i;
            }
        }
    }

    protected void init(double[] signal, double value, int offset, int length, int step) {
        int i = 0;
        int k = offset;
        while (i < length) {
            signal[k] = value;
            ++i;
            k += step;
        }
    }

    protected void copy(double[] input, double[] output, int dimension, int inputOffset, int outputOffset, int[] lengths, int[] steps) {
        if (dimension < 1) {
            this.copy(input, output, inputOffset, outputOffset, lengths[0], steps[0]);
        } else {
            int i = 0;
            while (i < lengths[dimension]) {
                this.copy(input, output, dimension - 1, inputOffset, outputOffset, lengths, steps);
                inputOffset += steps[dimension];
                outputOffset += steps[dimension];
                ++i;
            }
        }
    }

    protected void copy(double[] input, double[] output, int inputOffset, int outputOffset, int length, int step) {
        int i = 0;
        int j = outputOffset;
        int k = inputOffset;
        while (i < length) {
            output[j] = input[k];
            ++i;
            j += step;
            k += step;
        }
    }

    protected int power2(int p) {
        return 1 << p;
    }

    protected int index(int j, int m) {
        int i = j % m;
        return i < 0 ? i + m : i;
    }

    protected boolean even(int x) {
        return (x & 1) == 0;
    }

    protected boolean odd(int x) {
        return (x & 1) != 0;
    }

    protected double median(double a, double b, double c) {
        if (a > b) {
            if (b > c) {
                return b;
            }
            if (c > a) {
                return a;
            }
            return c;
        }
        if (c > b) {
            return b;
        }
        if (a > c) {
            return a;
        }
        return c;
    }

    protected int filterOffset() {
        return this.coefficients[1].length / 2;
    }

    protected int signalOffset(int len, int fi) {
        return fi != 0 ? len / 2 : 0;
    }

    protected void toggle(double[] array, int a, int b) {
        double value = array[a];
        array[a] = array[b];
        array[b] = value;
    }

    protected void toggle(int[] array, int a, int b) {
        int value = array[a];
        array[a] = array[b];
        array[b] = value;
    }

    protected void toggle(double[][] signals, int a, int b) {
        double[] signal = signals[a];
        signals[a] = signals[b];
        signals[b] = signal;
    }
}

