/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.util;

import e3d.utils.ArrayFactory;
import e3d.utils.ObjectFactory;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.Matrix2D;

public class Matrix3D<V>
extends Matrix2D<V> {
    protected double depth;
    protected double front;
    protected double back;

    public Matrix3D(ArrayFactory<V> arrayFactory, ObjectFactory<V> valueFactory) {
        super(arrayFactory, valueFactory);
    }

    public Matrix3D(Matrix3D<V> matrix) {
        super(matrix);
        this.front = matrix.front;
        this.back = matrix.back;
        this.depth = matrix.depth;
    }

    public Matrix3D(int width, int height, double depth, ArrayFactory<V> arrayFactory, ObjectFactory<V> valueFactory) {
        super(width, height, arrayFactory, valueFactory);
        this.depth = depth;
    }

    @Override
    public Matrix3D<V> clone() {
        return new Matrix3D<V>(this);
    }

    @Override
    public void clear() {
        super.clear();
        this.depth = 0.0;
    }

    public void setSize(int width, int height, double depth) {
        super.setSize(width, height);
        this.depth = depth;
    }

    public void setBounds(double left, double top, double front, double right, double bottom, double back) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.front = front;
        this.back = back;
    }

    public void setBounds(E3DBoundingBox boundingBox) {
        this.left = boundingBox.x0;
        this.right = boundingBox.x1;
        this.top = boundingBox.y0;
        this.bottom = boundingBox.y1;
        this.front = boundingBox.z0;
        this.back = boundingBox.z1;
    }

    public double front() {
        return this.front;
    }

    public double back() {
        return this.back;
    }

    public double zZoom() {
        return this.depth / (this.back - this.front);
    }

    public double zZoom(double z) {
        return z / this.zZoom() + this.front();
    }

    public void setDepth(double dep) {
        this.depth = dep;
    }

    public double depth() {
        return this.depth;
    }

    protected double z(double z) {
        return (z - this.front) / (this.back - this.front) * this.depth;
    }
}

