/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.space;

import e3d.visualization.util.E3DBoundingBox;

public final class Coords {
    private final XYZ borders;
    private final XYZ centers;

    protected Coords(E3DBoundingBox bounds, int size) {
        this(bounds.x0, bounds.y0, bounds.z0, bounds.x1, bounds.y1, bounds.z1, size);
    }

    protected Coords(double x1, double y1, double z1, double x2, double y2, double z2, int size) {
        this.borders = new XYZ(size + 2);
        this.centers = new XYZ(size + 1);
        ((XYZ)this.borders).x[0] = x1;
        ((XYZ)this.borders).y[0] = y1;
        ((XYZ)this.borders).z[0] = z1;
        ((XYZ)this.borders).x[size] = x2;
        ((XYZ)this.borders).y[size] = y2;
        ((XYZ)this.borders).z[size] = z2;
        ((XYZ)this.borders).x[size + 1] = Double.POSITIVE_INFINITY;
        ((XYZ)this.borders).y[size + 1] = Double.POSITIVE_INFINITY;
        ((XYZ)this.borders).z[size + 1] = Double.POSITIVE_INFINITY;
        ((XYZ)this.centers).x[size] = Double.POSITIVE_INFINITY;
        ((XYZ)this.centers).y[size] = Double.POSITIVE_INFINITY;
        ((XYZ)this.centers).z[size] = Double.POSITIVE_INFINITY;
        this.divide(0, size);
    }

    private Coords(XYZ borders, XYZ centers) {
        this.borders = borders;
        this.centers = centers;
    }

    final Coords getXZToggled() {
        XYZ borders2 = new XYZ(this.borders.z, this.borders.y, this.borders.x);
        XYZ centers2 = new XYZ(this.centers.z, this.centers.y, this.centers.x);
        return new Coords(borders2, centers2);
    }

    final Coords getYZToggled() {
        XYZ borders2 = new XYZ(this.borders.x, this.borders.z, this.borders.y);
        XYZ centers2 = new XYZ(this.centers.x, this.centers.z, this.centers.y);
        return new Coords(borders2, centers2);
    }

    final Coords getXYToggled() {
        XYZ borders2 = new XYZ(this.borders.y, this.borders.x, this.borders.z);
        XYZ centers2 = new XYZ(this.centers.y, this.centers.x, this.centers.z);
        return new Coords(borders2, centers2);
    }

    public double x1() {
        return this.borders.x[0];
    }

    public double y1() {
        return this.borders.y[0];
    }

    public double z1() {
        return this.borders.z[0];
    }

    public double x2() {
        return this.borders.x[this.borders.x.length - 2];
    }

    public double y2() {
        return this.borders.y[this.borders.y.length - 2];
    }

    public double z2() {
        return this.borders.z[this.borders.z.length - 2];
    }

    public double x1(int i) {
        return this.borders.x[i];
    }

    public double y1(int j) {
        return this.borders.y[j];
    }

    public double z1(int k) {
        return this.borders.z[k];
    }

    public double x2(int i) {
        return this.borders.x[i + 1];
    }

    public double y2(int j) {
        return this.borders.y[j + 1];
    }

    public double z2(int k) {
        return this.borders.z[k + 1];
    }

    public double x(int i) {
        return this.centers.x[i];
    }

    public double y(int j) {
        return this.centers.y[j];
    }

    public double z(int k) {
        return this.centers.z[k];
    }

    private void divide(int a, int n) {
        int m = n >> 1;
        int b = a + m;
        int c = a + n;
        ((XYZ)this.borders).x[b] = (this.borders.x[a] + this.borders.x[c]) / 2.0;
        ((XYZ)this.borders).y[b] = (this.borders.y[a] + this.borders.y[c]) / 2.0;
        ((XYZ)this.borders).z[b] = (this.borders.z[a] + this.borders.z[c]) / 2.0;
        if (m > 1) {
            this.divide(a, m);
            this.divide(b, m);
        } else {
            ((XYZ)this.centers).x[a] = (this.borders.x[a] + this.borders.x[b]) / 2.0;
            ((XYZ)this.centers).y[a] = (this.borders.y[a] + this.borders.y[b]) / 2.0;
            ((XYZ)this.centers).z[a] = (this.borders.z[a] + this.borders.z[b]) / 2.0;
            ((XYZ)this.centers).x[b] = (this.borders.x[b] + this.borders.x[c]) / 2.0;
            ((XYZ)this.centers).y[b] = (this.borders.y[b] + this.borders.y[c]) / 2.0;
            ((XYZ)this.centers).z[b] = (this.borders.z[b] + this.borders.z[c]) / 2.0;
        }
    }

    private static final class XYZ {
        private final double[] x;
        private final double[] y;
        private final double[] z;

        private XYZ(int size) {
            this.x = new double[size];
            this.y = new double[size];
            this.z = new double[size];
        }

        private XYZ(double[] x, double[] y, double[] z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

