/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.space;

import e3d.visualization.space.AtomicSubSpace;
import e3d.visualization.space.ComplexSubSpace;
import e3d.visualization.space.Coords;
import e3d.visualization.space.Point;
import e3d.visualization.space.Voxel;
import java.util.Collection;

public class BinarySpaceTasks {

    public static abstract class AllTask<Atom extends AtomicSubSpace<Atom>> {
        public abstract void on(Atom var1, int var2, int var3, int var4, int var5);

        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }
    }

    protected static final class IJKArea1stAtomGetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        protected Atom atom = null;
        private boolean remove;

        protected IJKArea1stAtomGetter(boolean remove) {
            this.remove = remove;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.atom = sub;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.atom == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
                if (this.atom != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.atom == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
                if (this.atom != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        protected void reinit(boolean remove) {
            this.remove = remove;
            this.atom = null;
        }

        protected Atom get1stAtom() {
            return this.atom;
        }
    }

    protected static final class IJKArea1stVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        private Voxel<Atom> voxel = null;
        private boolean remove;

        protected IJKArea1stVoxelGetter(boolean remove) {
            this.remove = remove;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.voxel = new Voxel<Atom>(i0, j0, k0, sub);
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.voxel == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
                if (this.voxel != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.voxel == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
                if (this.voxel != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        protected void reinit(boolean remove) {
            this.remove = remove;
            this.voxel = null;
        }

        protected Voxel<Atom> get1stVoxel() {
            return this.voxel;
        }
    }

    protected static final class IJKAreaAtomGetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        private Atom[][][] atoms;
        private int i0;
        private int j0;
        private int k0;

        protected IJKAreaAtomGetter(Atom[][][] atoms, int i0, int j0, int k0) {
            this.reinit((AtomicSubSpace[][][])atoms, i0, j0, k0);
        }

        protected void reinit(Atom[][][] atoms, int i0, int j0, int k0) {
            this.atoms = atoms;
            this.i0 = i0;
            this.j0 = j0;
            this.k0 = k0;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.atoms[i0 - this.i0][j0 - this.j0][k0 - this.k0] = sub;
        }

        protected Atom[][][] getAtoms() {
            return this.atoms;
        }
    }

    protected static final class IJKAreaAtomSetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        private Atom atom;

        public IJKAreaAtomSetter(Atom atom) {
            this.atom = atom;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
            }
        }

        protected void reinit(Atom atom) {
            this.atom = atom;
        }
    }

    protected static final class IJKAreaEmptyChecker<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        private boolean empty = true;

        protected IJKAreaEmptyChecker() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.empty = false;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n) {
            if (sub.sub[0][0][0] != null || sub.sub[0][0][1] != null || sub.sub[0][1][0] != null || sub.sub[0][1][1] != null || sub.sub[1][0][0] != null || sub.sub[1][0][1] != null || sub.sub[1][1][0] != null || sub.sub[1][1][1] != null) {
                this.empty = false;
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.empty && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.empty && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
            }
        }

        protected void reinit() {
            this.empty = true;
        }

        protected boolean isEmpty() {
            return this.empty;
        }
    }

    protected static final class IJKAreaRemover<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        protected IJKAreaRemover() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot remove anything from an AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n) {
            sub.sub[0][0][0] = null;
            sub.sub[0][0][1] = null;
            sub.sub[0][1][0] = null;
            sub.sub[0][1][1] = null;
            sub.sub[1][0][0] = null;
            sub.sub[1][0][1] = null;
            sub.sub[1][1][0] = null;
            sub.sub[1][1][1] = null;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            sub.sub[a][b][c] = null;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
                if (sub.sub[a][b][c].isEmpty()) {
                    sub.sub[a][b][c] = null;
                }
            }
        }
    }

    public static abstract class IJKAreaTask<Atom extends AtomicSubSpace<Atom>>
    extends AllTask<Atom> {
        @Override
        public abstract void on(Atom var1, int var2, int var3, int var4, int var5);

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n) {
            sub.perform(i0, j0, k0, n, this);
        }

        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
            }
        }
    }

    protected static final class IJKAreaVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        private Collection<Voxel<Atom>> voxels;

        protected IJKAreaVoxelGetter(Collection<Voxel<Atom>> voxels) {
            this.voxels = voxels;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.voxels.add(new Voxel<Atom>(i0, j0, k0, sub));
        }

        protected void reinit(Collection<Voxel<Atom>> voxels) {
            this.voxels = voxels;
        }

        protected Collection<Voxel<Atom>> getVoxels() {
            return this.voxels;
        }
    }

    protected static final class IJKAreaVoxelSetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKAreaTask<Atom> {
        private Atom atom;
        private Collection<Voxel<Atom>> voxels = null;

        public IJKAreaVoxelSetter(Atom atom, Collection<Voxel<Atom>> voxels) {
            this.atom = atom;
            this.voxels = voxels;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
                this.voxels.add(new Voxel<Atom>(i0, j0, k0, this.atom));
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i1, int j1, int k1, int i2, int j2, int k2, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
                this.voxels.add(new Voxel<Atom>(i0, j0, k0, this.atom));
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i1, j1, k1, i2, j2, k2, i0, j0, k0, n, this);
            }
        }

        protected void reinit(Atom atom, Collection<Voxel<Atom>> voxels) {
            this.atom = atom;
            this.voxels = voxels;
        }

        protected Collection<Voxel<Atom>> getVoxel() {
            return this.voxels;
        }
    }

    protected static final class IJKAtomGetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKTask<Atom> {
        protected Atom atom = null;

        protected IJKAtomGetter() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.atom = sub;
        }

        protected void reinit() {
            this.atom = null;
        }

        protected Atom getAtom() {
            return this.atom;
        }
    }

    protected static final class IJKAtomSetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKTask<Atom> {
        private Atom atom;

        protected IJKAtomSetter(Atom atom) {
            this.atom = atom;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i, int j, int k, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i, j, k, i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i, j, k, i0, j0, k0, n, this);
            }
        }

        protected void reinit(Atom atom) {
            this.atom = atom;
        }
    }

    protected static class IJKEmptyChecker<Atom extends AtomicSubSpace<Atom>>
    extends IJKTask<Atom> {
        private boolean empty = true;

        protected IJKEmptyChecker() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.empty = false;
        }

        protected void reinit() {
            this.empty = true;
        }

        protected boolean isEmpty() {
            return this.empty;
        }
    }

    protected static class IJKRemover<Atom extends AtomicSubSpace<Atom>>
    extends IJKTask<Atom> {
        protected IJKRemover() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Could not remove anything from an AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i, int j, int k, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (sub.sub[a][b][c] != null && (n <= 1 || sub.sub[a][b][c].isEmpty())) {
                sub.sub[a][b][c] = null;
            }
        }
    }

    public static abstract class IJKTask<Atom extends AtomicSubSpace<Atom>> {
        public abstract void on(Atom var1, int var2, int var3, int var4, int var5);

        public void on(ComplexSubSpace<Atom> sub, int i, int j, int k, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i, j, k, i0, j0, k0, n, this);
            }
        }
    }

    protected static final class IJKVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKTask<Atom> {
        private Voxel<Atom> voxel = null;

        protected IJKVoxelGetter() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.voxel = new Voxel<Atom>(i0, j0, k0, sub);
        }

        protected void reinit() {
            this.voxel = null;
        }

        protected Voxel<Atom> getVoxel() {
            return this.voxel;
        }
    }

    protected static final class IJKVoxelSetter<Atom extends AtomicSubSpace<Atom>>
    extends IJKTask<Atom> {
        private Atom atom;
        private Voxel<Atom> voxel = null;

        protected IJKVoxelSetter(Atom atom) {
            this.atom = atom;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i, int j, int k, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
                this.voxel = new Voxel<Atom>(i0, j0, k0, this.atom);
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i, j, k, i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i, j, k, i0, j0, k0, n, this);
            }
        }

        protected void reinit(Atom atom) {
            this.atom = atom;
            this.voxel = null;
        }

        protected Voxel<Atom> getVoxel() {
            return this.voxel;
        }
    }

    protected static final class XYZArea1stAtomGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        protected Atom atom = null;
        private boolean remove;

        protected XYZArea1stAtomGetter(boolean remove) {
            this.remove = remove;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.atom = sub;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.atom == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
                if (this.atom != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (this.atom == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
                if (this.atom != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        protected void reinit(boolean remove) {
            this.remove = remove;
            this.atom = null;
        }

        protected Atom get1stAtom() {
            return this.atom;
        }
    }

    protected static final class XYZArea1stVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        private Voxel<Atom> voxel = null;
        private boolean remove;

        protected XYZArea1stVoxelGetter(boolean remove) {
            this.remove = remove;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.voxel = new Voxel<Atom>(i0, j0, k0, sub);
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.voxel == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
                if (this.voxel != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (this.voxel == null && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
                if (this.voxel != null && this.remove && sub.sub[a][b][c] != null && (n == 1 || sub.sub[a][b][c].isEmpty())) {
                    sub.sub[a][b][c] = null;
                }
            }
        }

        protected void reinit(boolean remove) {
            this.remove = remove;
            this.voxel = null;
        }

        protected Voxel<Atom> get1stVoxel() {
            return this.voxel;
        }
    }

    protected static final class XYZAreaAtomSetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        private Atom atom;

        public XYZAreaAtomSetter(Atom atom) {
            this.atom = atom;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
            } else {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
            }
        }

        protected void reinit(Atom atom) {
            this.atom = atom;
        }
    }

    protected static final class XYZAreaEmptyChecker<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        private boolean empty = true;

        protected XYZAreaEmptyChecker() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.empty = false;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n) {
            if (sub.sub[0][0][0] != null || sub.sub[0][0][1] != null || sub.sub[0][1][0] != null || sub.sub[0][1][1] != null || sub.sub[1][0][0] != null || sub.sub[1][0][1] != null || sub.sub[1][1][0] != null || sub.sub[1][1][1] != null) {
                this.empty = false;
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (this.empty && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (this.empty && sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
            }
        }

        protected void reinit() {
            this.empty = true;
        }

        protected boolean isEmpty() {
            return this.empty;
        }
    }

    protected static final class XYZAreaRemover<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        protected XYZAreaRemover() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot remove anything from an AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n) {
            sub.sub[0][0][0] = null;
            sub.sub[0][0][1] = null;
            sub.sub[0][1][0] = null;
            sub.sub[0][1][1] = null;
            sub.sub[1][0][0] = null;
            sub.sub[1][0][1] = null;
            sub.sub[1][1][0] = null;
            sub.sub[1][1][1] = null;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            sub.sub[a][b][c] = null;
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
                if (sub.sub[a][b][c].isEmpty()) {
                    sub.sub[a][b][c] = null;
                }
            }
        }
    }

    public static abstract class XYZAreaTask<Atom extends AtomicSubSpace<Atom>>
    extends AllTask<Atom> {
        @Override
        public abstract void on(Atom var1, int var2, int var3, int var4, int var5);

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n) {
            sub.perform(i0, j0, k0, n, this);
        }

        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
            }
        }
    }

    protected static final class XYZAreaVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        private Collection<Voxel<Atom>> voxels;

        public XYZAreaVoxelGetter(Collection<Voxel<Atom>> voxels) {
            this.voxels = voxels;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.voxels.add(new Voxel<Atom>(i0, j0, k0, sub));
        }

        protected void reinit(Collection<Voxel<Atom>> voxels) {
            this.voxels = voxels;
        }

        protected Collection<Voxel<Atom>> getVoxels() {
            return this.voxels;
        }
    }

    protected static final class XYZAreaVoxelSetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZAreaTask<Atom> {
        private Atom atom;
        private Collection<Voxel<Atom>> voxels;

        public XYZAreaVoxelSetter(Atom atom, Collection<Voxel<Atom>> voxels) {
            this.atom = atom;
            this.voxels = voxels;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, int i0, int j0, int k0, int n, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
                this.voxels.add(new Voxel<Atom>(i0, j0, k0, this.atom));
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            } else {
                sub.sub[a][b][c].perform(i0, j0, k0, n, this);
            }
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, double dx, double dy, double dz, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
                this.voxels.add(new Voxel<Atom>(i0, j0, k0, this.atom));
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
            } else {
                sub.sub[a][b][c].perform(x, y, z, dx, dy, dz, i0, j0, k0, n, coords, this);
            }
        }

        protected void reinit(Atom atom, Collection<Voxel<Atom>> voxels) {
            this.atom = atom;
            this.voxels = voxels;
        }

        protected Collection<Voxel<Atom>> getVoxels() {
            return this.voxels;
        }
    }

    protected static final class XYZAtomGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZTask<Atom> {
        protected Atom atom = null;

        protected XYZAtomGetter() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.atom = sub;
        }

        protected void reinit() {
            this.atom = null;
        }

        protected Atom getAtom() {
            return this.atom;
        }
    }

    protected static final class XYZAtomSetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZTask<Atom> {
        private Atom atom;

        protected XYZAtomSetter(Atom atom) {
            this.atom = atom;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(x, y, z, i0, j0, k0, n, coords, this);
            } else {
                sub.sub[a][b][c].perform(x, y, z, i0, j0, k0, n, coords, this);
            }
        }

        protected void reinit(Atom atom) {
            this.atom = atom;
        }
    }

    protected static class XYZEmptyChecker<Atom extends AtomicSubSpace<Atom>>
    extends XYZTask<Atom> {
        private boolean empty = true;

        protected XYZEmptyChecker() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.empty = false;
        }

        protected void reinit() {
            this.empty = true;
        }

        protected boolean isEmpty() {
            return this.empty;
        }
    }

    protected static class XYZRayNextAtomGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZRayTask<Atom> {
        private Atom atom = null;

        protected XYZRayNextAtomGetter() {
        }

        @Override
        public void on(Atom sub, double t, double x, double y, double z, int i0, int j0, int k0, int n) {
            this.atom = sub;
        }

        protected void reinit() {
            this.atom = null;
        }

        @Override
        public boolean isDone() {
            return this.atom != null;
        }

        protected Atom getAtom() {
            return this.atom;
        }
    }

    protected static class XYZRayNextPointGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZRayTask<Atom> {
        private Point<Atom> point = null;

        protected XYZRayNextPointGetter() {
        }

        @Override
        public boolean isDone() {
            return this.point != null;
        }

        @Override
        public void on(Atom sub, double t, double x, double y, double z, int i0, int j0, int k0, int n) {
            this.point = new Point<Atom>(x, y, z, sub);
        }

        protected void reinit() {
            this.point = null;
        }

        protected Point<Atom> getVoxel() {
            return this.point;
        }
    }

    protected static class XYZRayNextVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZRayTask<Atom> {
        private Voxel<Atom> voxel = null;

        protected XYZRayNextVoxelGetter() {
        }

        @Override
        public boolean isDone() {
            return this.voxel != null;
        }

        @Override
        public void on(Atom sub, double t, double x, double y, double z, int i0, int j0, int k0, int n) {
            this.voxel = new Voxel<Atom>(i0, j0, k0, sub);
        }

        protected void reinit() {
            this.voxel = null;
        }

        protected Voxel<Atom> getVoxel() {
            return this.voxel;
        }
    }

    public static abstract class XYZRayTask<Atom extends AtomicSubSpace<Atom>> {
        public abstract void on(Atom var1, double var2, double var4, double var6, double var8, int var10, int var11, int var12, int var13);

        public abstract boolean isDone();
    }

    protected static class XYZRemover<Atom extends AtomicSubSpace<Atom>>
    extends XYZTask<Atom> {
        protected XYZRemover() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Could not remove anything from an AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (sub.sub[a][b][c] != null && (n <= 1 || sub.sub[a][b][c].isEmpty())) {
                sub.sub[a][b][c] = null;
            }
        }
    }

    public static abstract class XYZTask<Atom extends AtomicSubSpace<Atom>> {
        public abstract void on(Atom var1, int var2, int var3, int var4, int var5);

        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (sub.sub[a][b][c] != null) {
                sub.sub[a][b][c].perform(x, y, z, i0, j0, k0, n, coords, this);
            }
        }
    }

    protected static final class XYZVoxelGetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZTask<Atom> {
        private Voxel<Atom> voxel = null;

        protected XYZVoxelGetter() {
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            this.voxel = new Voxel<Atom>(i0, j0, k0, sub);
        }

        protected void reinit() {
            this.voxel = null;
        }

        protected Voxel<Atom> getVoxel() {
            return this.voxel;
        }
    }

    protected static final class XYZVoxelSetter<Atom extends AtomicSubSpace<Atom>>
    extends XYZTask<Atom> {
        private Atom atom;
        private Voxel<Atom> voxel = null;

        protected XYZVoxelSetter(Atom atom) {
            this.atom = atom;
        }

        @Override
        public void on(Atom sub, int i0, int j0, int k0, int n) {
            throw new UnsupportedOperationException("Cannot set an AtomicSpace into another AtomicSpace!");
        }

        @Override
        public void on(ComplexSubSpace<Atom> sub, double x, double y, double z, int i0, int j0, int k0, int n, Coords coords, int a, int b, int c) {
            if (n <= 1) {
                sub.sub[a][b][c] = this.atom;
                this.voxel = new Voxel<Atom>(i0, j0, k0, this.atom);
            } else if (sub.sub[a][b][c] == null) {
                sub.sub[a][b][c] = new ComplexSubSpace();
                sub.sub[a][b][c].perform(x, y, z, i0, j0, k0, n, coords, this);
            } else {
                sub.sub[a][b][c].perform(x, y, z, i0, j0, k0, n, coords, this);
            }
        }

        protected void reinit(Atom atom) {
            this.atom = atom;
            this.voxel = null;
        }

        protected Voxel<Atom> getVoxel() {
            return this.voxel;
        }
    }
}

