/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.scanner;

import e3d.utils.Clock;

public class Statistics {
    public long calculatedPoints;
    public long solidPoints;
    public long surfacePoints;
    public Clock scanningClock = new Clock();
    public Clock renderingClock = new Clock();
    public Clock filteringClock = new Clock();

    public void clear() {
        this.calculatedPoints = 0L;
        this.solidPoints = 0L;
        this.surfacePoints = 0L;
        this.scanningClock.init();
        this.renderingClock.init();
        this.filteringClock.init();
    }

    public long getNumberOfCalculatedPoints() {
        return this.calculatedPoints;
    }

    public long getNumberOfSolidPoints() {
        return this.solidPoints;
    }

    public long getNumberOfSurfacePoints() {
        return this.surfacePoints;
    }

    public long getMilliSeconds() {
        return Clock.ns2ms(this.scanningClock.elapsed());
    }

    public String getPreciseScanningTime() {
        return this.getPreciseTime(Clock.ns2ms(this.scanningClock.elapsed()));
    }

    public String getScanningTime() {
        return this.getTime(Clock.ns2ms(this.scanningClock.elapsed()));
    }

    public String getPreciseRenderingTime() {
        return this.getPreciseTime(Clock.ns2ms(this.renderingClock.elapsed()));
    }

    public String getRenderingTime() {
        return this.getTime(Clock.ns2ms(this.renderingClock.elapsed()));
    }

    public String getPreciseFilteringTime() {
        return this.getPreciseTime(Clock.ns2ms(this.filteringClock.elapsed()));
    }

    public String getFilteringTime() {
        return this.getTime(Clock.ns2ms(this.filteringClock.elapsed()));
    }

    public String getTime(long ms) {
        long h = ms / 3600000L;
        long m = (ms -= h * 3600000L) / 60000L;
        long s = (ms -= m * 60000L) / 1000L;
        ms -= s * 1000L;
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    public String getPreciseTime(long ms) {
        long h = ms / 3600000L;
        long m = (ms -= h * 3600000L) / 60000L;
        long s = (ms -= m * 60000L) / 1000L;
        return String.format("%02d:%02d:%02d'%03d", h, m, s, ms -= s * 1000L);
    }
}

