/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.scanner;

import e3d.utils.MathUtils;
import e3d.utils.ProgressListener;
import e3d.visualization.object.E3DObject;
import e3d.visualization.object.E3DSubject;
import e3d.visualization.scanner.E3DObjectScan;
import e3d.visualization.scanner.Statistics;
import e3d.visualization.space.Point;
import e3d.visualization.space.Space;
import e3d.visualization.space.Voxel;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import java.util.concurrent.CopyOnWriteArrayList;

public class E3DVirtualSubjectScan
extends Space<E3DAtom>
implements E3DObjectScan {
    protected E3DSubject subject;
    protected final double compensation;
    protected final double minDist;
    protected Statistics statistics = new Statistics();
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();
    protected final XYZRayNextAtomGetter xyzRayNextAtomGetter = new XYZRayNextAtomGetter();
    protected final XYZRayNextPointGetter xyzRayNextPointGetter = new XYZRayNextPointGetter();
    protected final XYZRayNextVoxelGetter xyzRayNextVoxelGetter = new XYZRayNextVoxelGetter();

    public E3DVirtualSubjectScan(E3DBoundingBox bounds, int width, int height, int depth, double compensation) {
        super(bounds, width, height, depth);
        this.compensation = compensation;
        this.minDist = this.getElementSize().min() / 10.0;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    @Override
    public E3DSubject getObject() {
        return this.subject;
    }

    @Override
    public void setObject(E3DObject object) throws InterruptedException {
        if (!(object instanceof E3DSubject)) {
            throw new RuntimeException("This class only works on E3DSubjects.");
        }
        this.subject = (E3DSubject)object;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public boolean isEmpty(int i, int j, int k) {
        if (this.isOutOfBounds(i, j, k)) {
            return true;
        }
        this.subject.setPoint(this.coords.x(i), this.coords.y(j), this.coords.z(k));
        return this.subject.getColor() == null;
    }

    @Override
    public boolean isEmpty(double x, double y, double z) {
        if (this.isOutOfBounds(x, y, z)) {
            return true;
        }
        this.subject.setPoint(x, y, z);
        return this.subject.getColor() == null;
    }

    @Override
    public Voxel<E3DAtom> getVoxel(double x, double y, double z) {
        if (this.isOutOfBounds(x, y, z)) {
            return null;
        }
        this.subject.setPoint(x, y, z);
        Integer color = this.subject.getColor();
        if (color == null) {
            return null;
        }
        return new Voxel<E3DAtom>((int)(x - this.coords.x1() / (this.coords.x1(1) - this.coords.x1(0))), (int)(y - this.coords.y1() / (this.coords.y1(1) - this.coords.y1(0))), (int)(z - this.coords.z1() / (this.coords.z1(1) - this.coords.z1(0))), new E3DAtom(color, this.subject.getNormal().clone()));
    }

    @Override
    public Voxel<E3DAtom> getVoxel(int i, int j, int k) {
        if (this.isOutOfBounds(i, j, k)) {
            return null;
        }
        this.subject.setPoint(this.coords.x(i), this.coords.y(j), this.coords.z(k));
        Integer color = this.subject.getColor();
        if (color == null) {
            return null;
        }
        return new Voxel<E3DAtom>(i, j, k, new E3DAtom(color, this.subject.getNormal().clone()));
    }

    @Override
    public E3DAtom getAtom(double x, double y, double z) {
        if (this.isOutOfBounds(x, y, z)) {
            return null;
        }
        this.subject.setPoint(x, y, z);
        Integer color = this.subject.getColor();
        if (color == null) {
            return null;
        }
        return new E3DAtom(color, this.subject.getNormal().clone());
    }

    @Override
    public E3DAtom getAtom(int i, int j, int k) {
        if (this.isOutOfBounds(i, j, k)) {
            return null;
        }
        this.subject.setPoint(this.coords.x(i), this.coords.y(j), this.coords.z(k));
        Integer color = this.subject.getColor();
        if (color == null) {
            return null;
        }
        return new E3DAtom(color, this.subject.getNormal().clone());
    }

    @Override
    public E3DAtom getNextAtomInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextAtomGetter.reinit();
        this.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextAtomGetter);
        return this.xyzRayNextAtomGetter.getAtom();
    }

    @Override
    public Point<E3DAtom> getNextPointInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextPointGetter.reinit();
        this.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextPointGetter);
        return this.xyzRayNextPointGetter.getPoint();
    }

    @Override
    public Voxel<E3DAtom> getNextVoxelInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextVoxelGetter.reinit();
        this.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextVoxelGetter);
        return this.xyzRayNextVoxelGetter.getVoxel();
    }

    public void perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, XYZRayTask task) {
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        double t = this.tMin(x, y, z, dx, dy, dz);
        if (Double.isInfinite(t) || t > tmax) {
            return;
        }
        t = Math.max(t, tmin);
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.subject.setPoint(x += dx * t, y += dy * t, z += dz * t);
        Integer color = this.subject.getColor();
        ++this.statistics.calculatedPoints;
        if (color != null) {
            ++this.statistics.solidPoints;
            ++this.statistics.surfacePoints;
        }
        while (color == null) {
            double d = Math.max(this.minDist, this.subject.getDistance());
            double dt = d / length / this.compensation;
            if ((t += dt) > tmax || this.isOutOfBounds(x += dt * dx, y += dt * dy, z += dt * dz) || Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
                return;
            }
            this.subject.setPoint(x, y, z);
            color = this.subject.getColor();
            ++this.statistics.calculatedPoints;
            if (color == null) continue;
            ++this.statistics.solidPoints;
            ++this.statistics.surfacePoints;
        }
        task.on(x, y, z, this.subject);
    }

    protected double tMin(double x, double y, double z, double dx, double dy, double dz) {
        double t;
        if (this.isOutOfBounds(x, y, z)) {
            double fy;
            double fx;
            double d = dx < 0.0 && x >= this.coords.x2() ? (this.coords.x2() - x) / dx : (fx = dx > 0.0 && x <= this.coords.x1() ? (this.coords.x1() - x) / dx : Double.NEGATIVE_INFINITY);
            double d2 = dy < 0.0 && y >= this.coords.y2() ? (this.coords.y2() - y) / dy : (fy = dy > 0.0 && y <= this.coords.y1() ? (this.coords.y1() - y) / dy : Double.NEGATIVE_INFINITY);
            double fz = dz < 0.0 && z >= this.coords.z2() ? (this.coords.z2() - z) / dz : (dz > 0.0 && z <= this.coords.z1() ? (this.coords.z1() - z) / dz : Double.NEGATIVE_INFINITY);
            t = MathUtils.max(fx, fy, fz);
        } else {
            t = 0.0;
        }
        return t;
    }

    protected static final class XYZRayNextAtomGetter
    extends XYZRayTask {
        private E3DAtom atom = null;

        protected XYZRayNextAtomGetter() {
        }

        @Override
        protected void on(double x, double y, double z, E3DSubject object) {
            this.atom = new E3DAtom(object.getColor(), object.getNormal().clone());
        }

        @Override
        protected void on(Point<E3DAtom> point) {
            this.atom = point.getAtom();
        }

        protected void reinit() {
            this.atom = null;
        }

        protected E3DAtom getAtom() {
            return this.atom;
        }
    }

    protected static final class XYZRayNextPointGetter
    extends XYZRayTask {
        private Point<E3DAtom> point = null;

        protected XYZRayNextPointGetter() {
        }

        @Override
        protected void on(double x, double y, double z, E3DSubject object) {
            this.point = new Point<E3DAtom>(x, y, z, new E3DAtom(object.getColor(), object.getNormal().clone()));
        }

        @Override
        protected void on(Point<E3DAtom> point) {
            this.point = point;
        }

        protected void reinit() {
            this.point = null;
        }

        protected Point<E3DAtom> getPoint() {
            return this.point;
        }
    }

    protected final class XYZRayNextVoxelGetter
    extends XYZRayTask {
        private Voxel<E3DAtom> voxel = null;

        protected XYZRayNextVoxelGetter() {
        }

        @Override
        protected void on(double x, double y, double z, E3DSubject object) {
            this.voxel = new Voxel<E3DAtom>((int)((x - E3DVirtualSubjectScan.this.coords.x1()) / (E3DVirtualSubjectScan.this.coords.x1(1) - E3DVirtualSubjectScan.this.coords.x1(0))), (int)((y - E3DVirtualSubjectScan.this.coords.y1()) / (E3DVirtualSubjectScan.this.coords.y1(1) - E3DVirtualSubjectScan.this.coords.y1(0))), (int)((z - E3DVirtualSubjectScan.this.coords.z1()) / (E3DVirtualSubjectScan.this.coords.z1(1) - E3DVirtualSubjectScan.this.coords.z1(0))), new E3DAtom(object.getColor(), object.getNormal().clone()));
        }

        @Override
        protected void on(Point<E3DAtom> point) {
            this.voxel = new Voxel<E3DAtom>((int)((point.x - E3DVirtualSubjectScan.this.coords.x1()) / (E3DVirtualSubjectScan.this.coords.x1(1) - E3DVirtualSubjectScan.this.coords.x1(0))), (int)((point.y - E3DVirtualSubjectScan.this.coords.y1()) / (E3DVirtualSubjectScan.this.coords.y1(1) - E3DVirtualSubjectScan.this.coords.y1(0))), (int)((point.z - E3DVirtualSubjectScan.this.coords.z1()) / (E3DVirtualSubjectScan.this.coords.z1(1) - E3DVirtualSubjectScan.this.coords.z1(0))), new E3DAtom(point.getAtom().getColor(), point.getAtom().getNormal()));
        }

        protected void reinit() {
            this.voxel = null;
        }

        protected Voxel<E3DAtom> getVoxel() {
            return this.voxel;
        }
    }

    protected static abstract class XYZRayTask {
        protected XYZRayTask() {
        }

        protected abstract void on(double var1, double var3, double var5, E3DSubject var7);

        protected abstract void on(Point<E3DAtom> var1);
    }
}

