/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.scanner;

import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.object.E3DObject;
import e3d.visualization.object.E3DSubject;
import e3d.visualization.scanner.E3DObjectScan;
import e3d.visualization.scanner.Statistics;
import e3d.visualization.space.BinarySpace;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import java.util.concurrent.CopyOnWriteArrayList;

public class E3DPhysicalSubjectScan
extends BinarySpace<E3DAtom>
implements E3DObjectScan {
    private E3DSubject subject;
    protected final double compensation;
    private final boolean scanEvenEmpty;
    private Statistics statistics = new Statistics();
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public E3DPhysicalSubjectScan(E3DBoundingBox bounds, int width, int height, int depth, double compensation, boolean scanEvenEmpty) {
        super(bounds, width, height, depth);
        this.compensation = compensation;
        this.scanEvenEmpty = scanEvenEmpty;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public E3DSubject getObject() {
        return this.subject;
    }

    @Override
    public void setObject(E3DObject object) throws InterruptedException {
        if (!(object instanceof E3DSubject)) {
            throw new RuntimeException("This class only works on E3DSubjects.");
        }
        this.clear();
        this.subject = (E3DSubject)object;
        this.statistics.scanningClock.start();
        double diag = this.getElementSize().length();
        int s = this.getSize() - 1;
        long done = 0L;
        for (ProgressListener listener : this.progressListeners) {
            listener.init(s * s * s / 100000, "SCANNING OBJECT");
        }
        this.scan(0, 0, 0, s + 1, s + 1, s + 1, 0, 4, diag, done);
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
        this.statistics.scanningClock.stop();
    }

    private long scan(int i1, int j1, int k1, int i2, int j2, int k2, int depth, int minDepth, double diag, long done) throws InterruptedException {
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        int s = i2 - i1;
        int i0 = (i1 + i2) / 2;
        int j0 = (j1 + j2) / 2;
        int k0 = (k1 + k2) / 2;
        this.subject.setPoint(this.coords.x(i0), this.coords.y(j0), this.coords.z(k0));
        Integer color = this.subject.getColor();
        double dist = this.subject.getDistance();
        ++this.statistics.calculatedPoints;
        if (color != null || this.scanEvenEmpty) {
            if (Math.abs(dist) < diag * this.compensation) {
                E3DAtom atom = new E3DAtom(color, this.subject.getNormal().clone());
                this.setAtom(atom, i0, j0, k0);
                ++this.statistics.surfacePoints;
            }
            ++this.statistics.solidPoints;
        }
        if (s > 1 && (depth < minDepth || Math.abs(dist) < diag * ((double)(s + 1) / 2.0) * this.compensation)) {
            done = this.scan(i1, j1, k1, i0, j0, k0, depth + 1, minDepth, diag, done);
            done = this.scan(i1, j1, k0, i0, j0, k2, depth + 1, minDepth, diag, done);
            done = this.scan(i1, j0, k1, i0, j2, k0, depth + 1, minDepth, diag, done);
            done = this.scan(i1, j0, k0, i0, j2, k2, depth + 1, minDepth, diag, done);
            done = this.scan(i0, j1, k1, i2, j0, k0, depth + 1, minDepth, diag, done);
            done = this.scan(i0, j1, k0, i2, j0, k2, depth + 1, minDepth, diag, done);
            done = this.scan(i0, j0, k1, i2, j2, k0, depth + 1, minDepth, diag, done);
            done = this.scan(i0, j0, k0, i2, j2, k2, depth + 1, minDepth, diag, done);
        } else {
            done += (long)(s * s * s);
        }
        if (depth == minDepth) {
            this.done("SCANNING", done);
        }
        return done;
    }

    private void done(String task, long done) {
        for (ProgressListener listener : this.progressListeners) {
            listener.done((int)(done / 100000L), String.format("%s (time: %s / %5.1f million points)", task, this.statistics.getScanningTime(), (double)this.statistics.calculatedPoints / 1000000.0));
        }
    }
}

