/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.scanner;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DPlane;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DRotation;
import e3d.utils.MathUtils;
import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.object.E3DObject;
import e3d.visualization.scanner.E3DVirtualSubjectScan;
import e3d.visualization.space.Point;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DLight;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class E3DHybridSubjectScan
extends E3DVirtualSubjectScan {
    protected final Map<E3DVector, Screen> pos2Screen = new HashMap<E3DVector, Screen>();

    public E3DHybridSubjectScan(E3DBoundingBox bounds, int width, int height, int depth, double compensation) {
        super(bounds, width, height, depth, compensation);
    }

    public void setViews(E3DVector viewPos, E3DVector focusPoint, Collection<E3DLight> lights) throws InterruptedException {
        HashSet<E3DVector> rescan = new HashSet<E3DVector>();
        HashSet<E3DVector> unused = new HashSet<E3DVector>(this.pos2Screen.keySet());
        if (!unused.remove(viewPos)) {
            rescan.add(viewPos);
        }
        for (E3DLight light : lights) {
            if (unused.remove(light.getPosition())) continue;
            rescan.add(light.getPosition());
        }
        for (E3DVector pos : unused) {
            this.pos2Screen.remove(pos);
        }
        this.statistics.scanningClock.start();
        for (ProgressListener listener : this.progressListeners) {
            listener.init(this.width * this.height * rescan.size() / 10000, "PRE-SCAN");
        }
        int size = MathUtils.maxInt(this.width, this.height, this.depth);
        int delta = Math.max(4, 1 << (int)(Math.log((double)size / 20.0) / Math.log(2.0)));
        E3DBoundingBox bounds = this.getTightBounds();
        double w = bounds.width();
        double h = bounds.height();
        long done = 0L;
        if (!this.pos2Screen.containsKey(viewPos)) {
            Screen view = new Screen(this.width, this.height, w, h, viewPos, focusPoint);
            this.pos2Screen.put(viewPos, view);
            done = this.scanScreen(view, delta, done);
        }
        for (E3DLight light : lights) {
            E3DVector lightPos = light.getPosition();
            if (this.pos2Screen.containsKey(light.getPosition())) continue;
            Screen view = new Screen(this.width, this.height, w, h, lightPos, focusPoint);
            this.pos2Screen.put(lightPos, view);
            done = this.scanScreen(view, delta, done);
        }
        this.statistics.scanningClock.stop();
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }

    @Override
    public void setObject(E3DObject object) throws InterruptedException {
        super.setObject(object);
    }

    @Override
    public void perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, E3DVirtualSubjectScan.XYZRayTask task) {
        Screen screen = this.pos2Screen.get(new E3DVector(x, y, z));
        if (screen == null) {
            super.perform(x, y, z, dx, dy, dz, tmin, tmax, task);
        } else if (!screen.perform(x, y, z, dx, dy, dz, tmin, tmax, task)) {
            super.perform(x, y, z, dx, dy, dz, tmin, tmax, task);
        }
    }

    private long scanScreen(Screen view, int delta, long done) throws InterruptedException {
        E3DLine ray = new E3DLine();
        this.scanInitial(view, ray, 0, 0, delta, delta);
        double dt = this.getElementSize().length();
        int d = delta;
        while (d > 1) {
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            this.scanDiagonal(view, ray, d / 2, d / 2, d, d, d / 2, d / 2, dt * (double)d);
            this.done("PRE-SCAN", done + (long)((double)(view.cols / d) * 1.33 * ((double)(view.rows / d) * 1.33)));
            this.scanStraight(view, ray, 0, d / 2, d, d, d / 2, d / 2, dt * (double)d);
            this.done("PRE-SCAN", done + (long)((double)(view.cols / d) * 1.66 * ((double)(view.rows / d) * 1.66)));
            this.scanStraight(view, ray, d / 2, 0, d, d, d / 2, d / 2, dt * (double)d);
            this.done("PRE-SCAN", done + (long)((double)(view.cols / d) * 2.0 * ((double)(view.rows / d) * 2.0)));
            d /= 2;
        }
        this.done("PRE-SCAN ", done += (long)view.cols * (long)view.rows);
        return done;
    }

    private int scanInitial(Screen view, E3DLine ray, int i0, int j0, int di, int dj) throws InterruptedException {
        int points = 0;
        int i = i0;
        while (i < view.cols) {
            int j = j0;
            while (j < view.rows) {
                view.getRay(i, j, ray);
                view.points[i][j] = this.superGetNextPointInRay(ray.a.x, ray.a.y, ray.a.z, ray.b.x, ray.b.y, ray.b.z, 0.0, Double.POSITIVE_INFINITY);
                j += dj;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            i += di;
        }
        return points;
    }

    private void scanDiagonal(Screen view, E3DLine ray, int i0, int j0, int di, int dj, int gi, int gj, double dt) throws InterruptedException {
        int i = i0;
        while (i < view.cols) {
            int j = j0;
            while (j < view.rows) {
                view.getRay(i, j, ray);
                int i1 = Math.max(i, gi);
                int i2 = Math.min(i, view.cols - gi - 1);
                int j1 = Math.max(j, gj);
                int j2 = Math.min(j, view.rows - gj - 1);
                double t = this.tMin(ray, view.points[i1 - gi][j1 - gj], view.points[i1 - gi][j2 + gj], view.points[i2 + gi][j1 - gj], view.points[i2 + gi][j2 + gj]) - dt;
                view.points[i][j] = this.superGetNextPointInRay(ray.a.x, ray.a.y, ray.a.z, ray.b.x, ray.b.y, ray.b.z, t, Double.POSITIVE_INFINITY);
                j += dj;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            i += di;
        }
    }

    private void scanStraight(Screen view, E3DLine ray, int i0, int j0, int di, int dj, int gi, int gj, double dt) throws InterruptedException {
        int i = i0;
        while (i < view.cols) {
            int j = j0;
            while (j < view.rows) {
                view.getRay(i, j, ray);
                int i1 = Math.max(i, gi);
                int i2 = Math.min(i, view.cols - gi - 1);
                int j1 = Math.max(j, gj);
                int j2 = Math.min(j, view.rows - gj - 1);
                double t = this.tMin(ray, view.points[i1 - gi][j], view.points[i2 + gi][j], view.points[i][j1 - gj], view.points[i][j2 + gj]) - dt;
                view.points[i][j] = this.superGetNextPointInRay(ray.a.x, ray.a.y, ray.a.z, ray.b.x, ray.b.y, ray.b.z, t, Double.POSITIVE_INFINITY);
                j += dj;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            i += di;
        }
    }

    private double tMin(E3DLine ray, Point<E3DAtom> p1, Point<E3DAtom> p2, Point<E3DAtom> p3, Point<E3DAtom> p4) {
        double rayLength = ray.b.length();
        return MathUtils.min(this.t(ray, rayLength, p1), this.t(ray, rayLength, p2), this.t(ray, rayLength, p3), this.t(ray, rayLength, p4));
    }

    private double t(E3DLine ray, double rayLength, Point<E3DAtom> point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        return ray.a.dist(point) / rayLength;
    }

    public Point<E3DAtom> superGetNextPointInRay(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax) {
        this.xyzRayNextPointGetter.reinit();
        super.perform(x, y, z, dx, dy, dz, tmin, tmax, this.xyzRayNextPointGetter);
        return this.xyzRayNextPointGetter.getPoint();
    }

    private void done(String task, long done) {
        for (ProgressListener listener : this.progressListeners) {
            listener.done((int)(done / 10000L), String.format("%s (time: %s / %5.1f million points)", task, this.statistics.getScanningTime(), (double)this.statistics.calculatedPoints / 1000000.0));
        }
    }

    protected static class Screen {
        protected final Point<E3DAtom>[][] points;
        protected final int cols;
        protected final int rows;
        protected final double width;
        protected final double height;
        protected final E3DPlane plane;
        protected final E3DLine colRay;
        protected final E3DLine rowRay;
        protected final E3DLine centralViewRay;
        protected final E3DLine ray = new E3DLine();
        protected final E3DVector intersection = new E3DVector();

        public Screen(int cols, int rows, double width, double height, E3DVector viewPos, E3DVector focusPoint) {
            this.cols = cols;
            this.rows = rows;
            this.width = width;
            this.height = height;
            this.points = this.createPoints(cols, rows);
            this.centralViewRay = new E3DLine(viewPos, focusPoint.diff(viewPos));
            E3DRotation spin = new E3DRotation(this.centralViewRay.b, false, false, false);
            E3DVector upperLeftCorner = new E3DVector(-width / 2.0, -height / 2.0, 0.0);
            E3DVector upperRightCorner = new E3DVector(width / 2.0, -height / 2.0, 0.0);
            E3DVector lowerLeftCorner = new E3DVector(-width / 2.0, height / 2.0, 0.0);
            spin.transform(upperLeftCorner);
            spin.transform(upperRightCorner);
            spin.transform(lowerLeftCorner);
            upperLeftCorner.x += focusPoint.x;
            upperLeftCorner.y += focusPoint.y;
            upperLeftCorner.z += focusPoint.z;
            upperRightCorner.x += focusPoint.x;
            upperRightCorner.y += focusPoint.y;
            upperRightCorner.z += focusPoint.z;
            lowerLeftCorner.x += focusPoint.x;
            lowerLeftCorner.y += focusPoint.y;
            lowerLeftCorner.z += focusPoint.z;
            this.colRay = new E3DLine(upperLeftCorner, upperRightCorner.diff(upperLeftCorner).quotient(cols));
            this.rowRay = new E3DLine(upperLeftCorner, lowerLeftCorner.diff(upperLeftCorner).quotient(rows));
            this.plane = new E3DPlane(this.colRay.a, this.colRay.b, this.rowRay.b);
        }

        private Point<E3DAtom>[][] createPoints(int cols, int rows) {
            return new Point[cols][rows];
        }

        protected void getRay(int i, int j, E3DLine ray) {
            ray.a.set(this.centralViewRay.a);
            ray.b.set(this.colRay.a.x + this.colRay.b.x * ((double)i + 0.5) + this.rowRay.b.x * ((double)j + 0.5) - this.centralViewRay.a.x, this.colRay.a.y + this.colRay.b.y * ((double)i + 0.5) + this.rowRay.b.y * ((double)j + 0.5) - this.centralViewRay.a.y, this.colRay.a.z + this.colRay.b.z * ((double)i + 0.5) + this.rowRay.b.z * ((double)j + 0.5) - this.centralViewRay.a.z);
        }

        protected boolean perform(double x, double y, double z, double dx, double dy, double dz, double tmin, double tmax, E3DVirtualSubjectScan.XYZRayTask task) {
            this.ray.set(x, y, z, dx, dy, dz);
            this.intersection.intersection(this.ray, this.plane);
            int i = (int)(this.rowRay.dist(this.intersection) / this.width * (double)this.cols + 0.5);
            int j = (int)(this.colRay.dist(this.intersection) / this.height * (double)this.rows + 0.5);
            if (i >= 0 && i < this.cols && j >= 0 && j < this.rows) {
                double t;
                if (this.points[i][j] != null && (t = this.ray.a.dist(this.points[i][j].x, this.points[i][j].y, this.points[i][j].z) / this.ray.b.length()) >= tmin && t <= tmax) {
                    task.on(this.points[i][j]);
                }
                return true;
            }
            return false;
        }
    }
}

