/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.renderer;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DRotation;
import e3d.utils.MathUtils;
import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;
import e3d.visualization.space.Point;
import e3d.visualization.space.Scan;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DLight;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.E3DScene;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class E3DRayTracer {
    protected static final E3DColor BACKGROUND_COLOR = new E3DColor(255, 255, 255, 0);
    protected int maxDepth = 0;
    protected double offsetFactor = 3.0;
    protected E3DMaterial defaultMaterial = new E3DMaterial();
    protected E3DImage.Type imageType = E3DImage.Type.AWT;
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public E3DRayTracer() {
    }

    public E3DRayTracer(int maxDepth, double offsetFactor, E3DMaterial defaultMaterial, E3DImage.Type imageType) {
        this.maxDepth = maxDepth;
        this.defaultMaterial = defaultMaterial;
        this.imageType = imageType;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public double getOffsetFactor() {
        return this.offsetFactor;
    }

    public void setOffsetFactor(double offsetFactor) {
        this.offsetFactor = offsetFactor;
    }

    public E3DMaterial getDefaultMaterial() {
        return this.defaultMaterial;
    }

    public void setDefaultMaterial(E3DMaterial material) {
        this.defaultMaterial = material;
    }

    public E3DImage.Type getImageType() {
        return this.imageType;
    }

    public void setImageType(E3DImage.Type imageType) {
        this.imageType = imageType;
    }

    public E3DImage getImage(E3DScene scene, int width, int height, int depth, float[][][] xyzBuffer) throws InterruptedException {
        E3DBoundingBox bounds = scene.getBounds();
        List<E3DLight> lights = scene.getLights();
        E3DEnvironment environment = scene.getEnvironment();
        E3DVector viewPos = scene.getViewerPosition();
        E3DVector focusPnt = scene.getFocusPoint();
        Scan<E3DAtom> scan = scene.getScan();
        E3DVector voxelSize = scan.getElementSize();
        double offset = Math.sqrt(voxelSize.x * voxelSize.x + voxelSize.y * voxelSize.y + voxelSize.z * voxelSize.z) * this.offsetFactor;
        for (ProgressListener listener : this.progressListeners) {
            listener.init(width, "RENDERING");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "rendering");
        }
        Screen screen = new Screen(width, height, viewPos, focusPnt, bounds);
        E3DImage image = E3DImage.image(width, height, BACKGROUND_COLOR, this.imageType);
        E3DLine ray = new E3DLine();
        E3DVector pixelPos = new E3DVector();
        int col = 0;
        while (col < width) {
            screen.rowRay.a.set(screen.colRay.point(col));
            int row = 0;
            while (row < height) {
                screen.rowRay.point(row, pixelPos);
                if (TaskUtils.isInterrupted()) {
                    throw new InterruptedException();
                }
                ray.set(viewPos, pixelPos.diff(viewPos));
                Point<E3DAtom> hit = scan.getNextPointInRay(ray.a.x, ray.a.y, ray.a.z, ray.b.x, ray.b.y, ray.b.z, 0.0, Double.POSITIVE_INFINITY);
                RayColor color = this.trace(ray, hit, scan, environment, lights, offset, this.maxDepth);
                if (color != null && (hit != null || environment != null && environment.isDirectlyVisible())) {
                    image.setRGB(col, row, color.getColor());
                }
                if (xyzBuffer != null) {
                    if (hit != null) {
                        xyzBuffer[col][row][0] = (float)hit.x;
                        xyzBuffer[col][row][1] = (float)hit.y;
                        xyzBuffer[col][row][2] = (float)hit.z;
                    } else {
                        xyzBuffer[col][row][0] = Float.POSITIVE_INFINITY;
                        xyzBuffer[col][row][1] = Float.POSITIVE_INFINITY;
                        xyzBuffer[col][row][2] = Float.POSITIVE_INFINITY;
                    }
                }
                ++row;
            }
            for (ProgressListener listener : this.progressListeners) {
                listener.done(col, "rendering");
            }
            ++col;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(100, "Rendering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
        return image;
    }

    protected RayColor trace(E3DLine ray, Point<E3DAtom> hit, Scan<E3DAtom> scan, E3DEnvironment environment, List<E3DLight> lights, double offset, int depth) {
        Point<E3DAtom> next;
        RayColor reflectedColor;
        double reflectivity;
        if (hit == null) {
            if (environment == null) {
                return null;
            }
            Integer color = environment.getColor(ray.a.x, ray.a.y, ray.a.z, ray.b.x, ray.b.y, ray.b.z);
            return color == null ? null : new RayColor(color);
        }
        E3DAtom atom = hit.getAtom();
        E3DVector normal = atom.getNormal();
        E3DMaterial material = atom.getMaterial() == null ? this.defaultMaterial : atom.getMaterial();
        normal.oppose(ray.b);
        double n = offset / normal.length();
        Point<E3DAtom> point = new Point<E3DAtom>(hit.x + normal.x * n, hit.y + normal.y * n, hit.z + normal.z * n, atom);
        E3DLine reflectedRay = new E3DLine(point, ray.b.mirrored(normal));
        RayColor color = this.traceLights(point, normal, offset, reflectedRay, material, lights, scan);
        if (depth > 0 && (reflectivity = material.getReflectivity()) > 0.0 && reflectedRay.isValid() && (reflectedColor = this.trace(reflectedRay, next = scan.getNextPointInRay(reflectedRay.a.x, reflectedRay.a.y, reflectedRay.a.z, reflectedRay.b.x, reflectedRay.b.y, reflectedRay.b.z, offset / reflectedRay.b.length(), Double.POSITIVE_INFINITY), scan, environment, lights, offset, depth - 1)) != null) {
            double luminocity = color.getLuminocity();
            double quadratic = reflectivity / 2.0 - MathUtils.square((luminocity - 0.5) * reflectivity);
            double linear = reflectivity / 2.0 * (1.0 - luminocity);
            double factor = quadratic + linear;
            color.red = color.red * (1.0 - factor) + reflectedColor.red * factor;
            color.green = color.green * (1.0 - factor) + reflectedColor.green * factor;
            color.blue = color.blue * (1.0 - factor) + reflectedColor.blue * factor;
        }
        return color;
    }

    protected RayColor traceLights(Point<E3DAtom> point, E3DVector normal, double offset, E3DLine reflected, E3DMaterial material, List<E3DLight> lights, Scan<E3DAtom> scan) {
        int color = point.getAtom().getColor();
        double alpha = (double)E3DColor.alpha(color) / 255.0;
        RayColor cumulatedColor = new RayColor(0.0, 0.0, 0.0, alpha);
        for (E3DLight light : lights) {
            RayColor voxelColor = new RayColor(color);
            E3DVector lightPos = light.getPosition();
            E3DVector lightDir = point.diff(lightPos);
            E3DLine lightRay = new E3DLine(lightPos, lightDir);
            E3DAtom shadower = scan.getNextAtomInRay(lightRay.a.x, lightRay.a.y, lightRay.a.z, lightRay.b.x, lightRay.b.y, lightRay.b.z, 0.0, 1.0 - offset / lightRay.b.length());
            RayColor lightColor = new RayColor(light.getColor());
            double lightObjAngle = lightRay.b.angle(normal) + Math.PI;
            double lightRayAngle = lightRay.b.angle(reflected.b) + Math.PI;
            double illumination = Math.max(Math.cos(lightObjAngle), 0.0);
            double reflection = Math.pow((Math.cos(lightRayAngle) + 1.0) / 2.0, 4.0);
            double luminocity = shadower == null ? light.getLuminocity(point) : 0.0;
            Integer glowColor = material.getGlowColor();
            double glow = material.getGlow() * (glowColor == null ? 1.0 : E3DColor.similarity(voxelColor.getColor(), glowColor));
            double glossiness = material.getGlossiness();
            double factor = (luminocity * reflection * glossiness + luminocity * illumination * (1.0 - glossiness)) * (1.0 - glow) + glow;
            voxelColor.red *= lightColor.red;
            voxelColor.green *= lightColor.green;
            voxelColor.blue *= lightColor.blue;
            voxelColor.changeHSV(0.0, 2.0 - factor, factor);
            cumulatedColor.red += voxelColor.red;
            cumulatedColor.green += voxelColor.green;
            cumulatedColor.blue += voxelColor.blue;
        }
        double n = lights.size();
        cumulatedColor.red /= n;
        cumulatedColor.green /= n;
        cumulatedColor.blue /= n;
        return cumulatedColor;
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    protected static class RayColor {
        protected double red;
        protected double green;
        protected double blue;
        protected double alpha;

        public RayColor(double red, double green, double blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public RayColor(int color) {
            this.red = (double)E3DColor.red(color) / 255.0;
            this.green = (double)E3DColor.green(color) / 255.0;
            this.blue = (double)E3DColor.blue(color) / 255.0;
            this.alpha = (double)E3DColor.alpha(color) / 255.0;
        }

        public int getColor() {
            return E3DColor.rgb(Math.max(0, Math.min(255, (int)(this.red * 255.0))), Math.max(0, Math.min(255, (int)(this.green * 255.0))), Math.max(0, Math.min(255, (int)(this.blue * 255.0))), Math.max(0, Math.min(255, (int)(this.alpha * 255.0))));
        }

        public double getLuminocity() {
            return (this.red + this.green + this.blue) / 3.0;
        }

        public void changeHSV(double hueOffset, double saturationFactor, double valueFactor) {
            double max = MathUtils.max(this.red, this.green, this.blue);
            double min = MathUtils.min(this.red, this.green, this.blue);
            double delta = max - min;
            double value = max * valueFactor;
            double saturation = (max == 0.0 ? 0.0 : delta / max) * saturationFactor;
            double hue = max == min ? 0.0 : (max == this.red ? ((this.green - this.blue) / delta + (double)(this.green < this.blue ? 6 : 0)) / 6.0 + hueOffset : (max == this.green ? ((this.blue - this.red) / delta + 2.0) / 6.0 + hueOffset : ((this.red - this.green) / delta + 4.0) / 6.0 + hueOffset));
            double i = Math.floor(hue * 6.0);
            double f = hue * 6.0 - i;
            double p = value * (1.0 - saturation);
            double q = value * (1.0 - f * saturation);
            double t = value * (1.0 - (1.0 - f) * saturation);
            switch ((int)i % 6) {
                case 0: {
                    this.red = value;
                    this.green = t;
                    this.blue = p;
                    break;
                }
                case 1: {
                    this.red = q;
                    this.green = value;
                    this.blue = p;
                    break;
                }
                case 2: {
                    this.red = p;
                    this.green = value;
                    this.blue = t;
                    break;
                }
                case 3: {
                    this.red = p;
                    this.green = q;
                    this.blue = value;
                    break;
                }
                case 4: {
                    this.red = t;
                    this.green = p;
                    this.blue = value;
                    break;
                }
                case 5: {
                    this.red = value;
                    this.green = p;
                    this.blue = q;
                }
            }
        }
    }

    protected static class Screen {
        protected final E3DLine colRay;
        protected final E3DLine rowRay;
        protected final E3DLine centralViewRay;

        public Screen(int width, int height, E3DVector viewPos, E3DVector focusPoint, E3DBoundingBox bounds) {
            this.centralViewRay = new E3DLine(viewPos, focusPoint.diff(viewPos));
            E3DRotation spin = new E3DRotation(this.centralViewRay.b, false, false, false);
            E3DVector upperLeftCorner = new E3DVector(-bounds.width() / 2.0, -bounds.height() / 2.0, 0.0);
            E3DVector upperRightCorner = new E3DVector(bounds.width() / 2.0, -bounds.height() / 2.0, 0.0);
            E3DVector lowerLeftCorner = new E3DVector(-bounds.width() / 2.0, bounds.height() / 2.0, 0.0);
            spin.transform(upperLeftCorner);
            spin.transform(upperRightCorner);
            spin.transform(lowerLeftCorner);
            upperLeftCorner.x += focusPoint.x;
            upperLeftCorner.y += focusPoint.y;
            upperLeftCorner.z += focusPoint.z;
            upperRightCorner.x += focusPoint.x;
            upperRightCorner.y += focusPoint.y;
            upperRightCorner.z += focusPoint.z;
            lowerLeftCorner.x += focusPoint.x;
            lowerLeftCorner.y += focusPoint.y;
            lowerLeftCorner.z += focusPoint.z;
            this.colRay = new E3DLine(upperLeftCorner, upperRightCorner.diff(upperLeftCorner).quotient(width));
            this.rowRay = new E3DLine(upperLeftCorner, lowerLeftCorner.diff(upperLeftCorner).quotient(height));
        }
    }
}

