/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.mesh;

import e3d.euclidean.E3DVector;
import e3d.visualization.util.E3DMaterial;

public class E3DMeshPoint
extends E3DVector {
    protected E3DVector normal;
    protected int color;
    protected E3DMaterial material;

    public E3DMeshPoint() {
        this.color = 0;
        this.normal = null;
        this.material = null;
    }

    public E3DMeshPoint(double x, double y, double z, int color, E3DVector normal, E3DMaterial material) {
        super(x, y, z);
        this.color = color;
        this.normal = normal;
        this.material = material;
    }

    public E3DMeshPoint(E3DMeshPoint meshPoint) {
        super((E3DVector)meshPoint);
        this.color = meshPoint.color;
        this.normal = meshPoint.normal == null ? null : meshPoint.normal.clone();
        this.material = meshPoint.material;
    }

    @Override
    public E3DMeshPoint clone() {
        return new E3DMeshPoint(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return this.objectHashCode();
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int color() {
        return this.color;
    }

    public void setNormal(E3DVector normal) {
        this.normal = normal;
    }

    public E3DVector normal() {
        return this.normal;
    }

    public void setMaterial(E3DMaterial material) {
        this.material = material;
    }

    public E3DMaterial material() {
        return this.material;
    }
}

