/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image.filter;

import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.image.E3DImage;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class E3DImageFilter {
    protected final CopyOnWriteArrayList<ProgressListener> progressListeners = new CopyOnWriteArrayList();

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    public void filter(E3DImage image) throws InterruptedException {
        this.filter(image, image);
    }

    public void filter(E3DImage source, E3DImage target) throws InterruptedException {
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
            throw new RuntimeException("Source and target image must have the same size!");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.init(source.getHeight(), this.name());
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "Start filtering");
        }
        int y = 0;
        while (y < source.getHeight()) {
            int x = 0;
            while (x < source.getWidth()) {
                target.setRGB(x, y, this.filter(source.getRGB(x, y)));
                ++x;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            for (ProgressListener listener : this.progressListeners) {
                listener.done(y, "filtering");
            }
            ++y;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "Filtering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }

    public abstract int filter(int var1);

    public abstract boolean isChanging();

    public String name() {
        return "FILTERING";
    }
}

