/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.image.filter;

import e3d.utils.ProgressListener;
import e3d.utils.TaskUtils;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.filter.E3DImageFilter;
import e3d.visualization.util.E3DColor;

public class BGImageFilter
extends E3DImageFilter {
    protected final E3DImage bgImage;
    protected final double scale;
    protected final HorizontalAlignment horizontalAlignment;
    protected final VerticalAlignment verticalAlignment;

    public BGImageFilter(E3DImage bgImage, double scale, HorizontalAlignment hAlign, VerticalAlignment vAlign) {
        this.bgImage = bgImage;
        this.scale = scale;
        this.horizontalAlignment = hAlign;
        this.verticalAlignment = vAlign;
    }

    @Override
    public void filter(E3DImage source, E3DImage target) throws InterruptedException {
        int yOffset;
        int xOffset;
        if (TaskUtils.isInterrupted()) {
            throw new InterruptedException();
        }
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
            throw new RuntimeException("Source and target image must have the same size!");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.init(source.getHeight(), this.name());
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(0, "Start filtering");
        }
        double s = this.scale > 0.0 ? this.scale : Math.max((double)source.getWidth() / (double)this.bgImage.getWidth(), (double)source.getHeight() / (double)this.bgImage.getHeight());
        switch (this.horizontalAlignment) {
            case LEFT: {
                xOffset = 0;
                break;
            }
            case CENTER: {
                xOffset = this.bgImage.getWidth() / 2 - (int)((double)(source.getWidth() / 2) / s);
                break;
            }
            case RIGHT: {
                xOffset = this.bgImage.getWidth() - 1 - (int)((double)(source.getWidth() - 1) / s);
                break;
            }
            default: {
                xOffset = 0;
            }
        }
        switch (this.verticalAlignment) {
            case TOP: {
                yOffset = 0;
                break;
            }
            case MIDDLE: {
                yOffset = this.bgImage.getHeight() / 2 - (int)((double)(source.getHeight() / 2) / s);
                break;
            }
            case BOTTOM: {
                yOffset = this.bgImage.getHeight() - 1 - (int)((double)(source.getHeight() - 1) / s);
                break;
            }
            default: {
                yOffset = 0;
            }
        }
        int y = 0;
        while (y < source.getHeight()) {
            int x = 0;
            while (x < source.getWidth()) {
                int fg = source.getRGB(x, y);
                int x2 = (int)((double)x / s) + xOffset;
                int y2 = (int)((double)y / s) + yOffset;
                if (y2 >= 0 && y2 < this.bgImage.getHeight() && x2 >= 0 && x2 < this.bgImage.getWidth()) {
                    int bg = this.bgImage.getRGB(x2, y2);
                    target.setRGB(x, y, E3DColor.overlay(fg, bg));
                }
                ++x;
            }
            if (TaskUtils.isInterrupted()) {
                throw new InterruptedException();
            }
            for (ProgressListener listener : this.progressListeners) {
                listener.done(y, "filtering");
            }
            ++y;
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.done(listener.steps(), "Filtering complete");
        }
        for (ProgressListener listener : this.progressListeners) {
            listener.finish();
        }
    }

    @Override
    public int filter(int color) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isChanging() {
        return this.bgImage != null;
    }

    @Override
    public String name() {
        return "SETTING BACKGROUND IMAGE";
    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

