/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.environment;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DSphere;
import e3d.euclidean.E3DVector;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;

public class E3DSphereEnvironment
extends E3DEnvironment {
    protected final E3DSphere sphere;
    protected final E3DImage image;

    public E3DSphereEnvironment(boolean directlyVisible, E3DVector center, double radius, E3DImage image) {
        super(directlyVisible);
        this.sphere = new E3DSphere(center, radius);
        this.image = image;
    }

    @Override
    public Integer getColor(double x, double y, double z, double dx, double dy, double dz) {
        E3DVector[] intersections;
        E3DLine ray = new E3DLine(new E3DVector(x, y, z), new E3DVector(dx, dy, dz));
        E3DVector[] e3DVectorArray = intersections = this.sphere.intersections(ray);
        int n = intersections.length;
        int n2 = 0;
        while (n2 < n) {
            E3DVector intersection = e3DVectorArray[n2];
            if (intersection.isValid() && ray.direction(intersection) >= 0) {
                E3DVector switched = new E3DVector(intersection.x, intersection.z - this.sphere.center.z + this.sphere.center.x, intersection.y - this.sphere.center.y + this.sphere.center.z);
                double azimuth = this.sphere.azimuth(switched);
                double polar = this.sphere.polar(switched);
                return this.getColor(this.image, (azimuth + Math.PI) / (Math.PI * 2), (polar + Math.PI) / (Math.PI * 2));
            }
            ++n2;
        }
        return null;
    }

    private Integer getColor(E3DImage image, double x, double y) {
        int col = (int)(x * (double)image.getWidth());
        int row = (int)(y * (double)image.getHeight());
        return image.getRGB(col, row);
    }
}

