/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.environment;

import e3d.utils.MathUtils;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;
import e3d.visualization.util.E3DBoundingBox;

public class E3DBoxEnvironment
extends E3DEnvironment {
    protected final E3DBoundingBox bounds;
    protected final E3DImage[][] images = new E3DImage[3][2];

    public E3DBoxEnvironment(boolean directlyVisible, E3DBoundingBox bounds, E3DImage left, E3DImage right, E3DImage top, E3DImage bottom, E3DImage front, E3DImage back) {
        super(directlyVisible);
        this.bounds = bounds;
        this.images[0][0] = left;
        this.images[0][1] = right;
        this.images[1][0] = top;
        this.images[1][1] = bottom;
        this.images[2][0] = front;
        this.images[2][1] = back;
    }

    @Override
    public Integer getColor(double x, double y, double z, double dx, double dy, double dz) {
        double fy;
        double fx;
        double d = dx < 0.0 ? (this.bounds.x0 - x) / dx : (fx = dx > 0.0 ? (this.bounds.x1 - x) / dx : Double.POSITIVE_INFINITY);
        double d2 = dy < 0.0 ? (this.bounds.y0 - y) / dy : (fy = dy > 0.0 ? (this.bounds.y1 - y) / dy : Double.POSITIVE_INFINITY);
        double fz = dz < 0.0 ? (this.bounds.z0 - z) / dz : (dz > 0.0 ? (this.bounds.z1 - z) / dz : Double.POSITIVE_INFINITY);
        double fmin = MathUtils.min(fx, fy, fz);
        double xn = x + dx * fmin;
        double yn = y + dy * fmin;
        double zn = z + dz * fmin;
        if (fx == fmin) {
            if (dx < 0.0) {
                return this.getColor(this.images[0][0], (zn - this.bounds.z0) / this.bounds.depth(), (yn - this.bounds.y0) / this.bounds.height());
            }
            return this.getColor(this.images[0][1], (this.bounds.z1 - zn) / this.bounds.depth(), (yn - this.bounds.y0) / this.bounds.height());
        }
        if (fy == fmin) {
            if (dy < 0.0) {
                return this.getColor(this.images[1][0], (xn - this.bounds.x0) / this.bounds.width(), (zn - this.bounds.z0) / this.bounds.depth());
            }
            return this.getColor(this.images[1][1], (xn - this.bounds.x0) / this.bounds.width(), (this.bounds.z1 - zn) / this.bounds.depth());
        }
        if (dz < 0.0) {
            return this.getColor(this.images[2][0], (this.bounds.x1 - xn) / this.bounds.width(), (yn - this.bounds.y0) / this.bounds.height());
        }
        return this.getColor(this.images[2][1], (xn - this.bounds.x0) / this.bounds.width(), (yn - this.bounds.y0) / this.bounds.height());
    }

    private Integer getColor(E3DImage image, double x, double y) {
        if (image == null) {
            return null;
        }
        int col = Math.max(0, Math.min(image.getWidth() - 1, (int)(x * (double)(image.getWidth() - 1))));
        int row = Math.max(0, Math.min(image.getHeight() - 1, (int)(y * (double)(image.getHeight() - 1))));
        return image.getRGB(col, row);
    }
}

