/*
 * Decompiled with CFR 0.152.
 */
package e3d.visualization.colorizer;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DPlane;
import e3d.euclidean.E3DVector;
import e3d.visualization.image.E3DImage;
import e3d.visualization.mesh.E3DMesh;
import e3d.visualization.mesh.E3DMeshPoint;
import e3d.visualization.util.E3DBoundingBox;
import java.util.Set;

public class E3DProjectionBox {
    public static final int TOPSIDE = 0;
    public static final int BOTTOMSIDE = 1;
    public static final int LEFTSIDE = 2;
    public static final int RIGHTSIDE = 3;
    public static final int FRONTSIDE = 4;
    public static final int BACKSIDE = 5;
    public static final int[] SIDES;
    protected final E3DImage[] images = new E3DImage[6];
    protected final E3DPlane[] sides = new E3DPlane[]{new E3DPlane(), new E3DPlane(), new E3DPlane(), new E3DPlane(), new E3DPlane(), new E3DPlane()};
    protected final boolean[] enabled = new boolean[]{true, true, true, true, true, true};
    protected double width;
    protected double height;
    protected double depth;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        SIDES = nArray;
    }

    public E3DProjectionBox() {
        this.width = 0.0;
        this.height = 0.0;
        this.depth = 0.0;
    }

    public E3DProjectionBox(E3DProjectionBox box) {
        this.width = box.width;
        this.height = box.height;
        this.depth = box.depth;
        int i = 0;
        while (i < 6) {
            this.images[i] = box.images[i];
            this.sides[i].set(box.sides[i]);
            ++i;
        }
    }

    public E3DProjectionBox(double left, double top, double front, double right, double bottom, double back) {
        this.setBounds(left, top, front, right, bottom, back);
    }

    public E3DProjectionBox(E3DBoundingBox bounds) {
        this.setBounds(bounds.x0, bounds.y0, bounds.z0, bounds.x1, bounds.y1, bounds.z1);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public boolean isEnabled(int side) {
        return this.enabled[side];
    }

    public void setEnabled(int side, boolean enabled) {
        this.enabled[side] = enabled;
    }

    public void setEnabled(Set<String> tags, String frontTag, String leftTag, String topTag, String backTag, String rightTag, String bottomTag) {
        this.setEnabled(4, tags.contains(frontTag));
        this.setEnabled(2, tags.contains(leftTag));
        this.setEnabled(0, tags.contains(topTag));
        this.setEnabled(5, tags.contains(backTag));
        this.setEnabled(3, tags.contains(rightTag));
        this.setEnabled(1, tags.contains(bottomTag));
    }

    public E3DImage getImage(int side) {
        return this.images[side];
    }

    public void setImage(int side, E3DImage image) {
        this.images[side] = image;
    }

    public E3DPlane getSide(int side) {
        return this.sides[side];
    }

    public void setBounds(double left, double top, double front, double right, double bottom, double back) {
        E3DVector p = new E3DVector();
        E3DVector n = new E3DVector();
        this.width = Math.abs(right - left);
        this.height = Math.abs(bottom - top);
        this.depth = Math.abs(back - front);
        p.set(left, top, front);
        n.set(0.0, 1.0, 0.0);
        this.sides[0].set(n, p);
        p.set(left, bottom, front);
        n.set(0.0, -1.0, 0.0);
        this.sides[1].set(n, p);
        p.set(left, top, front);
        n.set(1.0, 0.0, 0.0);
        this.sides[2].set(n, p);
        p.set(right, top, front);
        n.set(-1.0, 0.0, 0.0);
        this.sides[3].set(n, p);
        p.set(left, top, front);
        n.set(0.0, 0.0, 1.0);
        this.sides[4].set(n, p);
        p.set(left, top, back);
        n.set(0.0, 0.0, -1.0);
        this.sides[5].set(n, p);
    }

    public void setBounds(E3DBoundingBox bounds) {
        this.setBounds(bounds.x0, bounds.y0, bounds.z0, bounds.x1, bounds.y1, bounds.z1);
    }

    public void setProjections(E3DMesh mesh) {
        int y = 0;
        while (y < mesh.height()) {
            int x = 0;
            while (x < mesh.width()) {
                E3DMeshPoint point = (E3DMeshPoint)mesh.get(x, y);
                int[] nArray = SIDES;
                int n = SIDES.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer mirrored;
                    int side = nArray[n2];
                    if (this.isEnabled(side) && (mirrored = this.mirrored(point, side)) != null) {
                        point.setColor(mirrored);
                    }
                    ++n2;
                }
                ++x;
            }
            ++y;
        }
    }

    private Integer mirrored(E3DVector point, int side) {
        E3DLine ray = new E3DLine(point, this.sides[side].n);
        E3DVector intersectionPoint = this.sides[side].intersection(ray);
        return this.mirrored(side, intersectionPoint);
    }

    protected Integer mirrored(int side, E3DVector intersectionPoint) {
        double y;
        double x;
        switch (side) {
            case 0: {
                x = this.sides[2].dist(intersectionPoint) / this.width * this.imageWidth(side);
                y = this.sides[5].dist(intersectionPoint) / this.depth * this.imageHeight(side);
                break;
            }
            case 1: {
                x = this.sides[2].dist(intersectionPoint) / this.width * this.imageWidth(side);
                y = this.sides[4].dist(intersectionPoint) / this.depth * this.imageHeight(side);
                break;
            }
            case 2: {
                x = this.sides[4].dist(intersectionPoint) / this.depth * this.imageWidth(side);
                y = this.sides[0].dist(intersectionPoint) / this.height * this.imageHeight(side);
                break;
            }
            case 3: {
                x = this.sides[5].dist(intersectionPoint) / this.depth * this.imageWidth(side);
                y = this.sides[0].dist(intersectionPoint) / this.height * this.imageHeight(side);
                break;
            }
            case 4: {
                x = this.sides[2].dist(intersectionPoint) / this.width * this.imageWidth(side);
                y = this.sides[0].dist(intersectionPoint) / this.height * this.imageHeight(side);
                break;
            }
            case 5: {
                x = this.sides[3].dist(intersectionPoint) / this.width * this.imageWidth(side);
                y = this.sides[0].dist(intersectionPoint) / this.height * this.imageHeight(side);
                break;
            }
            default: {
                return null;
            }
        }
        Integer color = this.mirrored(side, x, y);
        return color;
    }

    private Integer mirrored(int side, double x, double y) {
        int xi = (int)x;
        int yi = (int)y;
        if (this.images[side] == null) {
            return null;
        }
        if (xi < 0 || xi >= this.images[side].getWidth() || yi < 0 || yi >= this.images[side].getHeight()) {
            return null;
        }
        return this.images[side].getRGB(xi, yi);
    }

    private double imageWidth(int side) {
        if (this.images[side] == null) {
            return 0.0;
        }
        return this.images[side].getWidth();
    }

    private double imageHeight(int side) {
        if (this.images[side] == null) {
            return 0.0;
        }
        return this.images[side].getHeight();
    }
}

