/*
 * Decompiled with CFR 0.152.
 */
package e3d.utils;

import e3d.utils.MathUtils;

public class SingularValueDecomposition {
    private double[][] u;
    private double[][] v;
    private double[] s;
    private double[] e;
    private double[] work;
    private int m;
    private int n;

    public SingularValueDecomposition(int rows, int cols) {
        this.m = rows;
        this.n = cols;
        if (this.m < this.n) {
            throw new IllegalArgumentException("SVD only works for m >= n");
        }
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.u = new double[this.m][nu];
        this.v = new double[this.n][this.n];
        this.e = new double[this.n];
        this.work = new double[this.m];
    }

    public void decompose(double[][] in, boolean createU, boolean createV) {
        int i;
        double t;
        int k;
        int j;
        int nu = Math.min(this.m, this.n);
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k2 = 0;
        while (k2 < Math.max(nct, nrt)) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.s[k2] = 0.0;
                i3 = k2;
                while (i3 < this.m) {
                    this.s[k2] = MathUtils.hypot(this.s[k2], in[i3][k2]);
                    ++i3;
                }
                if (this.s[k2] != 0.0) {
                    if (in[k2][k2] < 0.0) {
                        this.s[k2] = -this.s[k2];
                    }
                    i3 = k2;
                    while (i3 < this.m) {
                        double[] dArray = in[i3];
                        int n = k2;
                        dArray[n] = dArray[n] / this.s[k2];
                        ++i3;
                    }
                    double[] dArray = in[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k2] = -this.s[k2];
            }
            j = k2 + 1;
            while (j < this.n) {
                if (k2 < nct && this.s[k2] != 0.0) {
                    double t2 = 0.0;
                    i2 = k2;
                    while (i2 < this.m) {
                        t2 += in[i2][k2] * in[i2][j];
                        ++i2;
                    }
                    t2 = -t2 / in[k2][k2];
                    i2 = k2;
                    while (i2 < this.m) {
                        double[] dArray = in[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * in[i2][k2];
                        ++i2;
                    }
                }
                this.e[j] = in[k2][j];
                ++j;
            }
            if (createU && k2 < nct) {
                i3 = k2;
                while (i3 < this.m) {
                    this.u[i3][k2] = in[i3][k2];
                    ++i3;
                }
            }
            if (k2 < nrt) {
                this.e[k2] = 0.0;
                i3 = k2 + 1;
                while (i3 < this.n) {
                    this.e[k2] = MathUtils.hypot(this.e[k2], this.e[i3]);
                    ++i3;
                }
                if (this.e[k2] != 0.0) {
                    if (this.e[k2 + 1] < 0.0) {
                        this.e[k2] = -this.e[k2];
                    }
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        this.e[n] = this.e[n] / this.e[k2];
                    }
                    int n = k2 + 1;
                    this.e[n] = this.e[n] + 1.0;
                }
                this.e[k2] = -this.e[k2];
                if (k2 + 1 < this.m && this.e[k2] != 0.0) {
                    i3 = k2 + 1;
                    while (i3 < this.m) {
                        this.work[i3] = 0.0;
                        ++i3;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        int i4 = k2 + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            this.work[n] = this.work[n] + this.e[j] * in[i4][j];
                            ++i4;
                        }
                        ++j;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        double t3 = -this.e[j] / this.e[k2 + 1];
                        i2 = k2 + 1;
                        while (i2 < this.m) {
                            double[] dArray = in[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t3 * this.work[i2];
                            ++i2;
                        }
                        ++j;
                    }
                }
                if (createV) {
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        this.v[i3][k2] = this.e[i3];
                        ++i3;
                    }
                }
            }
            ++k2;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = in[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            this.e[nrt] = in[nrt][p - 1];
        }
        this.e[p - 1] = 0.0;
        if (createU) {
            j = nct;
            while (j < nu) {
                int i5 = 0;
                while (i5 < this.m) {
                    this.u[i5][j] = 0.0;
                    ++i5;
                }
                this.u[j][j] = 1.0;
                ++j;
            }
            k = nct - 1;
            while (k >= 0) {
                int i6;
                if (this.s[k] != 0.0) {
                    int j2 = k + 1;
                    while (j2 < nu) {
                        t = 0.0;
                        i = k;
                        while (i < this.m) {
                            t += this.u[i][k] * this.u[i][j2];
                            ++i;
                        }
                        t = -t / this.u[k][k];
                        i = k;
                        while (i < this.m) {
                            double[] dArray = this.u[i];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this.u[i][k];
                            ++i;
                        }
                        ++j2;
                    }
                    i6 = k;
                    while (i6 < this.m) {
                        this.u[i6][k] = -this.u[i6][k];
                        ++i6;
                    }
                    this.u[k][k] = 1.0 + this.u[k][k];
                    i6 = 0;
                    while (i6 < k - 1) {
                        this.u[i6][k] = 0.0;
                        ++i6;
                    }
                } else {
                    i6 = 0;
                    while (i6 < this.m) {
                        this.u[i6][k] = 0.0;
                        ++i6;
                    }
                    this.u[k][k] = 1.0;
                }
                --k;
            }
        }
        if (createV) {
            k = this.n - 1;
            while (k >= 0) {
                if (k < nrt && this.e[k] != 0.0) {
                    int j3 = k + 1;
                    while (j3 < nu) {
                        t = 0.0;
                        i = k + 1;
                        while (i < this.n) {
                            t += this.v[i][k] * this.v[i][j3];
                            ++i;
                        }
                        t = -t / this.v[k + 1][k];
                        i = k + 1;
                        while (i < this.n) {
                            double[] dArray = this.v[i];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.v[i][k];
                            ++i;
                        }
                        ++j3;
                    }
                }
                int i7 = 0;
                while (i7 < this.n) {
                    this.v[i7][k] = 0.0;
                    ++i7;
                }
                this.v[k][k] = 1.0;
                --k;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3 = p - 2;
            while (k3 >= -1) {
                if (k3 == -1) break;
                if (Math.abs(this.e[k3]) <= tiny + eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1]))) {
                    this.e[k3] = 0.0;
                    break;
                }
                --k3;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k3) {
                    if (ks == k3) break;
                    double t4 = (ks != p ? Math.abs(this.e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(this.e[ks - 1]) : 0.0);
                    if (Math.abs(this.s[ks]) <= tiny + eps * t4) {
                        this.s[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = this.e[p - 2];
                    this.e[p - 2] = 0.0;
                    int j4 = p - 2;
                    while (j4 >= k3) {
                        t5 = MathUtils.hypot(this.s[j4], f);
                        cs = this.s[j4] / t5;
                        sn = f / t5;
                        this.s[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * this.e[j4 - 1];
                            this.e[j4 - 1] = cs * this.e[j4 - 1];
                        }
                        if (createV) {
                            i8 = 0;
                            while (i8 < this.n) {
                                t5 = cs * this.v[i8][j4] + sn * this.v[i8][p - 1];
                                this.v[i8][p - 1] = -sn * this.v[i8][j4] + cs * this.v[i8][p - 1];
                                this.v[i8][j4] = t5;
                                ++i8;
                            }
                        }
                        --j4;
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = this.e[k3 - 1];
                    this.e[k3 - 1] = 0.0;
                    int j5 = k3;
                    while (j5 < p) {
                        t5 = MathUtils.hypot(this.s[j5], f);
                        cs = this.s[j5] / t5;
                        sn = f / t5;
                        this.s[j5] = t5;
                        f = -sn * this.e[j5];
                        this.e[j5] = cs * this.e[j5];
                        if (createU) {
                            i8 = 0;
                            while (i8 < this.m) {
                                t5 = cs * this.u[i8][j5] + sn * this.u[i8][k3 - 1];
                                this.u[i8][k3 - 1] = -sn * this.u[i8][j5] + cs * this.u[i8][k3 - 1];
                                this.u[i8][j5] = t5;
                                ++i8;
                            }
                        }
                        ++j5;
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(this.e[p - 2])), Math.abs(this.s[k3])), Math.abs(this.e[k3]));
                    double sp = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = this.e[p - 2] / scale;
                    double sk = this.s[k3] / scale;
                    double ek = this.e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 || c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    int j6 = k3;
                    while (j6 < p - 1) {
                        int i9;
                        double t6 = MathUtils.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            this.e[j6 - 1] = t6;
                        }
                        f = cs * this.s[j6] + sn * this.e[j6];
                        this.e[j6] = cs * this.e[j6] - sn * this.s[j6];
                        g = sn * this.s[j6 + 1];
                        this.s[j6 + 1] = cs * this.s[j6 + 1];
                        if (createV) {
                            i9 = 0;
                            while (i9 < this.n) {
                                t6 = cs * this.v[i9][j6] + sn * this.v[i9][j6 + 1];
                                this.v[i9][j6 + 1] = -sn * this.v[i9][j6] + cs * this.v[i9][j6 + 1];
                                this.v[i9][j6] = t6;
                                ++i9;
                            }
                        }
                        t6 = MathUtils.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.s[j6] = t6;
                        f = cs * this.e[j6] + sn * this.s[j6 + 1];
                        this.s[j6 + 1] = -sn * this.e[j6] + cs * this.s[j6 + 1];
                        g = sn * this.e[j6 + 1];
                        this.e[j6 + 1] = cs * this.e[j6 + 1];
                        if (createU && j6 < this.m - 1) {
                            i9 = 0;
                            while (i9 < this.m) {
                                t6 = cs * this.u[i9][j6] + sn * this.u[i9][j6 + 1];
                                this.u[i9][j6 + 1] = -sn * this.u[i9][j6] + cs * this.u[i9][j6 + 1];
                                this.u[i9][j6] = t6;
                                ++i9;
                            }
                        }
                        ++j6;
                    }
                    this.e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k3] <= 0.0) {
                        double d = this.s[k3] = this.s[k3] < 0.0 ? -this.s[k3] : 0.0;
                        if (createV) {
                            int i10 = 0;
                            while (i10 <= pp) {
                                this.v[i10][k3] = -this.v[i10][k3];
                                ++i10;
                            }
                        }
                    }
                    while (k3 < pp) {
                        int i11;
                        if (this.s[k3] >= this.s[k3 + 1]) break;
                        double t7 = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t7;
                        if (createV && k3 < this.n - 1) {
                            i11 = 0;
                            while (i11 < this.n) {
                                t7 = this.v[i11][k3 + 1];
                                this.v[i11][k3 + 1] = this.v[i11][k3];
                                this.v[i11][k3] = t7;
                                ++i11;
                            }
                        }
                        if (createU && k3 < this.m - 1) {
                            i11 = 0;
                            while (i11 < this.m) {
                                t7 = this.u[i11][k3 + 1];
                                this.u[i11][k3 + 1] = this.u[i11][k3];
                                this.u[i11][k3] = t7;
                                ++i11;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public double[][] getU() {
        return this.u;
    }

    public double[][] getV() {
        return this.v;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.s.length) {
            if (this.s[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }
}

