/*
 * Decompiled with CFR 0.152.
 */
package e3d.utils;

import e3d.bezier.Needle;
import e3d.bezier.PointMesh;
import e3d.bezier.Position;
import e3d.euclidean.E3DTangent;
import e3d.euclidean.E3DVector;
import e3d.numbers.Quaternion;
import e3d.visualization.mesh.E3DMeshPoint;

public abstract class ObjectFactory<Value> {
    public static final ObjectFactory<Integer> INTEGER = new ObjectFactory<Integer>(){

        @Override
        public Integer create() {
            return 0;
        }
    };
    public static final ObjectFactory<Long> LONG = new ObjectFactory<Long>(){

        @Override
        public Long create() {
            return 0L;
        }
    };
    public static final ObjectFactory<Float> FLOAT = new ObjectFactory<Float>(){

        @Override
        public Float create() {
            return Float.valueOf(0.0f);
        }
    };
    public static final ObjectFactory<Double> DOUBLE = new ObjectFactory<Double>(){

        @Override
        public Double create() {
            return 0.0;
        }
    };
    public static final ObjectFactory<Boolean> BOOLEAN = new ObjectFactory<Boolean>(){

        @Override
        public Boolean create() {
            return false;
        }
    };
    public static final ObjectFactory<String> STRING = new ObjectFactory<String>(){

        @Override
        public String create() {
            return "";
        }
    };
    public static final ObjectFactory<Quaternion> QUATERNION = new ObjectFactory<Quaternion>(){

        @Override
        public Quaternion create() {
            return new Quaternion();
        }
    };
    public static final ObjectFactory<E3DVector> VECTOR3D = new ObjectFactory<E3DVector>(){

        @Override
        public E3DVector create() {
            return new E3DVector();
        }
    };
    public static final ObjectFactory<E3DTangent> TANGENT = new ObjectFactory<E3DTangent>(){

        @Override
        public E3DTangent create() {
            return new E3DTangent();
        }
    };
    public static final ObjectFactory<Position> POSITION = new ObjectFactory<Position>(){

        @Override
        public Position create() {
            return new Position();
        }
    };
    public static final ObjectFactory<Needle> NEEDLE = new ObjectFactory<Needle>(){

        @Override
        public Needle create() {
            return new Needle();
        }
    };
    public static final ObjectFactory<E3DMeshPoint> MESHPOINT = new ObjectFactory<E3DMeshPoint>(){

        @Override
        public E3DMeshPoint create() {
            return new E3DMeshPoint();
        }
    };
    public static final ObjectFactory<PointMesh> TENSIONMESH = new ObjectFactory<PointMesh>(){

        @Override
        public PointMesh create() {
            return new PointMesh();
        }
    };

    public abstract Value create();
}

