/*
 * Decompiled with CFR 0.152.
 */
package e3d.utils;

public class MathUtils {
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double PI2 = Math.PI * 2;
    public static final double PI05 = 1.5707963267948966;
    public static final double PI025 = 0.7853981633974483;

    public static double max(double ... v) {
        double max = v[0];
        int i = 1;
        while (i < v.length) {
            max = Math.max(max, v[i]);
            ++i;
        }
        return max;
    }

    public static double absMax(double ... v) {
        double max = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            max = Math.max(max, Math.abs(v[i]));
            ++i;
        }
        return max;
    }

    public static int maxIndex(double ... v) {
        int maxI = 0;
        double max = v[0];
        int i = 1;
        while (i < v.length) {
            if (v[i] > max) {
                max = v[i];
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static int maxAbsIndex(double ... v) {
        int maxI = 0;
        double max = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            if (Math.abs(v[i]) > max) {
                max = Math.abs(v[i]);
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static int maxInt(int ... v) {
        int max = v[0];
        int i = 1;
        while (i < v.length) {
            max = Math.max(max, v[i]);
            ++i;
        }
        return max;
    }

    public static int absMaxInt(int ... v) {
        int max = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            max = Math.max(max, Math.abs(v[i]));
            ++i;
        }
        return max;
    }

    public static int maxIntIndex(int ... v) {
        int maxI = 0;
        int max = v[0];
        int i = 1;
        while (i < v.length) {
            if (v[i] > max) {
                max = v[i];
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static int absMaxIntIndex(int ... v) {
        int maxI = 0;
        int max = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            if (Math.abs(v[i]) > max) {
                max = Math.abs(v[i]);
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static double min(double ... v) {
        double min = v[0];
        int i = 1;
        while (i < v.length) {
            min = Math.min(min, v[i]);
            ++i;
        }
        return min;
    }

    public static double absMin(double ... v) {
        double min = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            min = Math.min(min, Math.abs(v[i]));
            ++i;
        }
        return min;
    }

    public static int minIndex(double ... v) {
        int minI = 0;
        double min = v[0];
        int i = 1;
        while (i < v.length) {
            if (v[i] < min) {
                min = v[i];
                minI = i;
            }
            ++i;
        }
        return minI;
    }

    public static int minAbsIndex(double ... v) {
        int minI = 0;
        double min = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            if (Math.abs(v[i]) < min) {
                min = Math.abs(v[i]);
                minI = i;
            }
            ++i;
        }
        return minI;
    }

    public static int minInt(int ... v) {
        int min = v[0];
        int i = 1;
        while (i < v.length) {
            min = Math.min(min, v[i]);
            ++i;
        }
        return min;
    }

    public static int absMinInt(int ... v) {
        int min = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            min = Math.min(min, Math.abs(v[i]));
            ++i;
        }
        return min;
    }

    public static int minIntIndex(int ... v) {
        int maxI = 0;
        int max = v[0];
        int i = 1;
        while (i < v.length) {
            if (v[i] < max) {
                max = v[i];
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static int absMinIntIndex(int ... v) {
        int maxI = 0;
        int max = Math.abs(v[0]);
        int i = 1;
        while (i < v.length) {
            if (Math.abs(v[i]) < max) {
                max = Math.abs(v[i]);
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static double sum(double ... v) {
        double sum = 0.0;
        int i = 0;
        while (i < v.length) {
            sum += v[i];
            ++i;
        }
        return sum;
    }

    public static int sumInt(int ... v) {
        int sum = 0;
        int i = 0;
        while (i < v.length) {
            sum += v[i];
            ++i;
        }
        return sum;
    }

    public static double product(double ... v) {
        double product = 1.0;
        int i = 0;
        while (i < v.length) {
            product *= v[i];
            ++i;
        }
        return product;
    }

    public static int productInt(int ... v) {
        int product = 1;
        int i = 0;
        while (i < v.length) {
            product *= v[i];
            ++i;
        }
        return product;
    }

    public static double avg(double ... v) {
        return MathUtils.sum(v) / (double)v.length;
    }

    public static double div0(double a, double b) {
        if (a == 0.0) {
            return 0.0;
        }
        return a / b;
    }

    public static double log2(double v) {
        return Math.log(v) / Math.log(2.0);
    }

    public static double square(double v) {
        return v * v;
    }

    public static int signum(double v) {
        return v < 0.0 ? -1 : (v > 0.0 ? 1 : 0);
    }

    public static double hypot(double a, double b) {
        if (Math.abs(a) > Math.abs(b)) {
            double r = b / a;
            return Math.abs(a) * Math.sqrt(1.0 + r * r);
        }
        if (b != 0.0) {
            double r = a / b;
            return Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return 0.0;
    }

    public static double decimals(double a) {
        return a - Math.floor(a);
    }

    public static double gauss(double x, double mean, double var) {
        if (var == 0.0) {
            return x == mean ? Double.POSITIVE_INFINITY : 0.0;
        }
        return Math.exp(-Math.pow(x - mean, 2.0) / (2.0 * var)) / Math.sqrt(Math.PI * 2 * var);
    }

    public static double normGauss(double x, double mean, double var) {
        if (var == 0.0) {
            return x == mean ? 1 : 0;
        }
        return Math.exp(-Math.pow(x - mean, 2.0) / (2.0 * var));
    }

    public static double mean(int a, int b, double ... values) {
        double sum = 0.0;
        int i = a;
        while (i <= b) {
            sum += values[i];
            ++i;
        }
        return sum / (double)values.length;
    }

    public static double var(int a, int b, double mean, double ... values) {
        double sqDiff = 0.0;
        int i = a;
        while (i <= b) {
            sqDiff += MathUtils.square(mean - values[i]);
            ++i;
        }
        return sqDiff / (double)values.length;
    }

    public static double std(int a, int b, double mean, double ... values) {
        return Math.sqrt(MathUtils.var(a, b, mean, values));
    }
}

