/*
 * Decompiled with CFR 0.152.
 */
package e3d.typewriter;

import e3d.bezier.Position;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DRotation;
import java.util.List;

public class E3DCharacterSegment {
    protected static final double EPS = 1.0E-8;
    protected static final E3DVector RANDOMVECTOR = new E3DVector(Math.random(), Math.random(), Math.random());
    protected final List<E3DVector> points;

    public E3DCharacterSegment(List<E3DVector> points) {
        this.points = points;
    }

    public E3DVector direction(int from, int to) {
        E3DVector direction = this.points.get(to).diff(this.points.get(from));
        direction.norm();
        return direction;
    }

    public E3DVector[] directions() {
        E3DVector[] directions = new E3DVector[this.points.size() - 1];
        int i = 1;
        while (i < this.points.size()) {
            directions[i - 1] = this.direction(i - 1, i);
            ++i;
        }
        return directions;
    }

    public E3DVector middle(int from, int to) {
        E3DVector middle = this.points.get(to).sum(this.points.get(from));
        middle.divide(2.0);
        return middle;
    }

    public E3DVector[] middles() {
        E3DVector[] middles = new E3DVector[this.points.size() - 1];
        int i = 1;
        while (i < this.points.size()) {
            middles[i - 1] = this.middle(i - 1, i);
            ++i;
        }
        return middles;
    }

    public E3DVector[] normals(E3DVector[] directions, int adjustDirection) {
        E3DVector[] normals = new E3DVector[this.points.size()];
        normals[0] = directions[0];
        normals[normals.length - 1] = directions[directions.length - 1];
        int i = 1;
        while (i < normals.length - 1) {
            normals[i] = new E3DVector(directions[i - 1]);
            if (adjustDirection > 0) {
                normals[i].along(directions[i]);
            } else if (adjustDirection < 0) {
                normals[i].oppose(directions[i]);
            }
            normals[i].add(directions[i]);
            normals[i].divide(2.0);
            if (adjustDirection != 0 && Math.abs(normals[i].x) <= 1.0E-8 && Math.abs(normals[i].y) <= 0.0 && Math.abs(normals[i].z) <= 0.0) {
                normals[i] = new E3DVector(directions[i - 1]);
                normals[i].cross(RANDOMVECTOR);
            }
            ++i;
        }
        return normals;
    }

    protected Position[] radialPoints(double radius, double indent, E3DVector center, E3DVector direction, int n) {
        Position[] radialPoints = new Position[n];
        E3DRotation spin = new E3DRotation(direction, false, false, false);
        int i = 0;
        while (i < n) {
            double angle = Math.PI * 2 / (double)n * (double)i;
            double r = i % 2 == 0 ? radius : radius + indent;
            Position point = new Position(Math.sin(angle) * r, Math.cos(angle) * r, 0.0);
            spin.transform(point);
            point.add(center);
            radialPoints[i] = point;
            ++i;
        }
        return radialPoints;
    }

    protected E3DVector[] normals4RadialPoints(E3DVector[] radialPoints, E3DVector center) {
        E3DVector[] normals4RadialPoints = new E3DVector[radialPoints.length];
        int i = 0;
        while (i < radialPoints.length) {
            normals4RadialPoints[i] = radialPoints[i].diff(center);
            ++i;
        }
        return normals4RadialPoints;
    }
}

