/*
 * Decompiled with CFR 0.152.
 */
package e3d.typewriter;

import e3d.bezier.Bezier;
import e3d.bezier.Needle;
import e3d.bezier.Surfaces;
import e3d.euclidean.E3DVector;
import e3d.typewriter.E3DCharacter;
import e3d.typewriter.E3DCharacterSegment;
import e3d.typewriter.E3DFont;
import java.util.Vector;

public class E3DBubbleFont
extends E3DFont {
    public static final int BUBBLES = 1;
    public static final int PEARLS = 2;
    protected final int type;

    public E3DBubbleFont(int type) {
        this.type = type;
    }

    @Override
    public int getLongitudinalSurfacesPerSegment() {
        return 2;
    }

    @Override
    public int getRadialSurfacesPerSegment() {
        return this.radialPoints;
    }

    @Override
    public Surfaces asBezierMeshs() {
        Surfaces textBeziers = new Surfaces();
        double xOffset = 0.0;
        for (E3DCharacter character : this.characters) {
            Surfaces characterBeziers = new Surfaces();
            Vector<Needle> corners = new Vector<Needle>();
            double xMin = Double.MAX_VALUE;
            double xMax = Double.MIN_VALUE;
            for (E3DCharacterSegment segment : character.getSegments()) {
                E3DVector[] middles = segment.middles();
                E3DVector[] directions = segment.directions();
                E3DVector[] normals = segment.normals(directions, this.type == 2 ? -1 : 0);
                int i = 1;
                while (i < normals.length) {
                    E3DVector[] radialPoints = segment.radialPoints(this.boldness, this.indent, middles[i - 1], directions[i - 1], this.radialPoints);
                    E3DVector[] normalPoints = segment.normals4RadialPoints(radialPoints, middles[i - 1]);
                    int j = 0;
                    while (j < this.radialPoints) {
                        Needle c1 = new Needle(radialPoints[j], normalPoints[j]);
                        Needle c2 = new Needle(radialPoints[(j + 1) % this.radialPoints], normalPoints[(j + 1) % this.radialPoints]);
                        Needle c3 = new Needle(segment.points.get(i - 1), normals[i - 1]);
                        Needle c4 = new Needle(segment.points.get(i), normals[i]);
                        Bezier bezier1233 = new Bezier(c3, c3, c2, c1, 1.0, 1.0, 1.0, 1.0, this.color, null, null);
                        Bezier bezier1244 = new Bezier(c1, c2, c4, c4, 1.0, 1.0, 1.0, 1.0, this.color, null, null);
                        characterBeziers.add(bezier1233);
                        characterBeziers.add(bezier1244);
                        corners.add(c1);
                        corners.add(c2);
                        corners.add(c3);
                        corners.add(c4);
                        xMin = Math.min(xMin, Math.min(Math.min(c1.point.x, c2.point.x), Math.min(c3.point.x, c4.point.x)));
                        xMax = Math.max(xMax, Math.max(Math.max(c1.point.x, c2.point.x), Math.max(c3.point.x, c4.point.x)));
                        ++j;
                    }
                    ++i;
                }
            }
            if (xMin < Double.MAX_VALUE) {
                xOffset -= xMin;
                for (Needle corner : corners) {
                    corner.point.add(new E3DVector(xOffset, 0.0, 0.0));
                }
                xOffset += xMax + this.horizontalSpacing;
                textBeziers.addAll(characterBeziers);
                continue;
            }
            xOffset += character.getMinWidth() + this.horizontalSpacing;
        }
        return textBeziers;
    }
}

