/*
 * Decompiled with CFR 0.152.
 */
package e3d.numbers;

import e3d.euclidean.E3DVector;
import e3d.numbers.ComplexNumber;
import e3d.numbers.E3DNumber;

public class Quaternion
implements E3DNumber {
    public double r;
    public double i;
    public double j;
    public double k;

    public Quaternion() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    public Quaternion(double a) {
        this.set(a);
    }

    public Quaternion(Quaternion q) {
        this.set(q);
    }

    public Quaternion(double r, double i, double j, double k) {
        this.set(r, i, j, k);
    }

    public Quaternion(ComplexNumber c1, ComplexNumber c2) {
        this.set(c1, c2);
    }

    @Override
    public Quaternion clone() {
        return new Quaternion(this);
    }

    @Override
    public Quaternion origin() {
        return new Quaternion(0.0, 0.0, 0.0, 0.0);
    }

    public Quaternion quaternion(double r) {
        return new Quaternion(r);
    }

    public Quaternion quaternion(double r, double i, double j, double k) {
        return new Quaternion(r, i, j, k);
    }

    public Quaternion quaternion(Quaternion quaternion) {
        return new Quaternion(quaternion);
    }

    public Quaternion quaternion(ComplexNumber c1, ComplexNumber c2) {
        return new Quaternion(c1, c2);
    }

    @Override
    public boolean isValid() {
        return !Double.isNaN(this.r) && !Double.isNaN(this.i) && !Double.isNaN(this.j) && !Double.isNaN(this.k);
    }

    @Override
    public void set(E3DNumber n) {
        Quaternion q = (Quaternion)n;
        this.r = q.r;
        this.i = q.i;
        this.j = q.j;
        this.k = q.k;
    }

    @Override
    public void set(double a) {
        this.r = a;
        this.i = 0.0;
        this.j = 0.0;
        this.k = 0.0;
    }

    public void set(double r, double i, double j, double k) {
        this.r = r;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public void set(ComplexNumber complex1, ComplexNumber complex2) {
        this.r = (complex1.real() + complex2.real()) / 2.0;
        this.i = (complex1.imaginary() + complex2.imaginary()) / 2.0;
        this.j = (complex1.imaginary() - complex2.imaginary()) / 2.0;
        this.k = (complex2.real() - complex1.real()) / 2.0;
    }

    @Override
    public void setAll(double value) {
        this.j = this.k = value;
        this.i = this.k;
        this.r = this.k;
    }

    @Override
    public void put(E3DVector vector) {
        vector.x = this.r;
        vector.y = this.i;
        vector.z = this.j;
    }

    public boolean isReal() {
        return this.i == 0.0 && this.j == 0.0 && this.k == 0.0;
    }

    public double real() {
        return this.r;
    }

    public double imagI() {
        return this.i;
    }

    public double imagJ() {
        return this.j;
    }

    public double imagK() {
        return this.k;
    }

    public ComplexNumber split1() {
        return new ComplexNumber(this.r - this.k, this.i + this.j);
    }

    public ComplexNumber split2() {
        return new ComplexNumber(this.r + this.k, this.i - this.j);
    }

    @Override
    public double length() {
        return Math.sqrt(this.r * this.r + this.i * this.i + this.j * this.j + this.k * this.k);
    }

    @Override
    public double dist(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        return Math.sqrt((this.r - q.r) * (this.r - q.r) + (this.i - q.i) * (this.i - q.i) + (this.j - q.j) * (this.j - q.j) + (this.k - q.k) * (this.k - q.k));
    }

    @Override
    public double squaredLength() {
        return this.r * this.r + this.i * this.i + this.j * this.j + this.k * this.k;
    }

    @Override
    public double squaredDist(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        return (this.r - q.r) * (this.r - q.r) + (this.i - q.i) * (this.i - q.i) + (this.j - q.j) * (this.j - q.j) + (this.k - q.k) * (this.k - q.k);
    }

    @Override
    public void mean(E3DNumber a, E3DNumber b) {
        Quaternion u = (Quaternion)a;
        Quaternion v = (Quaternion)b;
        this.set((u.r + v.r) / 2.0, (u.i + v.i) / 2.0, (u.j + v.j) / 2.0, (u.k + v.k) / 2.0);
    }

    @Override
    public E3DNumber[] neighbors(double offset) {
        return new E3DNumber[]{this.quaternion(this.r - offset, this.i, this.j, this.k), this.quaternion(this.r + offset, this.i, this.j, this.k), this.quaternion(this.r, this.i - offset, this.j, this.k), this.quaternion(this.r, this.i + offset, this.j, this.k), this.quaternion(this.r, this.i, this.j - offset, this.k), this.quaternion(this.r, this.i, this.j + offset, this.k), this.quaternion(this.r, this.i, this.j, this.k - offset), this.quaternion(this.r, this.i, this.j, this.k + offset)};
    }

    @Override
    public E3DNumber[] positiveNeighbors(double offset) {
        return new E3DNumber[]{this.quaternion(this.r + offset, this.i, this.j, this.k), this.quaternion(this.r, this.i + offset, this.j, this.k), this.quaternion(this.r, this.i, this.j + offset, this.k), this.quaternion(this.r, this.i, this.j, this.k + offset)};
    }

    @Override
    public E3DNumber[] negativeNeighbors(double offset) {
        return new E3DNumber[]{this.quaternion(this.r - offset, this.i, this.j, this.k), this.quaternion(this.r, this.i - offset, this.j, this.k), this.quaternion(this.r, this.i, this.j - offset, this.k), this.quaternion(this.r, this.i, this.j, this.k - offset)};
    }

    @Override
    public void mirror(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        double dot = q.r * this.r + q.i * this.i + q.j * this.j + q.k * this.k;
        if (dot != 0.0) {
            double u = -2.0 * dot / q.squaredLength();
            this.r += u * q.r;
            this.i += u * q.i;
            this.j += u * q.j;
            this.k += u * q.k;
        }
    }

    @Override
    public double angle(E3DNumber number) {
        return Math.acos(this.cosinus(number));
    }

    @Override
    public double cosinus(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        double dot = q.r * this.r + q.i * this.i + q.j * this.j + q.k * this.k;
        return dot / (this.length() * q.length());
    }

    @Override
    public void plus(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        this.set(this.r + q.r, this.i + q.i, this.j + q.j, this.k + q.k);
    }

    @Override
    public void plus(double number) {
        this.set(this.r + number, this.i, this.j, this.k);
    }

    @Override
    public void minus(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        this.set(this.r - q.r, this.i - q.i, this.j - q.j, this.k - q.k);
    }

    @Override
    public void minus(double number) {
        this.set(this.r - number, this.i, this.j, this.k);
    }

    @Override
    public void times(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        this.set(this.r * q.r - this.i * q.i - this.j * q.j - this.k * q.k, this.r * q.i + this.i * q.r + this.j * q.k - this.k * q.j, this.r * q.j + this.j * q.r + this.k * q.i - this.i * q.k, this.r * q.k + this.k * q.r + this.i * q.j - this.j * q.i);
    }

    @Override
    public void times(double number) {
        this.set(this.r * number, this.i * number, this.j * number, this.k * number);
    }

    @Override
    public void semit(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        this.set(q.r * this.r - q.i * this.i - q.j * this.j - q.k * this.k, q.r * this.i + q.i * this.r + q.j * this.k - q.k * this.j, q.r * this.j + q.j * this.r + q.k * this.i - q.i * this.k, q.r * this.k + q.k * this.r + q.i * this.j - q.j * this.i);
    }

    @Override
    public void divide(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        double xw = Math.sqrt(q.r) - Math.sqrt(q.k);
        double yz = Math.sqrt(q.i) - Math.sqrt(q.j);
        this.set((this.r * q.r - this.k * q.k) / xw + (this.i * q.i - this.j * q.j) / yz, (this.i * q.r + this.j * q.k) / xw - (this.r * q.i + this.k * q.j) / yz, (this.r * q.j + this.k * q.i) / yz + (this.i * q.k + this.j * q.r) / xw, (this.i * q.j - this.j * q.i) / yz - (this.r * q.k - this.k * q.r) / yz);
    }

    @Override
    public void divide(double number) {
        this.set(this.r / number, this.i / number, this.j / number, this.k / number);
    }

    @Override
    public Quaternion sum(E3DNumber number) {
        Quaternion quaternion = this.clone();
        quaternion.plus(number);
        return quaternion;
    }

    @Override
    public Quaternion sum(double number) {
        Quaternion quaternion = this.clone();
        quaternion.plus(number);
        return quaternion;
    }

    @Override
    public Quaternion diff(E3DNumber number) {
        Quaternion quaternion = this.clone();
        quaternion.minus(number);
        return quaternion;
    }

    @Override
    public Quaternion diff(double number) {
        Quaternion quaternion = this.clone();
        quaternion.minus(number);
        return quaternion;
    }

    @Override
    public Quaternion product(E3DNumber number) {
        Quaternion quaternion = this.clone();
        quaternion.times(number);
        return quaternion;
    }

    @Override
    public Quaternion product(double number) {
        Quaternion quaternion = this.clone();
        quaternion.times(number);
        return quaternion;
    }

    @Override
    public Quaternion quotient(E3DNumber number) {
        Quaternion quaternion = this.clone();
        quaternion.divide(number);
        return quaternion;
    }

    @Override
    public Quaternion quotient(double number) {
        Quaternion quaternion = this.clone();
        quaternion.divide(number);
        return quaternion;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Quaternion)) {
            return false;
        }
        return this.r == ((Quaternion)object).r && this.i == ((Quaternion)object).i && this.j == ((Quaternion)object).j && this.k == ((Quaternion)object).k;
    }

    public int hashCode() {
        return Double.valueOf(this.r).hashCode() + Double.valueOf(this.i).hashCode() + Double.valueOf(this.j).hashCode() + Double.valueOf(this.k).hashCode();
    }

    public double absolute() {
        return this.length();
    }

    public Quaternion conjugate() {
        return this.quaternion(this.r, -this.i, -this.j, -this.k);
    }

    @Override
    public Quaternion sinus() {
        if (this.isReal()) {
            return this.quaternion(Math.sin(this.r));
        }
        double length = Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        double sinus = Math.sin(this.r);
        double cosinus = Math.cos(this.r);
        double reciprocal = 1.0 / length;
        double exp0 = Math.exp(-length);
        double exp1 = Math.exp(length);
        double c0 = -0.5 * exp0 * reciprocal * cosinus;
        double c1 = 0.5 * exp1 * reciprocal * cosinus;
        Quaternion p = this.quaternion(0.5 * exp0 * sinus, c0 * this.i, c0 * this.j, c0 * this.k);
        Quaternion q = this.quaternion(0.5 * exp1 * sinus, c1 * this.i, c1 * this.j, c1 * this.k);
        return p.sum(q);
    }

    @Override
    public Quaternion cosinus() {
        if (this.isReal()) {
            return this.quaternion(Math.cos(this.r));
        }
        double length = Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        double sinus = Math.sin(this.r);
        double cosinus = Math.cos(this.r);
        double reciprocal = 1.0 / length;
        double exp0 = Math.exp(-length);
        double exp1 = Math.exp(length);
        double c0 = 0.5 * exp0 * reciprocal * sinus;
        double c1 = -0.5 * exp1 * reciprocal * sinus;
        Quaternion p = this.quaternion(0.5 * exp0 * cosinus, c0 * this.i, c0 * this.j, c0 * this.k);
        Quaternion q = this.quaternion(0.5 * exp1 * cosinus, c1 * this.i, c1 * this.j, c1 * this.k);
        return p.sum(q);
    }

    @Override
    public Quaternion exponent() {
        if (this.isReal()) {
            return this.quaternion(Math.exp(this.r));
        }
        double length = Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        double sinus = Math.sin(length);
        double cosinus = Math.cos(length);
        double exp = Math.exp(this.r);
        double t = exp * sinus / length;
        return this.quaternion(exp * cosinus, t * this.i, t * this.j, t * this.k);
    }

    @Override
    public Quaternion logarithmNaturalis() {
        if (this.isReal()) {
            if (this.r > 0.0) {
                return this.quaternion(Math.log(this.r));
            }
            if (this.r < 0.0) {
                return this.quaternion(Math.log(-this.r), Math.PI, 0.0, 0.0);
            }
            return this.quaternion(0.0);
        }
        double length = Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        double a = Math.sqrt(length * length + this.r * this.r);
        double theta = Math.atan2(length, this.r);
        double t = theta / length;
        return this.quaternion(Math.log(a), t * this.i, t * this.j, t * this.k);
    }

    @Override
    public Quaternion power(E3DNumber number) {
        Quaternion quaternion = (Quaternion)number;
        return this.quaternion(quaternion.product(this.logarithmNaturalis()).exponent());
    }

    @Override
    public Quaternion power(double number) {
        return this.quaternion(this.logarithmNaturalis().product(number).exponent());
    }

    @Override
    public Quaternion squareRoot() {
        if (this.isReal()) {
            if (this.r >= 0.0) {
                return this.quaternion(Math.sqrt(this.r), 0.0, 0.0, 0.0);
            }
            return this.quaternion(0.0, Math.sqrt(-this.r), 0.0, 0.0);
        }
        double a = Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        double b = Math.sqrt(this.r * this.r + a * a);
        if (this.r >= 0.0) {
            double m = Math.sqrt(0.5 * (b + this.r));
            double l = a / (2.0 * m);
            double t = l / a;
            return this.quaternion(m, this.i * t, this.j * t, this.k * t);
        }
        double l = Math.sqrt(0.5 * (b - this.r));
        double m = a / (2.0 * l);
        double t = l / a;
        return this.quaternion(m, this.i * t, this.j * t, this.k * t);
    }

    @Deprecated
    public void splitTimes(E3DNumber number) {
        Quaternion q = (Quaternion)number;
        double pr1 = this.r - this.k;
        double pi1 = this.i + this.j;
        double pr2 = this.r + this.k;
        double pi2 = this.i - this.j;
        double qr1 = q.r - q.k;
        double qi1 = q.i + q.j;
        double qr2 = q.r + q.k;
        double qi2 = q.i - q.j;
        double r1 = pr1 * qr1 - pi1 * qi1;
        double i1 = pr1 * qi1 + pi1 * qr1;
        double r2 = pr2 * qr2 - pi2 * qi2;
        double i2 = pr2 * qi2 + pi2 * qr2;
        this.r = (r1 + r2) / 2.0;
        this.i = (i1 + i2) / 2.0;
        this.j = (i1 - i2) / 2.0;
        this.k = (r2 - r1) / 2.0;
    }

    @Deprecated
    public Quaternion splitSin() {
        return this.quaternion(this.split1().sinus(), this.split2().sinus());
    }

    @Deprecated
    public Quaternion splitSinH() {
        return this.quaternion(this.split1().sinusHyperbolicus(), this.split2().sinusHyperbolicus());
    }

    @Deprecated
    public Quaternion splitCos() {
        return this.quaternion(this.split1().cosinus(), this.split2().cosinus());
    }

    @Deprecated
    public Quaternion splitCosH() {
        return this.quaternion(this.split1().cosinusHyperbolicus(), this.split2().cosinusHyperbolicus());
    }

    @Deprecated
    public Quaternion splitCTan() {
        return this.quaternion(this.split1().cotangent(), this.split2().cotangent());
    }

    @Deprecated
    public Quaternion splitCTanH() {
        return this.quaternion(this.split1().cotangentHyperbolicus(), this.split2().cotangentHyperbolicus());
    }

    @Deprecated
    public Quaternion splitTan() {
        return this.quaternion(this.split1().tangent(), this.split2().tangent());
    }

    @Deprecated
    public Quaternion splitTanH() {
        return this.quaternion(this.split1().tangentHyperbolicus(), this.split2().tangentHyperbolicus());
    }

    @Deprecated
    public Quaternion splitExp() {
        return this.quaternion(this.split1().exponent(), this.split2().exponent());
    }

    @Deprecated
    public Quaternion splitLN() {
        return this.quaternion(this.split1().logarithmNaturalis(), this.split2().logarithmNaturalis());
    }

    @Deprecated
    public Quaternion splitPow(E3DNumber number) {
        return this.quaternion(this.split1().power(((Quaternion)number).split1()), this.split2().power(((Quaternion)number).split2()));
    }

    @Deprecated
    public Quaternion splitSqrt() {
        return this.quaternion(this.split1().squareRoot(), this.split2().squareRoot());
    }

    public String toString() {
        return String.format("%g, %g, %g, %g", this.r, this.i, this.j, this.k);
    }
}

