/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.util;

import e3d.visualization.image.E3DImageAWT;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;

public class J3DTextureUtils {
    public static Texture2D createTexture2D(File imageFile, boolean enabled, boolean horizontalMirror, boolean verticalMirror, boolean useMipMap) throws IOException {
        if (imageFile == null) {
            return null;
        }
        BufferedImage textureImage = ImageIO.read(imageFile);
        return J3DTextureUtils.createTexture2D(textureImage, enabled, horizontalMirror, verticalMirror, useMipMap);
    }

    public static Texture2D createTexture2D(BufferedImage image, boolean enabled, boolean horizontalMirror, boolean verticalMirror, boolean useMipMap) {
        if (image == null) {
            return null;
        }
        if (horizontalMirror) {
            new E3DImageAWT(image).mirrorHorizontal();
        }
        if (verticalMirror) {
            new E3DImageAWT(image).mirrorVertical();
        }
        ImageComponent2D[] imageComponents = J3DTextureUtils.createImageComponents2D(image, useMipMap);
        int mipMapMode = useMipMap ? 2 : 1;
        int minFilter = useMipMap ? 5 : 3;
        Texture2D texture = new Texture2D(mipMapMode, 6, imageComponents[0].getWidth(), imageComponents[0].getHeight());
        int level = 0;
        while (level < imageComponents.length) {
            texture.setImage(level, (ImageComponent)imageComponents[level]);
            ++level;
        }
        texture.setEnable(enabled);
        texture.setMinFilter(minFilter);
        texture.setMagFilter(3);
        texture.setBoundaryModeS(2);
        texture.setBoundaryModeT(2);
        texture.setCapability(4);
        texture.setCapability(7);
        texture.setCapability(1);
        texture.setUserData((Object)image);
        return texture;
    }

    private static ImageComponent2D[] createImageComponents2D(BufferedImage image, boolean useMipMap) {
        if (useMipMap) {
            int res2;
            int pow2;
            int size = Math.max(image.getWidth(), image.getHeight());
            int res1 = size - (1 << (pow2 = (int)(Math.log(size) / Math.log(2.0))));
            int maxLevel = res1 <= (res2 = (1 << pow2 + 1) - size) ? pow2 : pow2 + 1;
            ImageComponent2D[] imageComponents = new ImageComponent2D[maxLevel + 1];
            BufferedImage img = image;
            int level = 0;
            int len = 1 << maxLevel;
            while (level <= maxLevel) {
                img = new E3DImageAWT(img).scale(len, len).getBufferedImage();
                imageComponents[level] = new ImageComponent2D(2, img, true, true);
                imageComponents[level].setCapability(2);
                imageComponents[level].setCapability(3);
                ++level;
                len >>= 1;
            }
            return imageComponents;
        }
        ImageComponent2D[] imageComponents = new ImageComponent2D[]{new ImageComponent2D(2, image, true, true)};
        imageComponents[0].setCapability(2);
        imageComponents[0].setCapability(3);
        return imageComponents;
    }

    public static Texture3D createTexture3D(File[] imageFiles, boolean enabled, boolean horizontalMirror, boolean verticalMirror, boolean useMipMap) throws IOException {
        if (imageFiles == null || imageFiles.length == 0) {
            return null;
        }
        BufferedImage[] textureImages = new BufferedImage[imageFiles.length];
        int i = 0;
        while (i < imageFiles.length) {
            textureImages[i] = ImageIO.read(imageFiles[i]);
            ++i;
        }
        return J3DTextureUtils.createTexture3D(textureImages, enabled, horizontalMirror, verticalMirror, useMipMap);
    }

    public static Texture3D createTexture3D(BufferedImage[] images, boolean enabled, boolean horizontalMirror, boolean verticalMirror, boolean useMipMap) {
        if (images == null || images.length == 0) {
            return null;
        }
        BufferedImage[] bufferedImageArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            BufferedImage image = bufferedImageArray[n2];
            if (horizontalMirror) {
                new E3DImageAWT(image).mirrorHorizontal();
            }
            if (verticalMirror) {
                new E3DImageAWT(image).mirrorVertical();
            }
            ++n2;
        }
        ImageComponent3D[] imageComponents = J3DTextureUtils.createImageComponents3D(images, useMipMap);
        int mipMapMode = useMipMap ? 2 : 1;
        int minFilter = useMipMap ? 5 : 3;
        Texture3D texture = new Texture3D(mipMapMode, 6, imageComponents[0].getWidth(), imageComponents[0].getHeight(), imageComponents[0].getDepth());
        int level = 0;
        while (level < imageComponents.length) {
            texture.setImage(level, (ImageComponent)imageComponents[level]);
            ++level;
        }
        texture.setEnable(enabled);
        texture.setMinFilter(minFilter);
        texture.setMagFilter(3);
        texture.setBoundaryModeS(5);
        texture.setBoundaryModeT(5);
        texture.setBoundaryModeR(5);
        texture.setCapability(4);
        texture.setCapability(7);
        texture.setCapability(1);
        texture.setUserData((Object)images);
        return texture;
    }

    private static ImageComponent3D[] createImageComponents3D(BufferedImage[] images, boolean useMipMap) {
        if (useMipMap) {
            int res2;
            int pow2;
            int size = Math.max(images[0].getWidth(), images[0].getHeight());
            int res1 = size - (1 << (pow2 = (int)(Math.log(size) / Math.log(2.0))));
            int maxLevel = res1 <= (res2 = (1 << pow2 + 1) - size) ? pow2 : pow2 + 1;
            ImageComponent3D[] imageComponents = new ImageComponent3D[maxLevel + 1];
            BufferedImage[] imgs = images;
            int level = 0;
            int len = 1 << maxLevel;
            while (level <= maxLevel) {
                int i = 0;
                while (i < imgs.length) {
                    imgs[i] = new E3DImageAWT(imgs[i]).scale(len, len).getBufferedImage();
                    ++i;
                }
                imageComponents[level] = new ImageComponent3D(2, imgs, true, true);
                imageComponents[level].setCapability(2);
                imageComponents[level].setCapability(3);
                ++level;
                len >>= 1;
            }
            return imageComponents;
        }
        int i = 1;
        while (i < images.length) {
            images[i] = new E3DImageAWT(images[i]).scale(images[0].getWidth(), images[0].getHeight()).getBufferedImage();
            ++i;
        }
        ImageComponent3D[] imageComponents = new ImageComponent3D[]{new ImageComponent3D(2, images, true, true)};
        imageComponents[0].setCapability(2);
        imageComponents[0].setCapability(3);
        return imageComponents;
    }
}

