/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.util;

import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DSceneGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class J3DSceneView {
    protected static final Vector3d RANDOMVECTOR = new Vector3d(Math.random(), Math.random(), Math.random());
    protected final Vector3d direction;
    protected final Vector3d translation;
    protected double angle;

    public J3DSceneView(Vector3d direction, Vector3d translation, double angle) {
        this.direction = direction;
        this.translation = translation;
        this.angle = angle;
    }

    public J3DSceneView(J3DGroup scene) {
        Transform3D transformation = new Transform3D();
        scene.getAnchor().getTransform(transformation);
        this.direction = new Vector3d(0.0, 0.0, -10.0);
        Transform3D invers = new Transform3D();
        invers.invert(transformation);
        invers.transform(this.direction);
        this.direction.x = -this.direction.x;
        this.direction.y = -this.direction.y;
        this.translation = new Vector3d();
        transformation.get(this.translation);
        Transform3D unrotated = new Transform3D();
        Vector3d zNormal = new Vector3d(0.0, 0.0, -1.0);
        Vector3d axis = new Vector3d();
        axis.cross(zNormal, this.direction);
        unrotated.setRotation(new AxisAngle4d(axis, this.direction.angle(zNormal)));
        Vector3d yNormal1 = new Vector3d();
        Vector3d yNormal2 = this.orthogonal(this.direction);
        yNormal1.set((Tuple3d)yNormal2);
        transformation.transform(yNormal1);
        unrotated.transform(yNormal2);
        this.angle = this.angle2D(yNormal1, yNormal2);
    }

    public void setView(J3DSceneGroup scene, boolean recenter) {
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        if (recenter) {
            scene.untransformScene(center);
        }
        Transform3D oldTransform = new Transform3D();
        Vector3d normal = new Vector3d(0.0, 0.0, -1.0);
        Vector3d axis = new Vector3d();
        axis.cross(normal, this.direction);
        if (axis.lengthSquared() < 1.0E-6) {
            oldTransform.setRotation(new AxisAngle4d(new Vector3d(0.0, 1.0, 0.0), this.direction.z < 0.0 ? 0.0 : Math.PI));
        } else {
            oldTransform.setRotation(new AxisAngle4d(axis, this.direction.angle(normal)));
        }
        Transform3D newTransform = new Transform3D();
        newTransform.rotZ(this.angle);
        newTransform.mul(oldTransform);
        newTransform.setTranslation(this.translation);
        if (recenter) {
            newTransform.transform(center);
            this.translation.sub((Tuple3d)center);
            newTransform.setTranslation(this.translation);
        }
        scene.getAnchor().setTransform(newTransform);
        scene.updated();
    }

    public Vector3d getDirection() {
        return this.direction;
    }

    public Vector3d getTranslation() {
        return this.translation;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    private Vector3d orthogonal(Vector3d v) {
        Vector3d u = RANDOMVECTOR;
        Vector3d orthogonal = new Vector3d();
        orthogonal.cross(v, u);
        return orthogonal;
    }

    private double angle2D(Vector3d a, Vector3d b) {
        double angle = this.angle2D(a) - this.angle2D(b);
        if (angle < -Math.PI) {
            return angle + Math.PI * 2;
        }
        if (angle > Math.PI) {
            return angle - Math.PI * 2;
        }
        return angle;
    }

    private double angle2D(Vector3d v) {
        double angle = Math.acos(v.x / Math.sqrt(v.x * v.x + v.y * v.y));
        return v.y >= 0.0 ? angle : Math.PI * 2 - angle;
    }
}

