/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.util.J3DEventAdapter;
import e3d.j3d.util.J3DEventListener;
import e3d.j3d.util.J3DTextureUtils;
import e3d.utils.MathUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Vector3d;

public class J3DVolume
extends J3DObject {
    public static final int ROTATE_0_DEGREES = 0;
    public static final int ROTATE_90_DEGREES = 1;
    public static final int ROTATE_180_DEGREES = 2;
    public static final int ROTATE_270_DEGREES = 3;
    private static final Vector3d NO_TRANSLATION = new Vector3d(0.0, 0.0, 0.0);
    private static final Vector3d TEXTURE_TRANSLATION = new Vector3d(0.5, 0.5, 0.5);
    protected final Parameters parameters;
    protected Texture3D texture;
    protected final VolumeAnchor anchor;
    protected final SliceAppearance screenAppearance;
    protected final SliceAppearance sliceAppearance;
    protected final List<SliceShape> slices = new Vector<SliceShape>();
    private final NormalGenerator normalGenerator = new NormalGenerator();
    private final Stripifier stripifier = new Stripifier();
    private final J3DEventListener sceneListener = new J3DEventAdapter(){

        @Override
        public void updated(J3DInstance object) {
            J3DVolume.this.anchor.update();
        }

        @Override
        public void transformed(J3DInstance object, TransformGroup transformGroup, int type) {
            J3DVolume.this.anchor.update();
        }
    };

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DVolume(Point3d center, double width, double height, double depth, int resolution, int rotation, Parameters parameters) {
        this.parameters = parameters;
        this.transformation.setTranslation(new Vector3d(-center.x, -center.y, -center.z));
        this.screenAppearance = new SliceAppearance(parameters.screenColor, parameters.screenTransparency);
        this.sliceAppearance = new SliceAppearance(parameters.sliceColor, parameters.sliceTransparency);
        this.anchor = new VolumeAnchor(this.transformation);
        this.anchor.setCapability(14);
        this.anchor.setCapability(13);
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        this.anchor.setCapability(1);
        this.setPickable(true);
        this.setCapability(17);
        this.addChild((Node)this.anchor);
        int normalSlices = parameters.firstSliceAsScreen ? resolution - 1 : resolution;
        int index = 0;
        while (index < normalSlices) {
            Geometry geometry = this.createGeometry(width, height, depth, index, resolution, rotation, parameters.textureScale);
            SliceShape slice = new SliceShape(geometry, this.sliceAppearance);
            this.slices.add(slice);
            this.anchor.addChild((Node)slice);
            ++index;
        }
        if (parameters.firstSliceAsScreen) {
            Geometry geometry = this.createGeometry(width, height, depth, resolution - 1, resolution, rotation, 0.0f);
            SliceShape slice = new SliceShape(geometry, this.screenAppearance);
            this.slices.add(slice);
            this.anchor.addChild((Node)slice);
        }
        BufferedImage[] images = new BufferedImage[64];
        float dh = 0.015625f;
        Color c0 = new Color(255, 255, 255, 1);
        int i = 0;
        while (i < 64) {
            images[i] = new BufferedImage(64, 64, 2);
            Graphics2D g = images[i].createGraphics();
            g.setColor(c0);
            g.fillRect(0, 0, 64, 64);
            float h = dh * (float)i;
            Color c = Color.getHSBColor(h, 1.0f, 1.0f);
            g.setColor(c);
            int x = 24;
            int w = 16;
            g.fillOval(x, x, w, w);
            g.fillRect(x + 7, x + 16, 2, 15);
            ++i;
        }
        Texture3D texture = J3DTextureUtils.createTexture3D(images, true, false, false, false);
        this.setTexture(texture);
    }

    @Override
    public void recreate() {
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Texture3D getTexture() {
        return this.texture;
    }

    public void setTexture(Texture3D texture) {
        this.texture = texture;
        this.sliceAppearance.setTexture((Texture)texture);
    }

    @Override
    public void setGroup(J3DGroup group) {
        if (group != null) {
            group.getSceneGroup().addEventListener(this.sceneListener);
        } else if (this.group != null) {
            this.group.getSceneGroup().removeEventListener(this.sceneListener);
        }
        this.group = group;
        this.anchor.update();
    }

    @Override
    protected J3DAnchor getAnchor() {
        return null;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            if (this.group != null) {
                this.group.getAnchor().removeChild((Node)this);
                this.anchor.clearCapability(1);
                this.group.getAnchor().addChild((Node)this);
            }
            this.screenAppearance.getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
        } else {
            if (this.group != null) {
                this.group.getAnchor().removeChild((Node)this);
                this.anchor.setCapability(1);
                this.group.getAnchor().addChild((Node)this);
            }
            this.screenAppearance.getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
        }
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void movedOver(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.movedOver(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    @Override
    public void updated() {
        for (J3DEventListener listener : this.listeners) {
            listener.updated(this);
        }
        this.anchor.update();
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformed(this, this.anchor, type);
            }
        } else {
            this.anchor.update();
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformationFinished(this, this.anchor, type);
            }
        }
    }

    @Override
    public void reshape() {
    }

    protected Geometry createGeometry(double width, double height, double depth, int slice, int slices, int rotation, float scale) {
        double w = width / 2.0;
        double h = height / 2.0;
        double d = MathUtils.div0(slice, slices - 1) - 0.5;
        double z = d * depth;
        int vertexFormat = scale > 0.0f ? 65 : 1;
        QuadArray quadArray = new QuadArray(4, vertexFormat);
        quadArray.setCoordinate(0, new Point3d(-w, h, z));
        quadArray.setCoordinate(1, new Point3d(-w, -h, z));
        quadArray.setCoordinate(2, new Point3d(w, -h, z));
        quadArray.setCoordinate(3, new Point3d(w, h, z));
        if (scale > 0.0f) {
            float r = (float)d / scale;
            float st = 0.5f / scale;
            quadArray.setTextureCoordinate(0, (0 + rotation) % 4, new TexCoord3f(-st, st, r));
            quadArray.setTextureCoordinate(0, (1 + rotation) % 4, new TexCoord3f(-st, -st, r));
            quadArray.setTextureCoordinate(0, (2 + rotation) % 4, new TexCoord3f(st, -st, r));
            quadArray.setTextureCoordinate(0, (3 + rotation) % 4, new TexCoord3f(st, st, r));
        }
        return this.optimize(quadArray);
    }

    private Geometry optimize(QuadArray quadArray) {
        GeometryInfo geometryInfo = new GeometryInfo((GeometryArray)quadArray);
        this.normalGenerator.generateNormals(geometryInfo);
        geometryInfo.recomputeIndices();
        this.stripifier.stripify(geometryInfo);
        geometryInfo.recomputeIndices();
        return geometryInfo.getGeometryArray();
    }

    private J3DVolume getThis() {
        return this;
    }

    public static class Parameters {
        public boolean firstSliceAsScreen = true;
        public Color3f screenColor = new Color3f(0.5f, 0.5f, 0.5f);
        public float screenTransparency = 0.8f;
        public Color3f sliceColor = new Color3f(1.0f, 1.0f, 1.0f);
        public float sliceTransparency = 0.0f;
        public float textureScale = 1.0f / (float)Math.sqrt(3.0);
    }

    protected static class SliceAppearance
    extends Appearance {
        protected SliceAppearance(Color3f color, float transparancy) {
            Material material = new Material();
            material.setAmbientColor(color);
            material.setDiffuseColor(color);
            material.setSpecularColor(color);
            material.setShininess(64.0f);
            material.setCapability(1);
            ColoringAttributes coloring = new ColoringAttributes(color, 0);
            coloring.setCapability(1);
            TransparencyAttributes transparency = new TransparencyAttributes(1, transparancy);
            TextureAttributes texturing = new TextureAttributes();
            texturing.setTextureMode(2);
            texturing.setCapability(4);
            texturing.setCapability(5);
            PolygonAttributes polygon = new PolygonAttributes(2, 1, 0.0f);
            this.setPolygonAttributes(polygon);
            this.setColoringAttributes(coloring);
            this.setTextureAttributes(texturing);
            this.setTransparencyAttributes(transparency);
            this.setMaterial(material);
            this.setCapability(11);
            this.setCapability(2);
            this.setCapability(3);
            this.setCapability(4);
            this.setCapability(5);
        }
    }

    protected class SliceShape
    extends Shape3D
    implements J3DAtomicPart {
        protected SliceShape(SliceAppearance appearance) {
            this.setAppearance(appearance);
        }

        protected SliceShape(Geometry geometry, SliceAppearance appearance) {
            super(geometry);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DVolume.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DVolume.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DVolume.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(transparency == 0.0f ? 4 : 0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DVolume getObject() {
            return J3DVolume.this.getThis();
        }
    }

    protected class VolumeAnchor
    extends J3DAnchor {
        private final Matrix4d matrix = new Matrix4d();
        private final Vector3d translation = new Vector3d();
        private final Transform3D myTransform = new Transform3D();
        private final Transform3D texTransform = new Transform3D();
        private final Transform3D worldTransform = new Transform3D();

        protected VolumeAnchor() {
            this.update();
        }

        protected VolumeAnchor(Transform3D transformation) {
            this.setTransform(transformation);
            this.update();
        }

        @Override
        public void transformed(int type) {
            J3DVolume.this.getThis().transformed(this, type);
        }

        @Override
        public void transformationFinished(int type) {
            J3DVolume.this.getThis().transformationFinished(this, type);
        }

        public void getTransform(Transform3D transform) {
            J3DVolume.this.sliceAppearance.getTextureAttributes().getTextureTransform(transform);
            super.getTransform(this.myTransform);
            this.myTransform.get(this.matrix);
            this.translation.set(this.matrix.m03, this.matrix.m13, this.matrix.m23);
            transform.setTranslation(this.translation);
        }

        public void setTransform(Transform3D transform) {
            transform.get(this.matrix);
            this.translation.set(this.matrix.m03, this.matrix.m13, this.matrix.m23);
            this.myTransform.set(this.worldTransform);
            this.myTransform.setTranslation(this.translation);
            super.setTransform(this.myTransform);
            this.texTransform.set(transform);
            this.texTransform.setTranslation(TEXTURE_TRANSLATION);
            J3DVolume.this.sliceAppearance.getTextureAttributes().setTextureTransform(this.texTransform);
        }

        @Override
        public void getLocalToVworldRotation(Transform3D transform) {
            J3DVolume.this.sliceAppearance.getTextureAttributes().getTextureTransform(this.texTransform);
            this.texTransform.setTranslation(NO_TRANSLATION);
            this.texTransform.invert();
            super.getLocalToVworld(transform);
            transform.mul(transform, this.worldTransform);
            transform.mul(transform, this.texTransform);
        }

        protected void update() {
            if (this.getParent() != null) {
                J3DVolume.this.sliceAppearance.getTextureAttributes().getTextureTransform(this.texTransform);
                this.texTransform.mul(this.texTransform, this.worldTransform);
                this.getLocalToVworld(this.worldTransform);
                this.worldTransform.setTranslation(NO_TRANSLATION);
                this.texTransform.mul(this.texTransform, this.worldTransform);
                this.texTransform.setTranslation(TEXTURE_TRANSLATION);
                J3DVolume.this.sliceAppearance.getTextureAttributes().setTextureTransform(this.texTransform);
                this.worldTransform.invert();
                super.getTransform(this.myTransform);
                this.myTransform.get(this.matrix);
                this.translation.set(this.matrix.m03, this.matrix.m13, this.matrix.m23);
                this.myTransform.set(this.worldTransform);
                this.myTransform.setTranslation(this.translation);
                super.setTransform(this.myTransform);
            }
        }
    }
}

