/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.bezier.Needle;
import e3d.euclidean.E3DVector;
import e3d.j3d.objects.J3DCenteredObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.util.J3DEventListener;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public abstract class J3DTangent
extends J3DCenteredObject {
    protected final Needle tangent;
    protected final TangentAnchor anchor;

    public J3DTangent(Needle tangent, boolean pickable) {
        this.tangent = tangent;
        this.anchor = new TangentAnchor(this.transformation);
        this.anchor.setCapability(14);
        this.anchor.setCapability(13);
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        this.anchor.setCapability(6);
        this.anchor.setCapability(5);
        if (pickable) {
            this.anchor.setCapability(1);
            this.setPickable(true);
        }
        this.setCapability(17);
        this.addChild((Node)this.anchor);
    }

    @Override
    public E3DVector getCenter() {
        return this.tangent.point;
    }

    public Needle getTangent() {
        return this.tangent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTangent(Needle tangent) {
        TangentAnchor tangentAnchor = this.anchor;
        synchronized (tangentAnchor) {
            this.tangent.set(tangent);
            this.reshape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroup(J3DGroup group) {
        TangentAnchor tangentAnchor = this.anchor;
        synchronized (tangentAnchor) {
            this.group = group;
            this.anchor.setTransform(this.createTransformation(this.tangent));
        }
    }

    @Override
    public J3DAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    public void updated() {
        this.update();
        for (J3DEventListener listener : this.listeners) {
            listener.updated(this);
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        this.update();
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformed(this, transformedAnchor, type);
            }
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        TangentAnchor tangentAnchor = this.anchor;
        synchronized (tangentAnchor) {
            Point3d point = new Point3d(0.0, 0.0, 0.0);
            Vector3d normal = new Vector3d(0.0, 1.0, 0.0);
            this.anchor.getTransform(this.transformation);
            this.transformation.transform(point);
            this.transformation.transform(normal);
            if (this.group != null) {
                this.group.transform(point);
                this.group.transform(normal);
            }
            this.tangent.point.set(point.x, point.y, point.z);
            this.tangent.normal.set(normal.x, normal.y, normal.z);
        }
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformationFinished(this, transformedAnchor, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape() {
        TangentAnchor tangentAnchor = this.anchor;
        synchronized (tangentAnchor) {
            this.anchor.setTransform(this.createTransformation(this.tangent));
            for (J3DEventListener listener : this.listeners) {
                listener.reshaped(this);
            }
        }
    }

    protected Transform3D createTransformation(Needle tangent) {
        Transform3D transformation = new Transform3D();
        Point3d point = new Point3d(tangent.point.x, tangent.point.y, tangent.point.z);
        Vector3d initial = new Vector3d(0.0, 1.0, 0.0);
        Vector3d needed = new Vector3d(tangent.normal.x, tangent.normal.y, tangent.normal.z);
        if (this.group != null) {
            this.group.untransform(point);
            this.group.untransform(needed);
        }
        transformation.setTranslation(new Vector3d(point.x, point.y, point.z));
        Vector3d axis = new Vector3d();
        axis.cross(initial, needed);
        transformation.setRotation(new AxisAngle4d(axis.x, axis.y, axis.z, needed.angle(initial)));
        return transformation;
    }

    private J3DTangent getThis() {
        return this;
    }

    protected class TangentAnchor
    extends J3DAnchor {
        protected TangentAnchor() {
        }

        protected TangentAnchor(Transform3D transformation) {
            super(transformation);
        }

        @Override
        public void transformed(int type) {
            J3DTangent.this.getThis().transformed(this, type);
        }

        @Override
        public void transformationFinished(int type) {
            J3DTangent.this.getThis().transformationFinished(this, type);
        }
    }
}

