/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DRotation;
import e3d.j3d.interfaces.J3DColoredObject;
import e3d.j3d.interfaces.J3DMaterialObject;
import e3d.j3d.interfaces.J3DTexturedObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.util.J3DEventListener;
import e3d.texture.E3DTextureFile;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;

public abstract class J3DSurface
extends J3DObject
implements J3DTexturedObject,
J3DMaterialObject,
J3DColoredObject {
    protected E3DMaterial material;
    protected E3DTextureFile individualTexture;
    protected final Color3f color = new Color3f();
    protected double roundness;
    private final NormalGenerator normalGenerator = new NormalGenerator();
    private final Stripifier stripifier = new Stripifier();

    public J3DSurface(Color3f color) {
        this.color.set((Tuple3f)color);
    }

    @Override
    public Color3f getColor() {
        return this.color;
    }

    @Override
    public E3DMaterial getMaterial() {
        return this.material;
    }

    @Override
    public E3DTextureFile getIndividualTexture() {
        return this.individualTexture;
    }

    @Override
    public void setIndividualTexture(E3DTextureFile textureFile) {
        this.individualTexture = textureFile;
    }

    public double getRoundness() {
        return this.roundness;
    }

    public abstract void setRoundness(double var1);

    @Override
    public abstract void setGroup(J3DGroup var1);

    @Override
    protected J3DAnchor getAnchor() {
        return null;
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void movedOver(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.movedOver(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    @Override
    public void updated() {
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup anchor, int type) {
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformationFinished(TransformGroup anchor, int type) {
    }

    @Override
    public abstract void reshape();

    protected Geometry createGeometry(Matrix2D<? extends E3DVector> mesh, int col, int row, int cols, int rows, double creaseAngle) {
        int numberOfPoints = (mesh.width() - 1) * (mesh.height() - 1) * 4;
        if (numberOfPoints <= 0) {
            return null;
        }
        int textures = SIDES.length;
        int[] texCoordSetMap = new int[textures];
        int[] nArray = SIDES;
        int n = SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            int side;
            texCoordSetMap[side] = side = nArray[n2];
            ++n2;
        }
        QuadArray quadArray = new QuadArray(numberOfPoints, 33, textures, texCoordSetMap);
        int i = 0;
        int frontBack = 0;
        int topBottom = 0;
        int leftRight = 0;
        int individual = 0;
        double fx = 0.5;
        double fy = 0.5;
        double fz = 0.5;
        double dx = 0.5;
        double dy = 0.5;
        double dz = 0.5;
        float w = mesh.width() - 1;
        float h = mesh.height() - 1;
        int y = 1;
        while (y < mesh.height()) {
            int x = 1;
            while (x < mesh.width()) {
                float x1 = ((float)(x - 1) / w + (float)col) / (float)cols;
                float y1 = ((float)(y - 1) / h + (float)row) / (float)rows;
                float x2 = ((float)x / w + (float)col) / (float)cols;
                float y2 = ((float)(y - 1) / h + (float)row) / (float)rows;
                float x3 = ((float)x / w + (float)col) / (float)cols;
                float y3 = ((float)y / h + (float)row) / (float)rows;
                float x4 = ((float)(x - 1) / w + (float)col) / (float)cols;
                float y4 = ((float)y / h + (float)row) / (float)rows;
                E3DVector v1 = mesh.get(x - 1, y - 1);
                E3DVector v2 = mesh.get(x, y - 1);
                E3DVector v3 = mesh.get(x, y);
                E3DVector v4 = mesh.get(x - 1, y);
                if (v1 != null && v2 != null && v3 != null && v4 != null) {
                    Point3d p1 = new Point3d(v1.x, v1.y, v1.z);
                    Point3d p2 = new Point3d(v2.x, v2.y, v2.z);
                    Point3d p3 = new Point3d(v3.x, v3.y, v3.z);
                    Point3d p4 = new Point3d(v4.x, v4.y, v4.z);
                    if (this.group != null) {
                        this.group.untransform(p1);
                        this.group.untransform(p2);
                        this.group.untransform(p3);
                        this.group.untransform(p4);
                    }
                    quadArray.setCoordinate(i++, p1);
                    quadArray.setCoordinate(i++, p2);
                    quadArray.setCoordinate(i++, p3);
                    quadArray.setCoordinate(i++, p4);
                    quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(v1.x * fx + dx), (float)(v1.y * fy + dy)));
                    quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(v2.x * fx + dx), (float)(v2.y * fy + dy)));
                    quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(v3.x * fx + dx), (float)(v3.y * fy + dy)));
                    quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(v4.x * fx + dx), (float)(v4.y * fy + dy)));
                    quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(v1.x * fx + dx), (float)(v1.z * fz + dz)));
                    quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(v2.x * fx + dx), (float)(v2.z * fz + dz)));
                    quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(v3.x * fx + dx), (float)(v3.z * fz + dz)));
                    quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(v4.x * fx + dx), (float)(v4.z * fz + dz)));
                    quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(v1.z * fz + dz), (float)(v1.y * fy + dy)));
                    quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(v2.z * fz + dz), (float)(v2.y * fy + dy)));
                    quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(v3.z * fz + dz), (float)(v3.y * fy + dy)));
                    quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(v4.z * fz + dz), (float)(v4.y * fy + dy)));
                    quadArray.setTextureCoordinate(0, individual++, new TexCoord2f(x1, y1));
                    quadArray.setTextureCoordinate(0, individual++, new TexCoord2f(x2, y2));
                    quadArray.setTextureCoordinate(0, individual++, new TexCoord2f(x3, y3));
                    quadArray.setTextureCoordinate(0, individual++, new TexCoord2f(x4, y4));
                }
                ++x;
            }
            ++y;
        }
        return this.optimize(quadArray, creaseAngle);
    }

    protected Geometry createGeometry(E3DVector[] points, int radialPoints, double radius, double creaseAngle) {
        int numberOfPoints = (points.length - 1) * radialPoints * 4;
        if (numberOfPoints <= 0) {
            return null;
        }
        int textures = SIDES.length;
        int[] texCoordSetMap = new int[textures];
        int[] nArray = SIDES;
        int n = SIDES.length;
        int n2 = 0;
        while (n2 < n) {
            int side;
            texCoordSetMap[side] = side = nArray[n2];
            ++n2;
        }
        QuadArray quadArray = new QuadArray(numberOfPoints, 33, textures, texCoordSetMap);
        int i1 = 0;
        int frontBack = 0;
        int topBottom = 0;
        int leftRight = 0;
        double fx = 0.5;
        double fy = 0.5;
        double fz = 0.5;
        double dx = 0.5;
        double dy = 0.5;
        double dz = 0.5;
        E3DRotation spin = new E3DRotation();
        E3DVector[] points1 = new E3DVector[radialPoints];
        E3DVector[] points2 = new E3DVector[radialPoints];
        int i = 1;
        while (i < points.length) {
            E3DVector v1 = points[i - 1];
            E3DVector v2 = points[i];
            E3DVector direction = v1.diff(v2);
            spin.set(direction, false, false, false);
            int r = 0;
            while (r < radialPoints) {
                double angle = Math.PI * 2 / (double)radialPoints * (double)r;
                E3DVector point = new E3DVector(Math.sin(angle) * radius, Math.cos(angle) * radius, 0.0);
                spin.transform(point);
                points1[r] = point.sum(v1);
                points2[r] = point.sum(v2);
                ++r;
            }
            int r1 = 0;
            while (r1 < radialPoints) {
                int r2 = (r1 + 1) % radialPoints;
                E3DVector w1 = points1[r1];
                E3DVector w2 = points2[r1];
                E3DVector w3 = points2[r2];
                E3DVector w4 = points1[r2];
                Point3d p1 = new Point3d(w1.x, w1.y, w1.z);
                Point3d p2 = new Point3d(w2.x, w2.y, w2.z);
                Point3d p3 = new Point3d(w3.x, w3.y, w3.z);
                Point3d p4 = new Point3d(w4.x, w4.y, w4.z);
                if (this.group != null) {
                    this.group.untransform(p1);
                    this.group.untransform(p2);
                }
                quadArray.setCoordinate(i1++, p1);
                quadArray.setCoordinate(i1++, p2);
                quadArray.setCoordinate(i1++, p3);
                quadArray.setCoordinate(i1++, p4);
                quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(w1.x * fx + dx), (float)(w1.y * fy + dy)));
                quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(w2.x * fx + dx), (float)(w2.y * fy + dy)));
                quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(w3.x * fx + dx), (float)(w3.y * fy + dy)));
                quadArray.setTextureCoordinate(1, frontBack++, new TexCoord2f((float)(w4.x * fx + dx), (float)(w4.y * fy + dy)));
                quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(w1.x * fx + dx), (float)(w1.z * fz + dz)));
                quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(w2.x * fx + dx), (float)(w2.z * fz + dz)));
                quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(w3.x * fx + dx), (float)(w3.z * fz + dz)));
                quadArray.setTextureCoordinate(2, topBottom++, new TexCoord2f((float)(w4.x * fx + dx), (float)(w4.z * fz + dz)));
                quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(w1.z * fz + dz), (float)(w1.y * fy + dy)));
                quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(w2.z * fz + dz), (float)(w2.y * fy + dy)));
                quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(w3.z * fz + dz), (float)(w3.y * fy + dy)));
                quadArray.setTextureCoordinate(3, leftRight++, new TexCoord2f((float)(w4.z * fz + dz), (float)(w4.y * fy + dy)));
                ++r1;
            }
            ++i;
        }
        return this.optimize(quadArray, creaseAngle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Geometry optimize(QuadArray quadArray, double creaseAngle) {
        NormalGenerator normalGenerator = this.normalGenerator;
        synchronized (normalGenerator) {
            GeometryInfo geometryInfo = new GeometryInfo((GeometryArray)quadArray);
            geometryInfo.recomputeIndices();
            this.normalGenerator.setCreaseAngle(creaseAngle);
            this.normalGenerator.generateNormals(geometryInfo);
            this.stripifier.stripify(geometryInfo);
            geometryInfo.recomputeIndices();
            return geometryInfo.getGeometryArray();
        }
    }

    private J3DSurface getThis() {
        return this;
    }

    protected class SurfaceShape
    extends Shape3D
    implements J3DAtomicPart {
        protected SurfaceShape(Color3f color, int polygonMode, int shadeModel) {
            this.init(color, polygonMode, shadeModel);
        }

        protected SurfaceShape(Geometry geometry, Color3f color, int polygonMode, int shadeModel) {
            super(geometry);
            this.init(color, polygonMode, shadeModel);
        }

        private void init(Color3f color, int polygonMode, int shadeModel) {
            Material material = new Material();
            Color3f dimmed = new Color3f(color.x * 0.7f, color.y * 0.7f, color.z * 0.7f);
            material.setAmbientColor(dimmed);
            material.setDiffuseColor(dimmed);
            material.setSpecularColor(dimmed);
            material.setShininess(64.0f);
            material.setCapability(1);
            ColoringAttributes coloring = new ColoringAttributes(color, shadeModel);
            coloring.setCapability(1);
            TransparencyAttributes transparency = new TransparencyAttributes(4, 0.0f);
            PolygonAttributes polygon = new PolygonAttributes(polygonMode, 0, 0.0f);
            polygon.setBackFaceNormalFlip(true);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(polygon);
            appearance.setColoringAttributes(coloring);
            appearance.setTransparencyAttributes(transparency);
            appearance.setMaterial(material);
            appearance.setCapability(11);
            TextureUnitState[] textureUnitStates = new TextureUnitState[SIDES.length];
            int[] nArray = SIDES;
            int n = SIDES.length;
            int n2 = 0;
            while (n2 < n) {
                int side = nArray[n2];
                TextureAttributes texturing = new TextureAttributes();
                texturing.setTextureMode(2);
                textureUnitStates[side] = new TextureUnitState(null, texturing, null);
                textureUnitStates[side].setCapability(1);
                ++n2;
            }
            appearance.setTextureUnitState(textureUnitStates);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DSurface.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DSurface.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DSurface.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(transparency == 0.0f ? 4 : 0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DSurface getObject() {
            return J3DSurface.this.getThis();
        }
    }
}

