/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DMasterObject;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.util.J3DDependencies;
import e3d.utils.Counter;
import java.util.Map;
import javax.media.j3d.TransformGroup;

public class J3DSelectionGroup
extends J3DGroup {
    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DSelectionGroup(Parameters parameters) {
        super(parameters);
    }

    @Override
    public Parameters getParameters() {
        return (Parameters)this.parameters;
    }

    @Override
    public void updated() {
        super.updated();
        this.update();
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        super.transformed(transformedAnchor, type);
        this.update();
    }

    private void update() {
        Counter<J3DSlaveObject> slaves = new Counter<J3DSlaveObject>();
        for (J3DInstance j3DInstance : this.getObjectOrder()) {
            if (!(j3DInstance instanceof J3DMasterObject)) continue;
            J3DMasterObject master = (J3DMasterObject)j3DInstance;
            J3DDependencies dependencies = master.getDependencies();
            for (J3DSlaveObject slave : dependencies.getSlaves()) {
                slaves.increment(slave);
            }
        }
        for (Map.Entry entry : slaves.entrySet()) {
            J3DSlaveObject slave = (J3DSlaveObject)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count == (long)slave.getNumberOfMasters()) continue;
            slave.reshape();
        }
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        super.transformationFinished(transformedAnchor, type);
    }

    @Override
    public void reshape() {
    }

    public static /* bridge */ /* synthetic */ J3DGroup.Parameters getDefaultParameters() {
        return J3DSelectionGroup.getDefaultParameters();
    }

    public static class Parameters
    extends J3DGroup.Parameters {
    }
}

