/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.bezier.Needle;
import e3d.j3d.objects.J3DTangent;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.util.J3DEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;

public class J3DRectangle
extends J3DTangent {
    public static final int ROTATE_0_DEGREES = 0;
    public static final int ROTATE_90_DEGREES = 1;
    public static final int ROTATE_180_DEGREES = 2;
    public static final int ROTATE_270_DEGREES = 3;
    private final RectangularShape side1;
    private final RectangularShape side2;
    protected final Parameters parameters;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DRectangle(Texture2D texture, int rotation, double width, double height, double depth, Needle tangent, boolean pickable, Parameters parameters) throws IOException {
        super(tangent, pickable);
        this.parameters = parameters;
        Geometry[] geometries = this.createGeometries(width, height, depth, rotation);
        this.side1 = new RectangularShape(geometries[0], texture);
        this.side2 = new RectangularShape(geometries[1], texture);
        this.anchor.addChild((Node)this.side1);
        this.anchor.addChild((Node)this.side2);
    }

    @Override
    public void recreate() {
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.side1.setTransparency(transparency);
        this.side2.setTransparency(transparency);
    }

    public void setTexture1(Texture texture1) {
        this.side1.getAppearance().setTexture(texture1);
    }

    public void setTexture2(Texture texture2) {
        this.side2.getAppearance().setTexture(texture2);
    }

    public Texture getTexture1() {
        return this.side1.getAppearance().getTexture();
    }

    public Texture getTexture2() {
        return this.side2.getAppearance().getTexture();
    }

    public void setColor1(Color3f color) {
        Color3f dimmed = new Color3f(color.x * 0.7f, color.y * 0.7f, color.z * 0.7f);
        this.side1.getAppearance().getMaterial().setAmbientColor(dimmed);
        this.side1.getAppearance().getMaterial().setDiffuseColor(dimmed);
        this.side1.getAppearance().getMaterial().setSpecularColor(dimmed);
        this.side1.getAppearance().getColoringAttributes().setColor(color);
    }

    public void setColor2(Color3f color) {
        Color3f dimmed = new Color3f(color.x * 0.7f, color.y * 0.7f, color.z * 0.7f);
        this.side2.getAppearance().getMaterial().setAmbientColor(dimmed);
        this.side2.getAppearance().getMaterial().setDiffuseColor(dimmed);
        this.side2.getAppearance().getMaterial().setSpecularColor(dimmed);
        this.side2.getAppearance().getColoringAttributes().setColor(color);
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void movedOver(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.movedOver(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    protected Geometry[] createGeometries(double width, double height, double depth, int rotation) {
        double w = width / 2.0;
        double h = height / 2.0;
        double d = depth / 2.0;
        int n = depth > 0.0 ? 12 : 4;
        QuadArray quadArray1 = new QuadArray(n, 33);
        quadArray1.setCoordinate(0, new Point3d(-w, d, h));
        quadArray1.setCoordinate(1, new Point3d(w, d, h));
        quadArray1.setCoordinate(2, new Point3d(w, d, -h));
        quadArray1.setCoordinate(3, new Point3d(-w, d, -h));
        quadArray1.setTextureCoordinate(0, (0 + rotation) % 4, new TexCoord2f(0.0f, 1.0f));
        quadArray1.setTextureCoordinate(0, (1 + rotation) % 4, new TexCoord2f(1.0f, 1.0f));
        quadArray1.setTextureCoordinate(0, (2 + rotation) % 4, new TexCoord2f(1.0f, 0.0f));
        quadArray1.setTextureCoordinate(0, (3 + rotation) % 4, new TexCoord2f(0.0f, 0.0f));
        if (n > 4) {
            quadArray1.setCoordinate(4, new Point3d(-w, -d, h));
            quadArray1.setCoordinate(5, new Point3d(w, -d, h));
            quadArray1.setCoordinate(6, new Point3d(w, d, h));
            quadArray1.setCoordinate(7, new Point3d(-w, d, h));
            quadArray1.setCoordinate(8, new Point3d(-w, -d, h));
            quadArray1.setCoordinate(9, new Point3d(-w, d, h));
            quadArray1.setCoordinate(10, new Point3d(-w, d, -h));
            quadArray1.setCoordinate(11, new Point3d(-w, -d, -h));
            quadArray1.setTextureCoordinate(0, 4 + (0 + rotation) % 4, new TexCoord2f(0.0f, 1.0f));
            quadArray1.setTextureCoordinate(0, 4 + (1 + rotation) % 4, new TexCoord2f(1.0f, 1.0f));
            quadArray1.setTextureCoordinate(0, 4 + (2 + rotation) % 4, new TexCoord2f(1.0f, 0.99f));
            quadArray1.setTextureCoordinate(0, 4 + (3 + rotation) % 4, new TexCoord2f(0.0f, 0.99f));
            quadArray1.setTextureCoordinate(0, 8 + (0 + rotation) % 4, new TexCoord2f(0.01f, 1.0f));
            quadArray1.setTextureCoordinate(0, 8 + (1 + rotation) % 4, new TexCoord2f(0.0f, 1.0f));
            quadArray1.setTextureCoordinate(0, 8 + (2 + rotation) % 4, new TexCoord2f(0.0f, 0.0f));
            quadArray1.setTextureCoordinate(0, 8 + (3 + rotation) % 4, new TexCoord2f(0.01f, 0.0f));
        }
        QuadArray quadArray2 = new QuadArray(n, 33);
        quadArray2.setCoordinate(0, new Point3d(-w, -d, h));
        quadArray2.setCoordinate(1, new Point3d(-w, -d, -h));
        quadArray2.setCoordinate(2, new Point3d(w, -d, -h));
        quadArray2.setCoordinate(3, new Point3d(w, -d, h));
        quadArray2.setTextureCoordinate(0, (4 - rotation) % 4, new TexCoord2f(0.0f, 1.0f));
        quadArray2.setTextureCoordinate(0, (5 - rotation) % 4, new TexCoord2f(0.0f, 0.0f));
        quadArray2.setTextureCoordinate(0, (6 - rotation) % 4, new TexCoord2f(1.0f, 0.0f));
        quadArray2.setTextureCoordinate(0, (7 - rotation) % 4, new TexCoord2f(1.0f, 1.0f));
        if (n > 4) {
            quadArray2.setCoordinate(4, new Point3d(w, -d, -h));
            quadArray2.setCoordinate(5, new Point3d(-w, -d, -h));
            quadArray2.setCoordinate(6, new Point3d(-w, d, -h));
            quadArray2.setCoordinate(7, new Point3d(w, d, -h));
            quadArray2.setCoordinate(8, new Point3d(w, -d, -h));
            quadArray2.setCoordinate(9, new Point3d(w, d, -h));
            quadArray2.setCoordinate(10, new Point3d(w, d, h));
            quadArray2.setCoordinate(11, new Point3d(w, -d, h));
            quadArray2.setTextureCoordinate(0, 4 + (4 - rotation) % 4, new TexCoord2f(1.0f, 0.0f));
            quadArray2.setTextureCoordinate(0, 4 + (5 - rotation) % 4, new TexCoord2f(0.0f, 0.0f));
            quadArray2.setTextureCoordinate(0, 4 + (6 - rotation) % 4, new TexCoord2f(0.0f, 0.01f));
            quadArray2.setTextureCoordinate(0, 4 + (7 - rotation) % 4, new TexCoord2f(1.0f, 0.01f));
            quadArray2.setTextureCoordinate(0, 8 + (4 - rotation) % 4, new TexCoord2f(1.0f, 0.0f));
            quadArray2.setTextureCoordinate(0, 8 + (5 - rotation) % 4, new TexCoord2f(0.99f, 0.0f));
            quadArray2.setTextureCoordinate(0, 8 + (6 - rotation) % 4, new TexCoord2f(0.99f, 1.0f));
            quadArray2.setTextureCoordinate(0, 8 + (7 - rotation) % 4, new TexCoord2f(1.0f, 1.0f));
        }
        GeometryInfo geometryInfo1 = new GeometryInfo((GeometryArray)quadArray1);
        GeometryInfo geometryInfo2 = new GeometryInfo((GeometryArray)quadArray2);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo1);
        normalGenerator.generateNormals(geometryInfo2);
        geometryInfo1.recomputeIndices();
        geometryInfo2.recomputeIndices();
        return new Geometry[]{geometryInfo1.getGeometryArray(), geometryInfo2.getGeometryArray()};
    }

    private J3DRectangle getThis() {
        return this;
    }

    public static class Parameters {
    }

    protected class RectangularShape
    extends Shape3D
    implements J3DAtomicPart {
        protected RectangularShape(Geometry geometry, Texture2D texture) {
            super(geometry);
            Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
            Material material = new Material();
            material.setAmbientColor(color);
            material.setDiffuseColor(color);
            material.setSpecularColor(color);
            material.setCapability(1);
            PolygonAttributes polygon = new PolygonAttributes(2, 1, 0.0f);
            ColoringAttributes coloring = new ColoringAttributes(color, 0);
            coloring.setCapability(1);
            TextureAttributes texturing = new TextureAttributes();
            TransparencyAttributes transparency = new TransparencyAttributes(4, 0.0f);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(polygon);
            appearance.setColoringAttributes(coloring);
            appearance.setTextureAttributes(texturing);
            appearance.setTransparencyAttributes(transparency);
            appearance.setMaterial(material);
            appearance.setTexture((Texture)texture);
            appearance.setCapability(3);
            appearance.setCapability(11);
            this.setAppearance(appearance);
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DRectangle.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DRectangle.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DRectangle.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(transparency == 0.0f ? 4 : 0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DRectangle getObject() {
            return J3DRectangle.this.getThis();
        }
    }
}

