/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.bezier.Position;
import e3d.j3d.interfaces.J3DMasterObject;
import e3d.j3d.interfaces.J3DOrientedObject;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DPoint;
import e3d.j3d.objects.J3DSurface;
import e3d.j3d.util.J3DEventListener;
import e3d.texture.E3DTextureFile;
import e3d.utils.ArrayFactory;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class J3DPointMesh
extends J3DSurface
implements J3DOrientedObject,
J3DSlaveObject {
    final TransformGroup anchor;
    protected J3DSurface.SurfaceShape shape;
    protected final Parameters parameters;
    protected final Matrix2D<J3DPoint> points;
    protected final Map<J3DPoint, List<Matrix2D.Coordinates>> point2meshCoords;
    protected final Map<Integer, Texture2D> side2Texture;
    protected final Matrix2D<Position> mesh;

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DPointMesh(Matrix2D<J3DPoint> points, Color3f color, E3DMaterial material, E3DTextureFile texture, double roundness, Parameters parameters) {
        super(color);
        this.parameters = parameters;
        this.points = points;
        this.material = material;
        this.roundness = roundness;
        this.individualTexture = texture;
        this.side2Texture = new HashMap<Integer, Texture2D>();
        this.anchor = new TransformGroup();
        this.anchor.setCapability(14);
        this.anchor.setCapability(13);
        this.createSides();
        this.setCapability(17);
        this.addChild((Node)this.anchor);
        int w = points.width();
        int h = points.height();
        this.mesh = new Matrix2D<Position>(w, h, ArrayFactory.POSITION, null);
        this.point2meshCoords = new HashMap<J3DPoint, List<Matrix2D.Coordinates>>(w * h);
        this.addCoordinates();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void recreate() {
        this.createSides();
        this.reshapeAll();
    }

    protected BranchGroup createSides() {
        this.shape = new J3DSurface.SurfaceShape(this, this.color, this.parameters.polygonMode, this.parameters.shadeModel);
        this.shape.setCapability(13);
        this.setTransparency(this.transparency);
        if (this.parameters.polygonMode == 2) {
            for (Map.Entry<Integer, Texture2D> sideTexture : this.side2Texture.entrySet()) {
                int side = sideTexture.getKey();
                Texture2D texture = sideTexture.getValue();
                this.setTexture(texture, side);
            }
        }
        BranchGroup sides = new BranchGroup();
        sides.setCapability(17);
        sides.addChild((Node)this.shape);
        this.anchor.removeAllChildren();
        this.anchor.addChild((Node)sides);
        return sides;
    }

    private void addCoordinates() {
        int y = 0;
        while (y < this.points.height()) {
            int x = 0;
            while (x < this.points.width()) {
                J3DPoint point = this.points.get(x, y);
                this.addCoordinate(x, y, point);
                ++x;
            }
            ++y;
        }
    }

    private void addCoordinate(int x, int y, J3DPoint point) {
        if (point != null) {
            this.mesh.set(x, y, point.position);
            List<Matrix2D.Coordinates> meshCoords = this.point2meshCoords.get(point);
            if (meshCoords == null) {
                meshCoords = new Vector<Matrix2D.Coordinates>();
                this.point2meshCoords.put(point, meshCoords);
            }
            meshCoords.add(new Matrix2D.Coordinates(x, y));
        }
    }

    private void rmCoordinate(int x, int y, J3DPoint point) {
        this.mesh.set(x, y, (Position)null);
        List<Matrix2D.Coordinates> meshCoords = this.point2meshCoords.get(point);
        if (meshCoords != null) {
            meshCoords.remove(new Matrix2D.Coordinates(x, y));
            if (meshCoords.isEmpty()) {
                this.point2meshCoords.remove(point);
            }
        }
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.shape.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
        } else {
            this.shape.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.shape.setTransparency(transparency);
    }

    @Override
    public void setColor(Color3f color) {
        Color3f dimmed = new Color3f(color.x * 0.7f, color.y * 0.7f, color.z * 0.7f);
        this.shape.getAppearance().getMaterial().setAmbientColor(dimmed);
        this.shape.getAppearance().getMaterial().setDiffuseColor(dimmed);
        this.shape.getAppearance().getMaterial().setSpecularColor(dimmed);
        this.shape.getAppearance().getColoringAttributes().setColor(color);
        this.color.set((Tuple3f)color);
    }

    @Override
    public void setMaterial(E3DMaterial material) {
        float shininess = material == null ? 64.0f : (float)(material.getGlossiness() * 127.0 + 1.0);
        this.shape.getAppearance().getMaterial().setShininess(shininess);
        this.material = material;
    }

    @Override
    public void setTexture(Texture2D texture, int side) {
        if (texture == null) {
            this.side2Texture.remove(side);
        } else {
            this.side2Texture.put(side, texture);
        }
        if (this.parameters.polygonMode == 2) {
            if (texture == null) {
                if (this.shape.getAppearance().getTextureUnitState(side) != null) {
                    this.shape.getAppearance().getTextureUnitState(side).setTexture(null);
                }
            } else if (this.shape.getAppearance().getTextureUnitState(side) != null) {
                this.shape.getAppearance().getTextureUnitState(side).setTexture((Texture)texture);
            }
        }
    }

    @Override
    public Texture2D getTexture(int side) {
        return this.side2Texture.get(side);
    }

    @Override
    public int getNumberOfMasters() {
        return this.point2meshCoords.size();
    }

    @Override
    public List<Matrix2D.Coordinates> getMeshCoordinates(J3DMasterObject point) {
        return this.point2meshCoords.get(point);
    }

    public Matrix2D<J3DPoint> getMasters() {
        return this.points;
    }

    public Collection<J3DPoint> getAllInRowOf(J3DMasterObject master) {
        HashSet<J3DPoint> rowPoints = new HashSet<J3DPoint>();
        List<Matrix2D.Coordinates> coords = this.point2meshCoords.get(master);
        if (coords != null) {
            for (Matrix2D.Coordinates coord : coords) {
                int x = 0;
                while (x < this.points.width()) {
                    J3DPoint point = this.points.get(x, coord.y);
                    if (point != null) {
                        rowPoints.add(point);
                    }
                    ++x;
                }
            }
        }
        return rowPoints;
    }

    public Collection<J3DPoint> getAllInColumnOf(J3DMasterObject master) {
        HashSet<J3DPoint> colPoints = new HashSet<J3DPoint>();
        List<Matrix2D.Coordinates> coords = this.point2meshCoords.get(master);
        if (coords != null) {
            for (Matrix2D.Coordinates coord : coords) {
                int y = 0;
                while (y < this.points.height()) {
                    J3DPoint point = this.points.get(coord.x, y);
                    if (point != null) {
                        colPoints.add(point);
                    }
                    ++y;
                }
            }
        }
        return colPoints;
    }

    @Override
    public void setGroup(J3DGroup group) {
        this.group = group;
        if (group != null && group.isLive()) {
            this.reshapeAll();
        }
    }

    @Override
    public void setRoundness(double roundness) {
        this.roundness = roundness;
    }

    @Override
    public void orientate(J3DOrientedObject.Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL_MIRRORING: {
                this.points.mirrorHorizontal();
                break;
            }
            case VERTICAL_MIRRORING: {
                this.points.mirrorVertical();
                break;
            }
            case ROTATE_LEFT: {
                this.points.rotateLeft();
                break;
            }
            case ROTATE_RIGHT: {
                this.points.rotateRight();
            }
        }
        this.mesh.reshape(this.points.width(), this.points.height(), null);
        this.addCoordinates();
    }

    @Override
    public void reshape() {
        this.reshapeAll();
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    public void restore(int width, int height, J3DPoint[] points) {
        this.points.reshape(width, height, (J3DPoint[])points);
        this.mesh.reshape(width, height, (Position[])ArrayFactory.POSITION.create(width * height));
        this.point2meshCoords.clear();
        this.addCoordinates();
        this.reshapeAll();
    }

    private void reshapeAll() {
        Geometry geometry = this.createGeometry();
        if (geometry != null) {
            this.shape.setGeometry(geometry);
        }
    }

    private Geometry createGeometry() {
        if (this.mesh.width() == 1 && this.mesh.height() == 1) {
            return null;
        }
        if (this.mesh.width() == 1 || this.mesh.height() == 1) {
            return this.createGeometry(this.mesh.toArray(), this.parameters.lineRadialPoints, this.parameters.lineRadius, this.parameters.creaseAngle);
        }
        return this.createGeometry(this.mesh, 0, 0, 1, 1, this.parameters.creaseAngle);
    }

    public void removePoint(J3DPoint point) {
        List<Matrix2D.Coordinates> coords = this.point2meshCoords.remove(point);
        if (coords != null) {
            for (Matrix2D.Coordinates coord : coords) {
                this.points.set(coord.x, coord.y, (J3DPoint)null);
                this.mesh.set(coord.x, coord.y, (Position)null);
            }
        }
    }

    public void replacePoint(int x, int y, J3DPoint newPoint) {
        J3DPoint oldPoint = this.points.get(x, y);
        if (oldPoint != null) {
            this.rmCoordinate(x, y, oldPoint);
        }
        this.points.set(x, y, newPoint);
        this.addCoordinate(x, y, newPoint);
    }

    public static class Parameters {
        public int polygonMode = 2;
        public int shadeModel = 0;
        public int lineRadialPoints = 9;
        public double lineRadius = 0.001;
        public double creaseAngle = 1.0471975511965976;
    }
}

