/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickIntersection;
import e3d.bezier.Position;
import e3d.euclidean.E3DVector;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.history.PointHistoryState;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DMasterObject;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DCenteredObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.objects.util.J3DDependencies;
import e3d.j3d.util.J3DEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

public class J3DPoint
extends J3DCenteredObject
implements J3DMasterObject {
    private PointSphere point;
    protected final Position position;
    protected final PointAnchor anchor;
    protected final Parameters parameters;
    protected final J3DDependencies dependencies = new J3DDependencies();

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DPoint(Position position, Parameters parameters) {
        this.parameters = parameters;
        this.position = position;
        this.anchor = new PointAnchor(this.transformation);
        this.anchor.setCapability(14);
        this.anchor.setCapability(13);
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        this.anchor.setCapability(1);
        this.anchor.setCapability(6);
        this.anchor.setCapability(5);
        this.setPickable(true);
        this.createParts();
        this.setCapability(17);
        this.addChild((Node)this.anchor);
    }

    @Override
    public void recreate() {
        this.createParts();
    }

    protected BranchGroup createParts() {
        BranchGroup parts = new BranchGroup();
        parts.setCapability(17);
        this.point = new PointSphere(this.parameters.color, this.parameters.transparency, this.parameters.radius * this.parameters.scale);
        parts.addChild((Node)this.point);
        this.anchor.removeAllChildren();
        this.anchor.addChild((Node)parts);
        this.point.setTransparency(this.transparency);
        return parts;
    }

    public void compile() {
        throw new UnsupportedOperationException("Cannot compile points because they must be able to change capability bits!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scale(double factor) {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            this.position.multiplicate(factor);
            this.reshape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(J3DMasterObject.Transformation transformation) {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            switch (transformation) {
                case X_MIRRORING: {
                    this.position.x = -this.position.x;
                    break;
                }
                case Y_MIRRORING: {
                    this.position.y = -this.position.y;
                    break;
                }
                case Z_MIRRORING: {
                    this.position.z = -this.position.z;
                    break;
                }
                case ROTATE_LEFT_Z: {
                    this.position.spinZ(1.5707963267948966);
                    break;
                }
                case ROTATE_RIGHT_Z: {
                    this.position.spinZ(-1.5707963267948966);
                    break;
                }
                case ROTATE_LEFT_Y: {
                    this.position.spinY(-1.5707963267948966);
                    break;
                }
                case ROTATE_RIGHT_Y: {
                    this.position.spinY(1.5707963267948966);
                    break;
                }
                case ROTATE_FRONT_X: {
                    this.position.spinX(1.5707963267948966);
                    break;
                }
                case ROTATE_BACK_X: {
                    this.position.spinX(-1.5707963267948966);
                }
            }
            this.reshape();
        }
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public E3DVector getCenter() {
        return this.position;
    }

    public Position getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(E3DVector position) {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            this.position.set(position);
            this.reshape();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroup(J3DGroup group) {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            this.group = group;
            this.anchor.setTransform(this.createTransformation(this.position));
        }
    }

    @Override
    protected J3DAnchor getAnchor() {
        return this.anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelected(boolean selected) {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            super.setSelected(selected);
            if (selected) {
                if (this.group != null) {
                    this.group.getAnchor().removeChild((Node)this);
                    this.anchor.clearCapability(1);
                    this.group.getAnchor().addChild((Node)this);
                }
                this.point.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
            } else {
                if (this.group != null) {
                    this.group.getAnchor().removeChild((Node)this);
                    this.anchor.setCapability(1);
                    this.group.getAnchor().addChild((Node)this);
                }
                this.point.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public void setTransparency(float transparency) {
        super.setTransparency(transparency);
        this.point.setTransparency(transparency);
    }

    @Override
    public J3DDependencies getDependencies() {
        return this.dependencies;
    }

    public void interpolate(double interpolationRadius, Function interpolationFunction, Set<J3DInstance> objects, J3DHistory history) {
        HashSet<J3DSlaveObject> slaves = new HashSet<J3DSlaveObject>();
        slaves.addAll(this.getDependencies().getSlaves());
        if (interpolationRadius >= 0.0) {
            Position myOrigPos = ((PointHistoryState)history.getCurrent(this).getPrevious()).getPosition();
            E3DVector delta = this.position.diff(myOrigPos);
            for (J3DInstance object : objects) {
                double factor;
                if (object == this || object.isSelected() || !object.isLive() || !(object instanceof J3DPoint)) continue;
                J3DPoint point = (J3DPoint)object;
                Position origPos = ((PointHistoryState)history.getCurrent(point).getPrevious()).getPosition();
                double dist = Math.min(1.0, myOrigPos.dist(origPos) / interpolationRadius);
                switch (interpolationFunction) {
                    case SIGMOIDAL: {
                        factor = 1.0 / (1.0 + Math.exp(dist * 8.0 - 4.0));
                        break;
                    }
                    case QUADRATIC: {
                        factor = 1.0 - dist * dist;
                        break;
                    }
                    case PLATEAU: {
                        factor = 1.0;
                        break;
                    }
                    default: {
                        factor = 1.0 - dist;
                    }
                }
                if (factor > 0.0) {
                    point.setPosition(origPos.sum(delta.product(factor)));
                }
                slaves.addAll(point.getDependencies().getSlaves());
            }
        }
        for (J3DSlaveObject slave : slaves) {
            slave.reshape();
        }
    }

    protected void clicked(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.clicked(this, event, intersection);
        }
    }

    protected void movedOver(MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.movedOver(this, event, intersection);
        }
    }

    protected void typed(KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.listeners) {
            listener.typed(this, event, intersection);
        }
    }

    @Override
    public void updated() {
        this.update();
        for (J3DEventListener listener : this.listeners) {
            listener.updated(this);
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    @Override
    public void transformed(TransformGroup transformedAnchor, int type) {
        this.update();
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformed(this, transformedAnchor, type);
            }
        }
        for (J3DEventListener listener : this.listeners) {
            listener.reshaped(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
            this.anchor.getTransform(this.transformation);
            this.transformation.transform(position);
            if (this.group != null) {
                this.group.transform(position);
            }
            this.position.set(position.x, position.y, position.z);
        }
    }

    @Override
    public void transformationFinished(TransformGroup transformedAnchor, int type) {
        if (transformedAnchor == this.anchor) {
            for (J3DEventListener listener : this.listeners) {
                listener.transformationFinished(this, transformedAnchor, type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape() {
        PointAnchor pointAnchor = this.anchor;
        synchronized (pointAnchor) {
            this.anchor.setTransform(this.createTransformation(this.position));
            for (J3DEventListener listener : this.listeners) {
                listener.reshaped(this);
            }
        }
    }

    protected Transform3D createTransformation(E3DVector position) {
        Transform3D transformation = new Transform3D();
        Point3d point = new Point3d(position.x, position.y, position.z);
        if (this.group != null) {
            this.group.untransform(point);
        }
        transformation.setTranslation(new Vector3d(point.x, point.y, point.z));
        return transformation;
    }

    private J3DPoint getThis() {
        return this;
    }

    public static enum Function {
        LINEAR,
        QUADRATIC,
        SIGMOIDAL,
        PLATEAU;

    }

    public static class Parameters {
        public Color3f color = new Color3f(0.0f, 0.2f, 0.6f);
        public float transparency = 0.0f;
        public float radius = 0.005f;
        public float scale = 1.0f;
    }

    protected class PointAnchor
    extends J3DAnchor {
        protected PointAnchor(Transform3D transformation) {
            super(transformation);
        }

        @Override
        public void transformed(int type) {
            J3DPoint.this.getThis().transformed(this, type);
        }

        @Override
        public void transformationFinished(int type) {
            J3DPoint.this.getThis().transformationFinished(this, type);
        }
    }

    protected class PointSphere
    extends Sphere
    implements J3DAtomicPart {
        protected PointSphere(Color3f color, float transparency, float radius) {
            super(radius);
            Material material = new Material();
            material.setAmbientColor(color);
            material.setDiffuseColor(color);
            material.setEmissiveColor(color);
            material.setCapability(1);
            Appearance appearance = new Appearance();
            appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
            appearance.setColoringAttributes(new ColoringAttributes(color, 0));
            appearance.setMaterial(material);
            appearance.setTransparencyAttributes(new TransparencyAttributes(0, transparency));
            appearance.setCapability(11);
            this.setAppearance(appearance);
            this.getShape().setUserData((Object)J3DPoint.this.getThis());
        }

        @Override
        public void clicked(MouseEvent event, PickIntersection intersection) {
            J3DPoint.this.getThis().clicked(event, intersection);
        }

        @Override
        public void movedOver(MouseEvent event, PickIntersection intersection) {
            J3DPoint.this.getThis().movedOver(event, intersection);
        }

        @Override
        public void typed(KeyEvent event, PickIntersection intersection) {
            J3DPoint.this.getThis().typed(event, intersection);
        }

        @Override
        public void setTransparency(float transparency) {
            this.getAppearance().setTransparencyAttributes(new TransparencyAttributes(0, transparency));
        }

        @Override
        public void setSelected(boolean selected) {
        }

        @Override
        public J3DPoint getObject() {
            return J3DPoint.this.getThis();
        }
    }
}

