/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DSceneGroup;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.util.J3DEventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public abstract class J3DObject
extends BranchGroup
implements J3DInstance {
    protected J3DGroup group = null;
    protected boolean selected;
    protected float transparency = 0.0f;
    protected final Transform3D transformation = new Transform3D();
    protected final Transform3D invertedTransformation = new Transform3D();
    protected final CopyOnWriteArrayList<J3DEventListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void dispose() {
    }

    @Override
    public void addEventListener(J3DEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(J3DEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean hasListener(J3DEventListener listener) {
        return this.listeners.contains(listener);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        for (J3DEventListener listener : this.listeners) {
            listener.selected(this);
        }
    }

    @Override
    public void setTransparency(float transparency) {
        this.transparency = transparency;
    }

    @Override
    public float getTransparency() {
        return this.transparency;
    }

    @Override
    public J3DGroup getGroup() {
        return this.group;
    }

    @Override
    public abstract void setGroup(J3DGroup var1);

    @Override
    public J3DSceneGroup getSceneGroup() {
        return this.group == null ? null : this.group.getSceneGroup();
    }

    protected abstract J3DAnchor getAnchor();

    @Override
    public abstract void updated();

    @Override
    public abstract void transformed(TransformGroup var1, int var2);

    @Override
    public abstract void transformationFinished(TransformGroup var1, int var2);

    @Override
    public abstract void reshape();

    @Override
    public void transform(Point3d point) {
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.transformation.transform(point);
        }
        if (this.group != null) {
            this.group.transform(point);
        }
    }

    @Override
    public void transform(Point3f point) {
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.transformation.transform(point);
        }
        if (this.group != null) {
            this.group.transform(point);
        }
    }

    @Override
    public void transform(Vector3d vector) {
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.transformation.transform(vector);
        }
        if (this.group != null) {
            this.group.transform(vector);
        }
    }

    @Override
    public void transform(Vector3f vector) {
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.transformation.transform(vector);
        }
        if (this.group != null) {
            this.group.transform(vector);
        }
    }

    @Override
    public void transform(Transform3D transform) {
        if (this.group != null) {
            this.group.transform(transform);
        }
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            transform.mul(this.transformation);
        }
    }

    @Override
    public void untransform(Point3d point) {
        if (this.group != null) {
            this.group.untransform(point);
        }
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.invertedTransformation.invert(this.transformation);
        }
        this.invertedTransformation.transform(point);
    }

    @Override
    public void untransform(Point3f point) {
        if (this.group != null) {
            this.group.untransform(point);
        }
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.invertedTransformation.invert(this.transformation);
            this.invertedTransformation.transform(point);
        }
    }

    @Override
    public void untransform(Vector3d vector) {
        if (this.group != null) {
            this.group.untransform(vector);
        }
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.invertedTransformation.invert(this.transformation);
            this.invertedTransformation.transform(vector);
        }
    }

    @Override
    public void untransform(Vector3f vector) {
        if (this.group != null) {
            this.group.untransform(vector);
        }
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            this.invertedTransformation.invert(this.transformation);
            this.invertedTransformation.transform(vector);
        }
    }

    @Override
    public void untransform(Transform3D transform) {
        if (this.getAnchor() != null) {
            this.getAnchor().getTransform(this.transformation);
            transform.mulInverse(this.transformation);
        }
        if (this.group != null) {
            this.group.untransform(transform);
        }
    }
}

