/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.objects;

import e3d.bezier.Bezier4P4N;
import e3d.bezier.BezierCurve2P2N;
import e3d.euclidean.E3DTangent;
import e3d.euclidean.E3DVector;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DMasterObject;
import e3d.j3d.interfaces.J3DOrientedObject;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DSurface;
import e3d.j3d.util.J3DEventAdapter;
import e3d.j3d.util.J3DEventListener;
import e3d.texture.E3DTextureFile;
import e3d.utils.ArrayFactory;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class J3DNeedleMesh
extends J3DSurface
implements J3DOrientedObject,
J3DSlaveObject {
    final ArrayFactory<J3DSurface.SurfaceShape> SURFACESHAPEFACTORY = new ArrayFactory<J3DSurface.SurfaceShape>(){

        @Override
        public J3DSurface.SurfaceShape copy(J3DSurface.SurfaceShape element) {
            throw new UnsupportedOperationException();
        }

        public J3DSurface.SurfaceShape[] create(int size) {
            return new J3DSurface.SurfaceShape[size];
        }
    };
    private static final Timer TIMER = new Timer("Resolution timer");
    final TransformGroup anchor;
    protected Matrix2D<J3DSurface.SurfaceShape> shapes;
    protected final Parameters parameters;
    protected final Matrix2D<J3DNeedle> needles;
    protected final Map<J3DNeedle, List<Matrix2D.Coordinates>> needle2meshCoords;
    protected final Map<Integer, Texture2D> side2Texture;
    protected final Set<Matrix2D.Coordinates> updateCoordinates = new HashSet<Matrix2D.Coordinates>();
    protected final J3DEventListener needleListener;
    private final Map<J3DSurface.SurfaceShape, TimerTask> shape2GeometryTask = new HashMap<J3DSurface.SurfaceShape, TimerTask>();

    public static Parameters getDefaultParameters() {
        return new Parameters();
    }

    public J3DNeedleMesh(Matrix2D<J3DNeedle> needles, Color3f color, E3DMaterial material, E3DTextureFile texture, double roundness, Parameters parameters) {
        super(color);
        this.parameters = parameters;
        this.needles = needles;
        this.material = material;
        this.roundness = roundness;
        this.individualTexture = texture;
        this.side2Texture = new HashMap<Integer, Texture2D>();
        this.anchor = new TransformGroup();
        this.anchor.setCapability(14);
        this.anchor.setCapability(13);
        this.createTiles();
        this.setCapability(17);
        this.addChild((Node)this.anchor);
        this.needleListener = new J3DEventAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reshaped(J3DInstance object) {
                Set<Matrix2D.Coordinates> set = J3DNeedleMesh.this.updateCoordinates;
                synchronized (set) {
                    List<Matrix2D.Coordinates> coords = J3DNeedleMesh.this.needle2meshCoords.get(object);
                    if (coords != null) {
                        for (Matrix2D.Coordinates coord : coords) {
                            J3DNeedleMesh.this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x - 1, coord.y - 1));
                            J3DNeedleMesh.this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x, coord.y - 1));
                            J3DNeedleMesh.this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x - 1, coord.y));
                            J3DNeedleMesh.this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x, coord.y));
                        }
                    }
                }
            }

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
                this.reshaped(object);
            }
        };
        int y = 0;
        while (y < needles.height()) {
            int x = 0;
            while (x < needles.width()) {
                J3DNeedle needle = this.needles.get(x, y);
                if (needle != null && !needle.hasListener(this.needleListener)) {
                    needle.addEventListener(this.needleListener);
                }
                ++x;
            }
            ++y;
        }
        int w = needles.width();
        int h = needles.height();
        this.needle2meshCoords = new HashMap<J3DNeedle, List<Matrix2D.Coordinates>>(w * h);
        this.addCoordinates();
    }

    @Override
    public void dispose() {
        int y = 0;
        while (y < this.needles.height()) {
            int x = 0;
            while (x < this.needles.width()) {
                J3DNeedle needle = this.needles.get(x, y);
                if (needle != null) {
                    needle.removeEventListener(this.needleListener);
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void recreate() {
        this.createTiles();
        this.reshapeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BranchGroup createTiles() {
        Map<J3DSurface.SurfaceShape, TimerTask> map = this.shape2GeometryTask;
        synchronized (map) {
            BranchGroup tiles = new BranchGroup();
            tiles.setCapability(17);
            int cols = Math.max(1, this.needles.width() - 1);
            int rows = Math.max(1, this.needles.height() - 1);
            this.shapes = new Matrix2D<J3DSurface.SurfaceShape>(cols, rows, this.SURFACESHAPEFACTORY, null);
            int y = 0;
            while (y < this.shapes.height()) {
                int x = 0;
                while (x < this.shapes.width()) {
                    J3DSurface.SurfaceShape shape = new J3DSurface.SurfaceShape(this, this.color, this.parameters.polygonMode, this.parameters.shadeModel);
                    shape.setCapability(13);
                    shape.setTransparency(this.transparency);
                    if (this.parameters.polygonMode == 2) {
                        for (Map.Entry<Integer, Texture2D> sideTexture : this.side2Texture.entrySet()) {
                            int side = sideTexture.getKey();
                            Texture2D texture = sideTexture.getValue();
                            Appearance appearance = shape.getAppearance();
                            if (appearance.getTextureUnitState()[side] == null) continue;
                            appearance.getTextureUnitState()[side].setTexture((Texture)texture);
                        }
                    }
                    this.shapes.set(x, y, shape);
                    tiles.addChild((Node)shape);
                    ++x;
                }
                ++y;
            }
            this.anchor.removeAllChildren();
            this.anchor.addChild((Node)tiles);
            return tiles;
        }
    }

    private void addCoordinates() {
        int y = 0;
        while (y < this.needles.height()) {
            int x = 0;
            while (x < this.needles.width()) {
                J3DNeedle needle = this.needles.get(x, y);
                this.addCoordinate(x, y, needle);
                ++x;
            }
            ++y;
        }
    }

    private void addCoordinate(int x, int y, J3DNeedle needle) {
        if (needle != null) {
            List<Matrix2D.Coordinates> meshCoords = this.needle2meshCoords.get(needle);
            if (meshCoords == null) {
                meshCoords = new Vector<Matrix2D.Coordinates>();
                this.needle2meshCoords.put(needle, meshCoords);
            }
            meshCoords.add(new Matrix2D.Coordinates(x, y));
        }
    }

    private void rmCoordinate(int x, int y, J3DNeedle needle) {
        List<Matrix2D.Coordinates> meshCoords = this.needle2meshCoords.get(needle);
        if (meshCoords != null) {
            meshCoords.remove(new Matrix2D.Coordinates(x, y));
            if (meshCoords.isEmpty()) {
                this.needle2meshCoords.remove(needle);
            }
        }
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        int y = 0;
        while (y < this.shapes.height()) {
            int x = 0;
            while (x < this.shapes.width()) {
                J3DSurface.SurfaceShape shape = this.shapes.get(x, y);
                if (shape != null) {
                    if (selected) {
                        shape.getAppearance().getMaterial().setEmissiveColor(1.0f, 0.0f, 0.0f);
                    } else {
                        shape.getAppearance().getMaterial().setEmissiveColor(0.0f, 0.0f, 0.0f);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransparency(float transparency) {
        Map<J3DSurface.SurfaceShape, TimerTask> map = this.shape2GeometryTask;
        synchronized (map) {
            super.setTransparency(transparency);
            int y = 0;
            while (y < this.shapes.height()) {
                int x = 0;
                while (x < this.shapes.width()) {
                    J3DSurface.SurfaceShape shape = this.shapes.get(x, y);
                    if (shape != null) {
                        this.shapes.get(x, y).setTransparency(transparency);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    public void setColor(Color3f color) {
        Color3f dimmed = new Color3f(color.x * 0.7f, color.y * 0.7f, color.z * 0.7f);
        int y = 0;
        while (y < this.shapes.height()) {
            int x = 0;
            while (x < this.shapes.width()) {
                J3DSurface.SurfaceShape shape = this.shapes.get(x, y);
                if (shape != null) {
                    Appearance appearance = shape.getAppearance();
                    appearance.getMaterial().setAmbientColor(dimmed);
                    appearance.getMaterial().setDiffuseColor(dimmed);
                    appearance.getMaterial().setSpecularColor(dimmed);
                    appearance.getColoringAttributes().setColor(color);
                }
                ++x;
            }
            ++y;
        }
        this.color.set((Tuple3f)color);
    }

    @Override
    public void setMaterial(E3DMaterial material) {
        float shininess = material == null ? 64.0f : (float)(material.getGlossiness() * 127.0 + 1.0);
        int y = 0;
        while (y < this.shapes.height()) {
            int x = 0;
            while (x < this.shapes.width()) {
                J3DSurface.SurfaceShape shape = this.shapes.get(x, y);
                if (shape != null) {
                    shape.getAppearance().getMaterial().setShininess(shininess);
                }
                ++x;
            }
            ++y;
        }
        this.material = material;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTexture(Texture2D texture, int side) {
        Map<J3DSurface.SurfaceShape, TimerTask> map = this.shape2GeometryTask;
        synchronized (map) {
            if (texture == null) {
                this.side2Texture.remove(side);
            } else {
                this.side2Texture.put(side, texture);
            }
            if (this.parameters.polygonMode == 2) {
                int y = 0;
                while (y < this.shapes.height()) {
                    int x = 0;
                    while (x < this.shapes.width()) {
                        J3DSurface.SurfaceShape shape = this.shapes.get(x, y);
                        if (shape != null) {
                            Appearance appearance = shape.getAppearance();
                            if (texture == null) {
                                if (appearance.getTextureUnitState(side) != null) {
                                    appearance.getTextureUnitState(side).setTexture(null);
                                }
                            } else if (appearance.getTextureUnitState(side) != null) {
                                appearance.getTextureUnitState(side).setTexture((Texture)texture);
                            }
                        }
                        ++x;
                    }
                    ++y;
                }
            }
        }
    }

    @Override
    public Texture2D getTexture(int side) {
        return this.side2Texture.get(side);
    }

    @Override
    public int getNumberOfMasters() {
        return this.needle2meshCoords.size();
    }

    @Override
    public List<Matrix2D.Coordinates> getMeshCoordinates(J3DMasterObject needle) {
        return this.needle2meshCoords.get(needle);
    }

    public Matrix2D<J3DNeedle> getMasters() {
        return this.needles;
    }

    public Collection<J3DNeedle> getAllInRowOf(J3DMasterObject master) {
        HashSet<J3DNeedle> rowPoints = new HashSet<J3DNeedle>();
        List<Matrix2D.Coordinates> coords = this.needle2meshCoords.get(master);
        if (coords != null) {
            for (Matrix2D.Coordinates coord : coords) {
                int x = 0;
                while (x < this.needles.width()) {
                    J3DNeedle needle = this.needles.get(x, coord.y);
                    if (needle != null) {
                        rowPoints.add(needle);
                    }
                    ++x;
                }
            }
        }
        return rowPoints;
    }

    public Collection<J3DNeedle> getAllInColumnOf(J3DMasterObject master) {
        HashSet<J3DNeedle> colPoints = new HashSet<J3DNeedle>();
        List<Matrix2D.Coordinates> coords = this.needle2meshCoords.get(master);
        if (coords != null) {
            for (Matrix2D.Coordinates coord : coords) {
                int y = 0;
                while (y < this.needles.height()) {
                    J3DNeedle needle = this.needles.get(coord.x, y);
                    if (needle != null) {
                        colPoints.add(needle);
                    }
                    ++y;
                }
            }
        }
        return colPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroup(J3DGroup group) {
        Map<J3DSurface.SurfaceShape, TimerTask> map = this.shape2GeometryTask;
        synchronized (map) {
            for (Map.Entry<J3DSurface.SurfaceShape, TimerTask> shapeTask : this.shape2GeometryTask.entrySet()) {
                shapeTask.getValue().cancel();
            }
            this.group = group;
            if (group != null && group.isLive()) {
                this.reshapeAll();
            }
        }
    }

    @Override
    public void setRoundness(double roundness) {
        this.roundness = roundness;
        this.reshapeAll();
    }

    @Override
    public void orientate(J3DOrientedObject.Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL_MIRRORING: {
                this.needles.mirrorHorizontal();
                this.shapes.mirrorHorizontal();
                break;
            }
            case VERTICAL_MIRRORING: {
                this.needles.mirrorVertical();
                this.shapes.mirrorVertical();
                break;
            }
            case ROTATE_LEFT: {
                this.needles.rotateLeft();
                this.shapes.rotateLeft();
                break;
            }
            case ROTATE_RIGHT: {
                this.needles.rotateRight();
                this.shapes.rotateRight();
            }
        }
        this.addCoordinates();
        this.reshapeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape() {
        Map<J3DSurface.SurfaceShape, TimerTask> map = this.shape2GeometryTask;
        synchronized (map) {
            for (Matrix2D.Coordinates coord : this.updateCoordinates) {
                J3DSurface.SurfaceShape shape = this.shapes.get(coord.x, coord.y);
                TimerTask oldTask = this.shape2GeometryTask.get(shape);
                if (oldTask != null) {
                    oldTask.cancel();
                }
                Geometry geometry = this.createGeometry(coord.x, coord.y, this.parameters.minResolution);
                if (shape == null) continue;
                if (geometry != null) {
                    shape.setGeometry(geometry);
                    this.particularize(coord.x, coord.y, shape);
                    continue;
                }
                shape.removeAllGeometries();
                this.shapes.set(coord.x, coord.y, (J3DSurface.SurfaceShape)null);
            }
            this.updateCoordinates.clear();
            for (J3DEventListener listener : this.listeners) {
                listener.reshaped(this);
            }
        }
    }

    public void restore(int width, int height, J3DNeedle[] needles) {
        J3DNeedle needle;
        int x;
        int y = 0;
        while (y < this.needles.height()) {
            x = 0;
            while (x < this.needles.width()) {
                needle = this.needles.get(x, y);
                if (needle != null) {
                    needle.removeEventListener(this.needleListener);
                }
                ++x;
            }
            ++y;
        }
        this.needles.reshape(width, height, (J3DNeedle[])needles);
        this.createTiles();
        y = 0;
        while (y < this.needles.height()) {
            x = 0;
            while (x < this.needles.width()) {
                needle = this.needles.get(x, y);
                if (needle != null) {
                    needle.addEventListener(this.needleListener);
                }
                ++x;
            }
            ++y;
        }
        this.needle2meshCoords.clear();
        this.addCoordinates();
        this.reshapeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshapeAll() {
        Map<J3DSurface.SurfaceShape, TimerTask> map = this.shape2GeometryTask;
        synchronized (map) {
            int y = 0;
            while (y < this.shapes.height()) {
                int x = 0;
                while (x < this.shapes.width()) {
                    J3DSurface.SurfaceShape shape = this.shapes.get(x, y);
                    TimerTask task = this.shape2GeometryTask.get(shape);
                    if (task != null) {
                        task.cancel();
                    }
                    Geometry geometry = this.createGeometry(x, y, this.parameters.minResolution);
                    if (shape != null && geometry != null) {
                        shape.setGeometry(geometry);
                        this.particularize(x, y, shape);
                    }
                    ++x;
                }
                ++y;
            }
            this.updateCoordinates.clear();
        }
    }

    private void particularize(final int x, final int y, final J3DSurface.SurfaceShape shape) {
        if (this.parameters.maxResolution > this.parameters.minResolution) {
            TimerTask newTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = J3DNeedleMesh.this.shape2GeometryTask;
                    synchronized (map) {
                        Geometry fullGeometry = J3DNeedleMesh.this.createGeometry(x, y, J3DNeedleMesh.this.parameters.maxResolution);
                        if (fullGeometry != null) {
                            shape.setGeometry(fullGeometry);
                        }
                    }
                }
            };
            TIMER.schedule(newTask, this.parameters.resolutionDelay);
            this.shape2GeometryTask.put(shape, newTask);
        }
    }

    public void removeNeedle(J3DNeedle needle) {
        List<Matrix2D.Coordinates> coords = this.needle2meshCoords.remove(needle);
        if (coords != null) {
            for (Matrix2D.Coordinates coord : coords) {
                this.needles.set(coord.x, coord.y, (J3DNeedle)null);
                this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x - 1, coord.y - 1));
                this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x, coord.y - 1));
                this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x - 1, coord.y));
                this.updateCoordinates.add(new Matrix2D.Coordinates(coord.x, coord.y));
            }
        }
    }

    public void replaceNeedle(int x, int y, J3DNeedle newNeedle) {
        J3DNeedle oldNeedle = this.needles.get(x, y);
        if (oldNeedle != null) {
            this.rmCoordinate(x, y, oldNeedle);
            oldNeedle.removeEventListener(this.needleListener);
        }
        this.needles.set(x, y, newNeedle);
        this.addCoordinate(x, y, newNeedle);
        newNeedle.addEventListener(this.needleListener);
        this.updateCoordinates.add(new Matrix2D.Coordinates(x - 1, y - 1));
        this.updateCoordinates.add(new Matrix2D.Coordinates(x, y - 1));
        this.updateCoordinates.add(new Matrix2D.Coordinates(x - 1, y));
        this.updateCoordinates.add(new Matrix2D.Coordinates(x, y));
    }

    protected Geometry createGeometry(int col, int row, int resolution) {
        J3DNeedle needle1 = this.needles.get(col, row);
        J3DNeedle needle2 = this.needles.get(col + 1, row);
        J3DNeedle needle3 = this.needles.get(col + 1, row + 1);
        J3DNeedle needle4 = this.needles.get(col, row + 1);
        if (this.needles.width() == 1 && this.needles.height() == 1) {
            return null;
        }
        if (this.needles.width() == 1 && needle1 != null && needle4 != null) {
            return this.createGeometry(needle1.getTangent(), needle4.getTangent());
        }
        if (this.needles.height() == 1 && needle1 != null && needle2 != null) {
            return this.createGeometry(needle1.getTangent(), needle2.getTangent());
        }
        if (needle1 != null && needle2 != null && needle3 != null && needle4 != null) {
            return this.createGeometry(needle1.getTangent(), needle2.getTangent(), needle3.getTangent(), needle4.getTangent(), col, row, resolution);
        }
        return null;
    }

    private Geometry createGeometry(E3DTangent corner1, E3DTangent corner2, E3DTangent corner3, E3DTangent corner4, int col, int row, int resolution) {
        E3DTangent[] corners = new E3DTangent[]{corner1, corner2, corner3, corner4};
        double[] rnd = new double[]{this.roundness, this.roundness, this.roundness, this.roundness};
        Bezier4P4N bezier = new Bezier4P4N(corners, rnd, resolution, resolution);
        Matrix2D<E3DVector> mesh = new Matrix2D<E3DVector>(resolution, resolution, ArrayFactory.VECTOR3D, null);
        int x = 0;
        while (x < resolution) {
            int y = 0;
            while (y < resolution) {
                mesh.set(x, y, bezier.currentPoint().clone());
                bezier.nextRow();
                ++y;
            }
            bezier.nextCol();
            ++x;
        }
        return super.createGeometry(mesh, col, row, this.shapes.width(), this.shapes.height(), this.parameters.creaseAngle);
    }

    private Geometry createGeometry(E3DTangent start, E3DTangent end) {
        int res = this.parameters.maxResolution;
        BezierCurve2P2N bezier = new BezierCurve2P2N(start.point, start.normal, this.roundness, end.point, end.normal, this.roundness, res);
        E3DVector[] points = new E3DVector[res];
        int i = 0;
        while (i < res) {
            points[i] = bezier.current().clone();
            bezier.next();
            ++i;
        }
        return super.createGeometry(points, this.parameters.lineRadialPoints, this.parameters.lineRadius, this.parameters.creaseAngle);
    }

    public static class Parameters {
        public int polygonMode = 2;
        public int shadeModel = 0;
        public int maxResolution = 10;
        public int minResolution = 2;
        public long resolutionDelay = 250L;
        public int lineRadialPoints = 9;
        public double lineRadius = 0.001;
        public double creaseAngle = 1.0471975511965976;
    }
}

